<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Query ServiceType
 * @subpackage Services
 */
class Query extends AbstractSoapClientBase
{
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\Context $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\StructType\Context $context, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named QueryUniversalFlag
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\QueryUniversalFlagRequest $iFoundationService_QueryUniversalFlag_RequestMsg
     * @return \patest\StructType\QueryUniversalFlagResponse|bool
     */
    public function QueryUniversalFlag(\patest\StructType\QueryUniversalFlagRequest $iFoundationService_QueryUniversalFlag_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->QueryUniversalFlag($iFoundationService_QueryUniversalFlag_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named QueryGlobalMonitorsOffline
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\QueryGlobalMonitorsOfflineRequest $iTenantAdministrationService_QueryGlobalMonitorsOffline_RequestMsg
     * @return \patest\StructType\QueryGlobalMonitorsOfflineResponse|bool
     */
    public function QueryGlobalMonitorsOffline(\patest\StructType\QueryGlobalMonitorsOfflineRequest $iTenantAdministrationService_QueryGlobalMonitorsOffline_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->QueryGlobalMonitorsOffline($iTenantAdministrationService_QueryGlobalMonitorsOffline_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named QueryGlobalMonitorsOnline
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\QueryGlobalMonitorsOnlineRequest $iTenantAdministrationService_QueryGlobalMonitorsOnline_RequestMsg
     * @return \patest\StructType\QueryGlobalMonitorsOnlineResponse|bool
     */
    public function QueryGlobalMonitorsOnline(\patest\StructType\QueryGlobalMonitorsOnlineRequest $iTenantAdministrationService_QueryGlobalMonitorsOnline_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->QueryGlobalMonitorsOnline($iTenantAdministrationService_QueryGlobalMonitorsOnline_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Query
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\EntitiesQueryRequest $iSoapEntityManagementFacade_Query_RequestMsg
     * @return \patest\StructType\EntitiesQueryResponse|bool
     */
    public function Query(\patest\StructType\EntitiesQueryRequest $iSoapEntityManagementFacade_Query_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->Query($iSoapEntityManagementFacade_Query_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named QueryEntitiesFetchChunk
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\QueryEntitiesFetchChunkRequest $iSoapEntityManagementFacade_QueryEntitiesFetchChunk_RequestMsg
     * @return \patest\StructType\QueryEntitiesFetchChunkResponse|bool
     */
    public function QueryEntitiesFetchChunk(\patest\StructType\QueryEntitiesFetchChunkRequest $iSoapEntityManagementFacade_QueryEntitiesFetchChunk_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->QueryEntitiesFetchChunk($iSoapEntityManagementFacade_QueryEntitiesFetchChunk_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named QueryIdentityPlatformProperties
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\QueryIdentityPlatformProperties_Request $iAuthenticationFacade_QueryIdentityPlatformProperties_RequestMsg
     * @return \patest\StructType\QueryIdentityPlatformProperties_Response|bool
     */
    public function QueryIdentityPlatformProperties(\patest\StructType\QueryIdentityPlatformProperties_Request $iAuthenticationFacade_QueryIdentityPlatformProperties_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->QueryIdentityPlatformProperties($iAuthenticationFacade_QueryIdentityPlatformProperties_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named QueryActivePaymentPlans
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\QueryActivePaymentPlansRequest $iPaymentFacade_QueryActivePaymentPlans_RequestMsg
     * @return \patest\StructType\QueryActivePaymentPlansResponse|bool
     */
    public function QueryActivePaymentPlans(\patest\StructType\QueryActivePaymentPlansRequest $iPaymentFacade_QueryActivePaymentPlans_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->QueryActivePaymentPlans($iPaymentFacade_QueryActivePaymentPlans_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named QueryTransaction
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\QueryTransaction_Request $iSaleFacade_QueryTransaction_RequestMsg
     * @return \patest\StructType\QueryTransaction_Response|bool
     */
    public function QueryTransaction(\patest\StructType\QueryTransaction_Request $iSaleFacade_QueryTransaction_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->QueryTransaction($iSaleFacade_QueryTransaction_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named QueryTransactionState
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\QueryTransactionState_Request $iSaleFacade_QueryTransactionState_RequestMsg
     * @return \patest\StructType\QueryTransactionState_Response|bool
     */
    public function QueryTransactionState(\patest\StructType\QueryTransactionState_Request $iSaleFacade_QueryTransactionState_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->QueryTransactionState($iSaleFacade_QueryTransactionState_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named QueryGroupOfTransactions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\QueryGroupOfTransactions_Request $iSaleFacade_QueryGroupOfTransactions_RequestMsg
     * @return \patest\StructType\QueryGroupOfTransactions_Response|bool
     */
    public function QueryGroupOfTransactions(\patest\StructType\QueryGroupOfTransactions_Request $iSaleFacade_QueryGroupOfTransactions_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->QueryGroupOfTransactions($iSaleFacade_QueryGroupOfTransactions_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named QueryPricingVariationsCatalog
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\QueryPricingVariationsCatalogRequest $iSaleFacade_QueryPricingVariationsCatalog_RequestMsg
     * @return \patest\StructType\QueryPricingVariationsCatalogResponse|bool
     */
    public function QueryPricingVariationsCatalog(\patest\StructType\QueryPricingVariationsCatalogRequest $iSaleFacade_QueryPricingVariationsCatalog_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->QueryPricingVariationsCatalog($iSaleFacade_QueryPricingVariationsCatalog_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named QueryConnectionProperties
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\QueryConnectionProperties_Request $iSecurityFacade_QueryConnectionProperties_RequestMsg
     * @return \patest\StructType\QueryConnectionProperties_Response|bool
     */
    public function QueryConnectionProperties(\patest\StructType\QueryConnectionProperties_Request $iSecurityFacade_QueryConnectionProperties_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->QueryConnectionProperties($iSecurityFacade_QueryConnectionProperties_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named QueryParameters
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\QueryParameters_Request $iSecurityFacade_QueryParameters_RequestMsg
     * @return \patest\StructType\QueryParameters_Response|bool
     */
    public function QueryParameters(\patest\StructType\QueryParameters_Request $iSecurityFacade_QueryParameters_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->QueryParameters($iSecurityFacade_QueryParameters_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named QuerySeatingPlansAvailability
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\QueryMultipleSeatingPlansAvailabilityRequest $iTicketingFacade_QuerySeatingPlansAvailability_RequestMsg
     * @return \patest\StructType\QueryMultipleSeatingPlansAvailabilityResponse|bool
     */
    public function QuerySeatingPlansAvailability(\patest\StructType\QueryMultipleSeatingPlansAvailabilityRequest $iTicketingFacade_QuerySeatingPlansAvailability_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->QuerySeatingPlansAvailability($iTicketingFacade_QuerySeatingPlansAvailability_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\EntitiesQueryResponse|\patest\StructType\QueryActivePaymentPlansResponse|\patest\StructType\QueryConnectionProperties_Response|\patest\StructType\QueryEntitiesFetchChunkResponse|\patest\StructType\QueryGlobalMonitorsOfflineResponse|\patest\StructType\QueryGlobalMonitorsOnlineResponse|\patest\StructType\QueryGroupOfTransactions_Response|\patest\StructType\QueryIdentityPlatformProperties_Response|\patest\StructType\QueryMultipleSeatingPlansAvailabilityResponse|\patest\StructType\QueryParameters_Response|\patest\StructType\QueryPricingVariationsCatalogResponse|\patest\StructType\QueryTransactionState_Response|\patest\StructType\QueryTransaction_Response|\patest\StructType\QueryUniversalFlagResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
