<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Extended ServiceType
 * @subpackage Services
 */
class Extended extends AbstractSoapClientBase
{
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ExtendedConnect
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ExtendedConnect_Request $iSecurityFacade_ExtendedConnect_RequestMsg
     * @return \patest\StructType\Connect_Response|bool
     */
    public function ExtendedConnect(\patest\StructType\ExtendedConnect_Request $iSecurityFacade_ExtendedConnect_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ExtendedConnect($iSecurityFacade_ExtendedConnect_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\Connect_Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
