<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\Context $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\StructType\Context $context, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Delete
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\EntitiesCreateOrUpdateRequest $iSoapEntityManagementFacade_Delete_RequestMsg
     * @return \patest\StructType\EntitiesCreateOrUpdateResponse|bool
     */
    public function Delete(\patest\StructType\EntitiesCreateOrUpdateRequest $iSoapEntityManagementFacade_Delete_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->Delete($iSoapEntityManagementFacade_Delete_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteExternalAuthenticationData
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\DeleteExternalAuthenticationData_Request $iAuthenticationFacade_DeleteExternalAuthenticationData_RequestMsg
     * @return \patest\StructType\DeleteExternalAuthenticationData_Response|bool
     */
    public function DeleteExternalAuthenticationData(\patest\StructType\DeleteExternalAuthenticationData_Request $iAuthenticationFacade_DeleteExternalAuthenticationData_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteExternalAuthenticationData($iAuthenticationFacade_DeleteExternalAuthenticationData_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteClient
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\DeleteClient_Request $iCrmFacade_DeleteClient_RequestMsg
     * @return \patest\StructType\DeleteClient_Response|bool
     */
    public function DeleteClient(\patest\StructType\DeleteClient_Request $iCrmFacade_DeleteClient_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteClient($iCrmFacade_DeleteClient_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteTicketSchemeEnrollment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\DeleteTicketSchemeEnrollment_Request $iCrmFacade_DeleteTicketSchemeEnrollment_RequestMsg
     * @return \patest\StructType\DeleteTicketSchemeEnrollment_Response|bool
     */
    public function DeleteTicketSchemeEnrollment(\patest\StructType\DeleteTicketSchemeEnrollment_Request $iCrmFacade_DeleteTicketSchemeEnrollment_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteTicketSchemeEnrollment($iCrmFacade_DeleteTicketSchemeEnrollment_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteClientLink
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\DeleteClientLinkRequest $iEsroFacade_DeleteClientLink_RequestMsg
     * @return \patest\StructType\DeleteClientLinkResponse|bool
     */
    public function DeleteClientLink(\patest\StructType\DeleteClientLinkRequest $iEsroFacade_DeleteClientLink_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteClientLink($iEsroFacade_DeleteClientLink_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteDirectDebitRecordBatch
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\DeleteDirectDebitRecordsBatch_Request $iPaymentFacade_DeleteDirectDebitRecordBatch_RequestMsg
     * @return \patest\StructType\DeleteDirectDebitRecordsBatch_Response|bool
     */
    public function DeleteDirectDebitRecordBatch(\patest\StructType\DeleteDirectDebitRecordsBatch_Request $iPaymentFacade_DeleteDirectDebitRecordBatch_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteDirectDebitRecordBatch($iPaymentFacade_DeleteDirectDebitRecordBatch_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeletePresale
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\DeletePresale_Request $iTicketingFacade_DeletePresale_RequestMsg
     * @return \patest\StructType\DeletePresale_Response|bool
     */
    public function DeletePresale(\patest\StructType\DeletePresale_Request $iTicketingFacade_DeletePresale_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->DeletePresale($iTicketingFacade_DeletePresale_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteBallotApplication
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\DeleteBallotApplication_Request $iTicketingFacade_DeleteBallotApplication_RequestMsg
     * @return \patest\StructType\DeleteBallotApplication_Response|bool
     */
    public function DeleteBallotApplication(\patest\StructType\DeleteBallotApplication_Request $iTicketingFacade_DeleteBallotApplication_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteBallotApplication($iTicketingFacade_DeleteBallotApplication_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\DeleteBallotApplication_Response|\patest\StructType\DeleteClientLinkResponse|\patest\StructType\DeleteClient_Response|\patest\StructType\DeleteDirectDebitRecordsBatch_Response|\patest\StructType\DeleteExternalAuthenticationData_Response|\patest\StructType\DeletePresale_Response|\patest\StructType\DeleteTicketSchemeEnrollment_Response|\patest\StructType\EntitiesCreateOrUpdateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
