<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Apply ServiceType
 * @subpackage Services
 */
class Apply extends AbstractSoapClientBase
{
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\ArrayType\ArrayOfKeyValueOfstringstring $context, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ApplyClientTypeToClients
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ApplyClientTypeToClientsRequest $iCrmFacade_ApplyClientTypeToClients_RequestMsg
     * @return \patest\StructType\ApplyClientTypeToClientsResponse|bool
     */
    public function ApplyClientTypeToClients(\patest\StructType\ApplyClientTypeToClientsRequest $iCrmFacade_ApplyClientTypeToClients_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ApplyClientTypeToClients($iCrmFacade_ApplyClientTypeToClients_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ApplyChangeToPaymentPlanInstallments
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ApplyChangeToPaymentPlanInstallments_Request $iPaymentFacade_ApplyChangeToPaymentPlanInstallments_RequestMsg
     * @return \patest\StructType\ApplyChangeToPaymentPlanInstallments_Response|bool
     */
    public function ApplyChangeToPaymentPlanInstallments(\patest\StructType\ApplyChangeToPaymentPlanInstallments_Request $iPaymentFacade_ApplyChangeToPaymentPlanInstallments_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ApplyChangeToPaymentPlanInstallments($iPaymentFacade_ApplyChangeToPaymentPlanInstallments_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApplyLayers
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ApplyLayer_Request $iTicketingFacade_ApplyLayers_RequestMsg
     * @return \patest\StructType\ApplyLayer_Response|bool
     */
    public function ApplyLayers(\patest\StructType\ApplyLayer_Request $iTicketingFacade_ApplyLayers_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ApplyLayers($iTicketingFacade_ApplyLayers_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\ApplyChangeToPaymentPlanInstallments_Response|\patest\StructType\ApplyClientTypeToClientsResponse|\patest\StructType\ApplyLayer_Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
