<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for SeatToSessionRelation EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatToSessionRelation
 * @subpackage Enumerations
 */
class SeatToSessionRelation extends AbstractStructEnumBase
{
    /**
     * Constant for value 'NotRelated'
     * @return string 'NotRelated'
     */
    const VALUE_NOT_RELATED = 'NotRelated';
    /**
     * Constant for value 'Taken'
     * @return string 'Taken'
     */
    const VALUE_TAKEN = 'Taken';
    /**
     * Constant for value 'Returned'
     * @return string 'Returned'
     */
    const VALUE_RETURNED = 'Returned';
    /**
     * Constant for value 'ReservedForMe'
     * @return string 'ReservedForMe'
     */
    const VALUE_RESERVED_FOR_ME = 'ReservedForMe';
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_RELATED
     * @uses self::VALUE_TAKEN
     * @uses self::VALUE_RETURNED
     * @uses self::VALUE_RESERVED_FOR_ME
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_RELATED,
            self::VALUE_TAKEN,
            self::VALUE_RETURNED,
            self::VALUE_RESERVED_FOR_ME,
        );
    }
}
