<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for SeatPropertyNames EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatPropertyNames
 * @subpackage Enumerations
 */
class SeatPropertyNames extends AbstractStructEnumBase
{
    /**
     * Constant for value 'EffectiveAvailability'
     * @return string 'EffectiveAvailability'
     */
    const VALUE_EFFECTIVE_AVAILABILITY = 'EffectiveAvailability';
    /**
     * Constant for value 'SeatStatus'
     * @return string 'SeatStatus'
     */
    const VALUE_SEAT_STATUS = 'SeatStatus';
    /**
     * Constant for value 'ApplicationChannel'
     * @return string 'ApplicationChannel'
     */
    const VALUE_APPLICATION_CHANNEL = 'ApplicationChannel';
    /**
     * Constant for value 'SaleModeId'
     * @return string 'SaleModeId'
     */
    const VALUE_SALE_MODE_ID = 'SaleModeId';
    /**
     * Constant for value 'Restrictions'
     * @return string 'Restrictions'
     */
    const VALUE_RESTRICTIONS = 'Restrictions';
    /**
     * Constant for value 'IsSubscriberSeat'
     * @return string 'IsSubscriberSeat'
     */
    const VALUE_IS_SUBSCRIBER_SEAT = 'IsSubscriberSeat';
    /**
     * Constant for value 'IsBonusTicket'
     * @return string 'IsBonusTicket'
     */
    const VALUE_IS_BONUS_TICKET = 'IsBonusTicket';
    /**
     * Constant for value 'IsComplimentaryTicket'
     * @return string 'IsComplimentaryTicket'
     */
    const VALUE_IS_COMPLIMENTARY_TICKET = 'IsComplimentaryTicket';
    /**
     * Constant for value 'IsOccupiedByPeer'
     * @return string 'IsOccupiedByPeer'
     */
    const VALUE_IS_OCCUPIED_BY_PEER = 'IsOccupiedByPeer';
    /**
     * Constant for value 'IsAwaitingForPrinting'
     * @return string 'IsAwaitingForPrinting'
     */
    const VALUE_IS_AWAITING_FOR_PRINTING = 'IsAwaitingForPrinting';
    /**
     * Constant for value 'SeatInventoryType'
     * @return string 'SeatInventoryType'
     */
    const VALUE_SEAT_INVENTORY_TYPE = 'SeatInventoryType';
    /**
     * Constant for value 'SeatInventoryLiabilityStatus'
     * @return string 'SeatInventoryLiabilityStatus'
     */
    const VALUE_SEAT_INVENTORY_LIABILITY_STATUS = 'SeatInventoryLiabilityStatus';
    /**
     * Constant for value 'IsResale'
     * @return string 'IsResale'
     */
    const VALUE_IS_RESALE = 'IsResale';
    /**
     * Constant for value 'IsScanned'
     * @return string 'IsScanned'
     */
    const VALUE_IS_SCANNED = 'IsScanned';
    /**
     * Constant for value 'PriceLevelId'
     * @return string 'PriceLevelId'
     */
    const VALUE_PRICE_LEVEL_ID = 'PriceLevelId';
    /**
     * Constant for value 'AvailablePriceTypes'
     * @return string 'AvailablePriceTypes'
     */
    const VALUE_AVAILABLE_PRICE_TYPES = 'AvailablePriceTypes';
    /**
     * Constant for value 'SoldAtPriceLevelId'
     * @return string 'SoldAtPriceLevelId'
     */
    const VALUE_SOLD_AT_PRICE_LEVEL_ID = 'SoldAtPriceLevelId';
    /**
     * Constant for value 'SoldAtPriceTypeId'
     * @return string 'SoldAtPriceTypeId'
     */
    const VALUE_SOLD_AT_PRICE_TYPE_ID = 'SoldAtPriceTypeId';
    /**
     * Constant for value 'SoldAtPricingVariationId'
     * @return string 'SoldAtPricingVariationId'
     */
    const VALUE_SOLD_AT_PRICING_VARIATION_ID = 'SoldAtPricingVariationId';
    /**
     * Constant for value 'SeatName'
     * @return string 'SeatName'
     */
    const VALUE_SEAT_NAME = 'SeatName';
    /**
     * Constant for value 'RowName'
     * @return string 'RowName'
     */
    const VALUE_ROW_NAME = 'RowName';
    /**
     * Constant for value 'SectorName'
     * @return string 'SectorName'
     */
    const VALUE_SECTOR_NAME = 'SectorName';
    /**
     * Constant for value 'HasPriceOverride'
     * @return string 'HasPriceOverride'
     */
    const VALUE_HAS_PRICE_OVERRIDE = 'HasPriceOverride';
    /**
     * Constant for value 'SeatPricingInfo'
     * @return string 'SeatPricingInfo'
     */
    const VALUE_SEAT_PRICING_INFO = 'SeatPricingInfo';
    /**
     * Constant for value 'ResoldAtPricingVariationId'
     * @return string 'ResoldAtPricingVariationId'
     */
    const VALUE_RESOLD_AT_PRICING_VARIATION_ID = 'ResoldAtPricingVariationId';
    /**
     * Constant for value 'IsTransfer'
     * @return string 'IsTransfer'
     */
    const VALUE_IS_TRANSFER = 'IsTransfer';
    /**
     * Constant for value 'CustomSeatPrice'
     * @return string 'CustomSeatPrice'
     */
    const VALUE_CUSTOM_SEAT_PRICE = 'CustomSeatPrice';
    /**
     * Return allowed values
     * @uses self::VALUE_EFFECTIVE_AVAILABILITY
     * @uses self::VALUE_SEAT_STATUS
     * @uses self::VALUE_APPLICATION_CHANNEL
     * @uses self::VALUE_SALE_MODE_ID
     * @uses self::VALUE_RESTRICTIONS
     * @uses self::VALUE_IS_SUBSCRIBER_SEAT
     * @uses self::VALUE_IS_BONUS_TICKET
     * @uses self::VALUE_IS_COMPLIMENTARY_TICKET
     * @uses self::VALUE_IS_OCCUPIED_BY_PEER
     * @uses self::VALUE_IS_AWAITING_FOR_PRINTING
     * @uses self::VALUE_SEAT_INVENTORY_TYPE
     * @uses self::VALUE_SEAT_INVENTORY_LIABILITY_STATUS
     * @uses self::VALUE_IS_RESALE
     * @uses self::VALUE_IS_SCANNED
     * @uses self::VALUE_PRICE_LEVEL_ID
     * @uses self::VALUE_AVAILABLE_PRICE_TYPES
     * @uses self::VALUE_SOLD_AT_PRICE_LEVEL_ID
     * @uses self::VALUE_SOLD_AT_PRICE_TYPE_ID
     * @uses self::VALUE_SOLD_AT_PRICING_VARIATION_ID
     * @uses self::VALUE_SEAT_NAME
     * @uses self::VALUE_ROW_NAME
     * @uses self::VALUE_SECTOR_NAME
     * @uses self::VALUE_HAS_PRICE_OVERRIDE
     * @uses self::VALUE_SEAT_PRICING_INFO
     * @uses self::VALUE_RESOLD_AT_PRICING_VARIATION_ID
     * @uses self::VALUE_IS_TRANSFER
     * @uses self::VALUE_CUSTOM_SEAT_PRICE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EFFECTIVE_AVAILABILITY,
            self::VALUE_SEAT_STATUS,
            self::VALUE_APPLICATION_CHANNEL,
            self::VALUE_SALE_MODE_ID,
            self::VALUE_RESTRICTIONS,
            self::VALUE_IS_SUBSCRIBER_SEAT,
            self::VALUE_IS_BONUS_TICKET,
            self::VALUE_IS_COMPLIMENTARY_TICKET,
            self::VALUE_IS_OCCUPIED_BY_PEER,
            self::VALUE_IS_AWAITING_FOR_PRINTING,
            self::VALUE_SEAT_INVENTORY_TYPE,
            self::VALUE_SEAT_INVENTORY_LIABILITY_STATUS,
            self::VALUE_IS_RESALE,
            self::VALUE_IS_SCANNED,
            self::VALUE_PRICE_LEVEL_ID,
            self::VALUE_AVAILABLE_PRICE_TYPES,
            self::VALUE_SOLD_AT_PRICE_LEVEL_ID,
            self::VALUE_SOLD_AT_PRICE_TYPE_ID,
            self::VALUE_SOLD_AT_PRICING_VARIATION_ID,
            self::VALUE_SEAT_NAME,
            self::VALUE_ROW_NAME,
            self::VALUE_SECTOR_NAME,
            self::VALUE_HAS_PRICE_OVERRIDE,
            self::VALUE_SEAT_PRICING_INFO,
            self::VALUE_RESOLD_AT_PRICING_VARIATION_ID,
            self::VALUE_IS_TRANSFER,
            self::VALUE_CUSTOM_SEAT_PRICE,
        );
    }
}
