<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for CustodyStatus EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustodyStatus
 * @subpackage Enumerations
 */
class CustodyStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Distributed'
     * @return string 'Distributed'
     */
    const VALUE_DISTRIBUTED = 'Distributed';
    /**
     * Constant for value 'PendingResale'
     * @return string 'PendingResale'
     */
    const VALUE_PENDING_RESALE = 'PendingResale';
    /**
     * Constant for value 'Resold'
     * @return string 'Resold'
     */
    const VALUE_RESOLD = 'Resold';
    /**
     * Constant for value 'ResoldRefunded'
     * @return string 'ResoldRefunded'
     */
    const VALUE_RESOLD_REFUNDED = 'ResoldRefunded';
    /**
     * Constant for value 'RefundFailed'
     * @return string 'RefundFailed'
     */
    const VALUE_REFUND_FAILED = 'RefundFailed';
    /**
     * Constant for value 'FromResale'
     * @return string 'FromResale'
     */
    const VALUE_FROM_RESALE = 'FromResale';
    /**
     * Constant for value 'Transferred'
     * @return string 'Transferred'
     */
    const VALUE_TRANSFERRED = 'Transferred';
    /**
     * Constant for value 'TransferredRefunded'
     * @return string 'TransferredRefunded'
     */
    const VALUE_TRANSFERRED_REFUNDED = 'TransferredRefunded';
    /**
     * Constant for value 'FromTransfer'
     * @return string 'FromTransfer'
     */
    const VALUE_FROM_TRANSFER = 'FromTransfer';
    /**
     * Constant for value 'Returned'
     * @return string 'Returned'
     */
    const VALUE_RETURNED = 'Returned';
    /**
     * Constant for value 'PendingTransfer'
     * @return string 'PendingTransfer'
     */
    const VALUE_PENDING_TRANSFER = 'PendingTransfer';
    /**
     * Return allowed values
     * @uses self::VALUE_DISTRIBUTED
     * @uses self::VALUE_PENDING_RESALE
     * @uses self::VALUE_RESOLD
     * @uses self::VALUE_RESOLD_REFUNDED
     * @uses self::VALUE_REFUND_FAILED
     * @uses self::VALUE_FROM_RESALE
     * @uses self::VALUE_TRANSFERRED
     * @uses self::VALUE_TRANSFERRED_REFUNDED
     * @uses self::VALUE_FROM_TRANSFER
     * @uses self::VALUE_RETURNED
     * @uses self::VALUE_PENDING_TRANSFER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DISTRIBUTED,
            self::VALUE_PENDING_RESALE,
            self::VALUE_RESOLD,
            self::VALUE_RESOLD_REFUNDED,
            self::VALUE_REFUND_FAILED,
            self::VALUE_FROM_RESALE,
            self::VALUE_TRANSFERRED,
            self::VALUE_TRANSFERRED_REFUNDED,
            self::VALUE_FROM_TRANSFER,
            self::VALUE_RETURNED,
            self::VALUE_PENDING_TRANSFER,
        );
    }
}
