<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ClassTreeLevel EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ClassTreeLevel
 * @subpackage Enumerations
 */
class ClassTreeLevel extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Regular'
     * @return string 'Regular'
     */
    const VALUE_REGULAR = 'Regular';
    /**
     * Constant for value 'Native'
     * @return string 'Native'
     */
    const VALUE_NATIVE = 'Native';
    /**
     * Constant for value 'Both'
     * @return string 'Both'
     */
    const VALUE_BOTH = 'Both';
    /**
     * Return allowed values
     * @uses self::VALUE_REGULAR
     * @uses self::VALUE_NATIVE
     * @uses self::VALUE_BOTH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REGULAR,
            self::VALUE_NATIVE,
            self::VALUE_BOTH,
        );
    }
}
