<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ActivityGroupType EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ActivityGroupType
 * @subpackage Enumerations
 */
class ActivityGroupType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'ClientInformation'
     * @return string 'ClientInformation'
     */
    const VALUE_CLIENT_INFORMATION = 'ClientInformation';
    /**
     * Constant for value 'Tickets'
     * @return string 'Tickets'
     */
    const VALUE_TICKETS = 'Tickets';
    /**
     * Constant for value 'SubscriberTickets'
     * @return string 'SubscriberTickets'
     */
    const VALUE_SUBSCRIBER_TICKETS = 'SubscriberTickets';
    /**
     * Constant for value 'Subscriptions'
     * @return string 'Subscriptions'
     */
    const VALUE_SUBSCRIPTIONS = 'Subscriptions';
    /**
     * Constant for value 'TicketSchemes'
     * @return string 'TicketSchemes'
     */
    const VALUE_TICKET_SCHEMES = 'TicketSchemes';
    /**
     * Constant for value 'Memberships'
     * @return string 'Memberships'
     */
    const VALUE_MEMBERSHIPS = 'Memberships';
    /**
     * Constant for value 'AutoRenewals'
     * @return string 'AutoRenewals'
     */
    const VALUE_AUTO_RENEWALS = 'AutoRenewals';
    /**
     * Constant for value 'Donations'
     * @return string 'Donations'
     */
    const VALUE_DONATIONS = 'Donations';
    /**
     * Constant for value 'GiftVouchers'
     * @return string 'GiftVouchers'
     */
    const VALUE_GIFT_VOUCHERS = 'GiftVouchers';
    /**
     * Constant for value 'Merchandise'
     * @return string 'Merchandise'
     */
    const VALUE_MERCHANDISE = 'Merchandise';
    /**
     * Constant for value 'Payments'
     * @return string 'Payments'
     */
    const VALUE_PAYMENTS = 'Payments';
    /**
     * Constant for value 'ServiceRequests'
     * @return string 'ServiceRequests'
     */
    const VALUE_SERVICE_REQUESTS = 'ServiceRequests';
    /**
     * Return allowed values
     * @uses self::VALUE_CLIENT_INFORMATION
     * @uses self::VALUE_TICKETS
     * @uses self::VALUE_SUBSCRIBER_TICKETS
     * @uses self::VALUE_SUBSCRIPTIONS
     * @uses self::VALUE_TICKET_SCHEMES
     * @uses self::VALUE_MEMBERSHIPS
     * @uses self::VALUE_AUTO_RENEWALS
     * @uses self::VALUE_DONATIONS
     * @uses self::VALUE_GIFT_VOUCHERS
     * @uses self::VALUE_MERCHANDISE
     * @uses self::VALUE_PAYMENTS
     * @uses self::VALUE_SERVICE_REQUESTS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CLIENT_INFORMATION,
            self::VALUE_TICKETS,
            self::VALUE_SUBSCRIBER_TICKETS,
            self::VALUE_SUBSCRIPTIONS,
            self::VALUE_TICKET_SCHEMES,
            self::VALUE_MEMBERSHIPS,
            self::VALUE_AUTO_RENEWALS,
            self::VALUE_DONATIONS,
            self::VALUE_GIFT_VOUCHERS,
            self::VALUE_MERCHANDISE,
            self::VALUE_PAYMENTS,
            self::VALUE_SERVICE_REQUESTS,
        );
    }
}
