<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSessionServiceConfigurationDto ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfSessionServiceConfigurationDto
 * @subpackage Arrays
 */
class ArrayOfSessionServiceConfigurationDto extends AbstractStructArrayBase
{
    /**
     * The SessionServiceConfigurationDto
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SessionServiceConfigurationDto[]
     */
    public $SessionServiceConfigurationDto;
    /**
     * Constructor method for ArrayOfSessionServiceConfigurationDto
     * @uses ArrayOfSessionServiceConfigurationDto::setSessionServiceConfigurationDto()
     * @param \patest\StructType\SessionServiceConfigurationDto[] $sessionServiceConfigurationDto
     */
    public function __construct(array $sessionServiceConfigurationDto = array())
    {
        $this
            ->setSessionServiceConfigurationDto($sessionServiceConfigurationDto);
    }
    /**
     * Get SessionServiceConfigurationDto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SessionServiceConfigurationDto[]|null
     */
    public function getSessionServiceConfigurationDto()
    {
        return isset($this->SessionServiceConfigurationDto) ? $this->SessionServiceConfigurationDto : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSessionServiceConfigurationDto method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSessionServiceConfigurationDto method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSessionServiceConfigurationDtoForArrayConstraintsFromSetSessionServiceConfigurationDto(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSessionServiceConfigurationDtoSessionServiceConfigurationDtoItem) {
            // validation for constraint: itemType
            if (!$arrayOfSessionServiceConfigurationDtoSessionServiceConfigurationDtoItem instanceof \patest\StructType\SessionServiceConfigurationDto) {
                $invalidValues[] = is_object($arrayOfSessionServiceConfigurationDtoSessionServiceConfigurationDtoItem) ? get_class($arrayOfSessionServiceConfigurationDtoSessionServiceConfigurationDtoItem) : sprintf('%s(%s)', gettype($arrayOfSessionServiceConfigurationDtoSessionServiceConfigurationDtoItem), var_export($arrayOfSessionServiceConfigurationDtoSessionServiceConfigurationDtoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SessionServiceConfigurationDto property can only contain items of type \patest\StructType\SessionServiceConfigurationDto, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SessionServiceConfigurationDto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\SessionServiceConfigurationDto[] $sessionServiceConfigurationDto
     * @return \patest\ArrayType\ArrayOfSessionServiceConfigurationDto
     */
    public function setSessionServiceConfigurationDto(array $sessionServiceConfigurationDto = array())
    {
        // validation for constraint: array
        if ('' !== ($sessionServiceConfigurationDtoArrayErrorMessage = self::validateSessionServiceConfigurationDtoForArrayConstraintsFromSetSessionServiceConfigurationDto($sessionServiceConfigurationDto))) {
            throw new \InvalidArgumentException($sessionServiceConfigurationDtoArrayErrorMessage, __LINE__);
        }
        if (is_null($sessionServiceConfigurationDto) || (is_array($sessionServiceConfigurationDto) && empty($sessionServiceConfigurationDto))) {
            unset($this->SessionServiceConfigurationDto);
        } else {
            $this->SessionServiceConfigurationDto = $sessionServiceConfigurationDto;
        }
        return $this;
    }
    /**
     * Add item to SessionServiceConfigurationDto value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\SessionServiceConfigurationDto $item
     * @return \patest\ArrayType\ArrayOfSessionServiceConfigurationDto
     */
    public function addToSessionServiceConfigurationDto(\patest\StructType\SessionServiceConfigurationDto $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\SessionServiceConfigurationDto) {
            throw new \InvalidArgumentException(sprintf('The SessionServiceConfigurationDto property can only contain items of type \patest\StructType\SessionServiceConfigurationDto, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SessionServiceConfigurationDto[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\SessionServiceConfigurationDto|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\SessionServiceConfigurationDto|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\SessionServiceConfigurationDto|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\SessionServiceConfigurationDto|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\SessionServiceConfigurationDto|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SessionServiceConfigurationDto
     */
    public function getAttributeName()
    {
        return 'SessionServiceConfigurationDto';
    }
}
