<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSalePointInfo ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfSalePointInfo
 * @subpackage Arrays
 */
class ArrayOfSalePointInfo extends AbstractStructArrayBase
{
    /**
     * The SalePointInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SalePointInfo[]
     */
    public $SalePointInfo;
    /**
     * Constructor method for ArrayOfSalePointInfo
     * @uses ArrayOfSalePointInfo::setSalePointInfo()
     * @param \patest\StructType\SalePointInfo[] $salePointInfo
     */
    public function __construct(array $salePointInfo = array())
    {
        $this
            ->setSalePointInfo($salePointInfo);
    }
    /**
     * Get SalePointInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SalePointInfo[]|null
     */
    public function getSalePointInfo()
    {
        return isset($this->SalePointInfo) ? $this->SalePointInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSalePointInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSalePointInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSalePointInfoForArrayConstraintsFromSetSalePointInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSalePointInfoSalePointInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfSalePointInfoSalePointInfoItem instanceof \patest\StructType\SalePointInfo) {
                $invalidValues[] = is_object($arrayOfSalePointInfoSalePointInfoItem) ? get_class($arrayOfSalePointInfoSalePointInfoItem) : sprintf('%s(%s)', gettype($arrayOfSalePointInfoSalePointInfoItem), var_export($arrayOfSalePointInfoSalePointInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SalePointInfo property can only contain items of type \patest\StructType\SalePointInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SalePointInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\SalePointInfo[] $salePointInfo
     * @return \patest\ArrayType\ArrayOfSalePointInfo
     */
    public function setSalePointInfo(array $salePointInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($salePointInfoArrayErrorMessage = self::validateSalePointInfoForArrayConstraintsFromSetSalePointInfo($salePointInfo))) {
            throw new \InvalidArgumentException($salePointInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($salePointInfo) || (is_array($salePointInfo) && empty($salePointInfo))) {
            unset($this->SalePointInfo);
        } else {
            $this->SalePointInfo = $salePointInfo;
        }
        return $this;
    }
    /**
     * Add item to SalePointInfo value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\SalePointInfo $item
     * @return \patest\ArrayType\ArrayOfSalePointInfo
     */
    public function addToSalePointInfo(\patest\StructType\SalePointInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\SalePointInfo) {
            throw new \InvalidArgumentException(sprintf('The SalePointInfo property can only contain items of type \patest\StructType\SalePointInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SalePointInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\SalePointInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\SalePointInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\SalePointInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\SalePointInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\SalePointInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SalePointInfo
     */
    public function getAttributeName()
    {
        return 'SalePointInfo';
    }
}
