<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOpenedShiftData ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfOpenedShiftData
 * @subpackage Arrays
 */
class ArrayOfOpenedShiftData extends AbstractStructArrayBase
{
    /**
     * The OpenedShiftData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\OpenedShiftData[]
     */
    public $OpenedShiftData;
    /**
     * Constructor method for ArrayOfOpenedShiftData
     * @uses ArrayOfOpenedShiftData::setOpenedShiftData()
     * @param \patest\StructType\OpenedShiftData[] $openedShiftData
     */
    public function __construct(array $openedShiftData = array())
    {
        $this
            ->setOpenedShiftData($openedShiftData);
    }
    /**
     * Get OpenedShiftData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\OpenedShiftData[]|null
     */
    public function getOpenedShiftData()
    {
        return isset($this->OpenedShiftData) ? $this->OpenedShiftData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOpenedShiftData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOpenedShiftData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOpenedShiftDataForArrayConstraintsFromSetOpenedShiftData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfOpenedShiftDataOpenedShiftDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfOpenedShiftDataOpenedShiftDataItem instanceof \patest\StructType\OpenedShiftData) {
                $invalidValues[] = is_object($arrayOfOpenedShiftDataOpenedShiftDataItem) ? get_class($arrayOfOpenedShiftDataOpenedShiftDataItem) : sprintf('%s(%s)', gettype($arrayOfOpenedShiftDataOpenedShiftDataItem), var_export($arrayOfOpenedShiftDataOpenedShiftDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OpenedShiftData property can only contain items of type \patest\StructType\OpenedShiftData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OpenedShiftData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\OpenedShiftData[] $openedShiftData
     * @return \patest\ArrayType\ArrayOfOpenedShiftData
     */
    public function setOpenedShiftData(array $openedShiftData = array())
    {
        // validation for constraint: array
        if ('' !== ($openedShiftDataArrayErrorMessage = self::validateOpenedShiftDataForArrayConstraintsFromSetOpenedShiftData($openedShiftData))) {
            throw new \InvalidArgumentException($openedShiftDataArrayErrorMessage, __LINE__);
        }
        if (is_null($openedShiftData) || (is_array($openedShiftData) && empty($openedShiftData))) {
            unset($this->OpenedShiftData);
        } else {
            $this->OpenedShiftData = $openedShiftData;
        }
        return $this;
    }
    /**
     * Add item to OpenedShiftData value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\OpenedShiftData $item
     * @return \patest\ArrayType\ArrayOfOpenedShiftData
     */
    public function addToOpenedShiftData(\patest\StructType\OpenedShiftData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\OpenedShiftData) {
            throw new \InvalidArgumentException(sprintf('The OpenedShiftData property can only contain items of type \patest\StructType\OpenedShiftData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OpenedShiftData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\OpenedShiftData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\OpenedShiftData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\OpenedShiftData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\OpenedShiftData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\OpenedShiftData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OpenedShiftData
     */
    public function getAttributeName()
    {
        return 'OpenedShiftData';
    }
}
