<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMerchandise.ItemType ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfMerchandise.ItemType
 * @subpackage Arrays
 */
class ArrayOfMerchandise_ItemType extends AbstractStructArrayBase
{
    /**
     * The Merchandise_ItemType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Merchandise_ItemType[]
     */
    public $Merchandise_ItemType;
    /**
     * Constructor method for ArrayOfMerchandise.ItemType
     * @uses ArrayOfMerchandise_ItemType::setMerchandise_ItemType()
     * @param \patest\StructType\Merchandise_ItemType[] $merchandise_ItemType
     */
    public function __construct(array $merchandise_ItemType = array())
    {
        $this
            ->setMerchandise_ItemType($merchandise_ItemType);
    }
    /**
     * Get Merchandise_ItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Merchandise_ItemType[]|null
     */
    public function getMerchandise_ItemType()
    {
        return isset($this->{'Merchandise.ItemType'}) ? $this->{'Merchandise.ItemType'} : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMerchandise_ItemType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMerchandise_ItemType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMerchandise_ItemTypeForArrayConstraintsFromSetMerchandise_ItemType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMerchandise_ItemTypeMerchandise_ItemTypeItem) {
            // validation for constraint: itemType
            if (!$arrayOfMerchandise_ItemTypeMerchandise_ItemTypeItem instanceof \patest\StructType\Merchandise_ItemType) {
                $invalidValues[] = is_object($arrayOfMerchandise_ItemTypeMerchandise_ItemTypeItem) ? get_class($arrayOfMerchandise_ItemTypeMerchandise_ItemTypeItem) : sprintf('%s(%s)', gettype($arrayOfMerchandise_ItemTypeMerchandise_ItemTypeItem), var_export($arrayOfMerchandise_ItemTypeMerchandise_ItemTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Merchandise_ItemType property can only contain items of type \patest\StructType\Merchandise_ItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Merchandise_ItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\Merchandise_ItemType[] $merchandise_ItemType
     * @return \patest\ArrayType\ArrayOfMerchandise_ItemType
     */
    public function setMerchandise_ItemType(array $merchandise_ItemType = array())
    {
        // validation for constraint: array
        if ('' !== ($merchandise_ItemTypeArrayErrorMessage = self::validateMerchandise_ItemTypeForArrayConstraintsFromSetMerchandise_ItemType($merchandise_ItemType))) {
            throw new \InvalidArgumentException($merchandise_ItemTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($merchandise_ItemType) || (is_array($merchandise_ItemType) && empty($merchandise_ItemType))) {
            unset($this->Merchandise_ItemType, $this->{'Merchandise.ItemType'});
        } else {
            $this->Merchandise_ItemType = $this->{'Merchandise.ItemType'} = $merchandise_ItemType;
        }
        return $this;
    }
    /**
     * Add item to Merchandise_ItemType value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\Merchandise_ItemType $item
     * @return \patest\ArrayType\ArrayOfMerchandise_ItemType
     */
    public function addToMerchandise_ItemType(\patest\StructType\Merchandise_ItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\Merchandise_ItemType) {
            throw new \InvalidArgumentException(sprintf('The Merchandise_ItemType property can only contain items of type \patest\StructType\Merchandise_ItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Merchandise_ItemType[] = $this->{'Merchandise.ItemType'}[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\Merchandise_ItemType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\Merchandise_ItemType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\Merchandise_ItemType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\Merchandise_ItemType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\Merchandise_ItemType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Merchandise.ItemType
     */
    public function getAttributeName()
    {
        return 'Merchandise.ItemType';
    }
}
