<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCrm.Client ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCrm.Client
 * @subpackage Arrays
 */
class ArrayOfCrm_Client extends AbstractStructArrayBase
{
    /**
     * The Crm_Client
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_Client[]
     */
    public $Crm_Client;
    /**
     * Constructor method for ArrayOfCrm.Client
     * @uses ArrayOfCrm_Client::setCrm_Client()
     * @param \patest\StructType\Crm_Client[] $crm_Client
     */
    public function __construct(array $crm_Client = array())
    {
        $this
            ->setCrm_Client($crm_Client);
    }
    /**
     * Get Crm_Client value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_Client[]|null
     */
    public function getCrm_Client()
    {
        return isset($this->{'Crm.Client'}) ? $this->{'Crm.Client'} : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCrm_Client method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCrm_Client method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCrm_ClientForArrayConstraintsFromSetCrm_Client(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCrm_ClientCrm_ClientItem) {
            // validation for constraint: itemType
            if (!$arrayOfCrm_ClientCrm_ClientItem instanceof \patest\StructType\Crm_Client) {
                $invalidValues[] = is_object($arrayOfCrm_ClientCrm_ClientItem) ? get_class($arrayOfCrm_ClientCrm_ClientItem) : sprintf('%s(%s)', gettype($arrayOfCrm_ClientCrm_ClientItem), var_export($arrayOfCrm_ClientCrm_ClientItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Crm_Client property can only contain items of type \patest\StructType\Crm_Client, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Crm_Client value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\Crm_Client[] $crm_Client
     * @return \patest\ArrayType\ArrayOfCrm_Client
     */
    public function setCrm_Client(array $crm_Client = array())
    {
        // validation for constraint: array
        if ('' !== ($crm_ClientArrayErrorMessage = self::validateCrm_ClientForArrayConstraintsFromSetCrm_Client($crm_Client))) {
            throw new \InvalidArgumentException($crm_ClientArrayErrorMessage, __LINE__);
        }
        if (is_null($crm_Client) || (is_array($crm_Client) && empty($crm_Client))) {
            unset($this->Crm_Client, $this->{'Crm.Client'});
        } else {
            $this->Crm_Client = $this->{'Crm.Client'} = $crm_Client;
        }
        return $this;
    }
    /**
     * Add item to Crm_Client value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\Crm_Client $item
     * @return \patest\ArrayType\ArrayOfCrm_Client
     */
    public function addToCrm_Client(\patest\StructType\Crm_Client $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\Crm_Client) {
            throw new \InvalidArgumentException(sprintf('The Crm_Client property can only contain items of type \patest\StructType\Crm_Client, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Crm_Client[] = $this->{'Crm.Client'}[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\Crm_Client|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\Crm_Client|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\Crm_Client|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\Crm_Client|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\Crm_Client|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Crm.Client
     */
    public function getAttributeName()
    {
        return 'Crm.Client';
    }
}
