<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCodeDescription ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCodeDescription
 * @subpackage Arrays
 */
class ArrayOfCodeDescription extends AbstractStructArrayBase
{
    /**
     * The CodeDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CodeDescription[]
     */
    public $CodeDescription;
    /**
     * Constructor method for ArrayOfCodeDescription
     * @uses ArrayOfCodeDescription::setCodeDescription()
     * @param \patest\StructType\CodeDescription[] $codeDescription
     */
    public function __construct(array $codeDescription = array())
    {
        $this
            ->setCodeDescription($codeDescription);
    }
    /**
     * Get CodeDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CodeDescription[]|null
     */
    public function getCodeDescription()
    {
        return isset($this->CodeDescription) ? $this->CodeDescription : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCodeDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCodeDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCodeDescriptionForArrayConstraintsFromSetCodeDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCodeDescriptionCodeDescriptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfCodeDescriptionCodeDescriptionItem instanceof \patest\StructType\CodeDescription) {
                $invalidValues[] = is_object($arrayOfCodeDescriptionCodeDescriptionItem) ? get_class($arrayOfCodeDescriptionCodeDescriptionItem) : sprintf('%s(%s)', gettype($arrayOfCodeDescriptionCodeDescriptionItem), var_export($arrayOfCodeDescriptionCodeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CodeDescription property can only contain items of type \patest\StructType\CodeDescription, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CodeDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\CodeDescription[] $codeDescription
     * @return \patest\ArrayType\ArrayOfCodeDescription
     */
    public function setCodeDescription(array $codeDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($codeDescriptionArrayErrorMessage = self::validateCodeDescriptionForArrayConstraintsFromSetCodeDescription($codeDescription))) {
            throw new \InvalidArgumentException($codeDescriptionArrayErrorMessage, __LINE__);
        }
        if (is_null($codeDescription) || (is_array($codeDescription) && empty($codeDescription))) {
            unset($this->CodeDescription);
        } else {
            $this->CodeDescription = $codeDescription;
        }
        return $this;
    }
    /**
     * Add item to CodeDescription value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\CodeDescription $item
     * @return \patest\ArrayType\ArrayOfCodeDescription
     */
    public function addToCodeDescription(\patest\StructType\CodeDescription $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\CodeDescription) {
            throw new \InvalidArgumentException(sprintf('The CodeDescription property can only contain items of type \patest\StructType\CodeDescription, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CodeDescription[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\CodeDescription|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\CodeDescription|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\CodeDescription|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\CodeDescription|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\CodeDescription|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CodeDescription
     */
    public function getAttributeName()
    {
        return 'CodeDescription';
    }
}
