<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBundleElementConfiguration ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfBundleElementConfiguration
 * @subpackage Arrays
 */
class ArrayOfBundleElementConfiguration extends AbstractStructArrayBase
{
    /**
     * The BundleElementConfiguration
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\BundleElementConfiguration[]
     */
    public $BundleElementConfiguration;
    /**
     * Constructor method for ArrayOfBundleElementConfiguration
     * @uses ArrayOfBundleElementConfiguration::setBundleElementConfiguration()
     * @param \patest\StructType\BundleElementConfiguration[] $bundleElementConfiguration
     */
    public function __construct(array $bundleElementConfiguration = array())
    {
        $this
            ->setBundleElementConfiguration($bundleElementConfiguration);
    }
    /**
     * Get BundleElementConfiguration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\BundleElementConfiguration[]|null
     */
    public function getBundleElementConfiguration()
    {
        return isset($this->BundleElementConfiguration) ? $this->BundleElementConfiguration : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBundleElementConfiguration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBundleElementConfiguration method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBundleElementConfigurationForArrayConstraintsFromSetBundleElementConfiguration(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBundleElementConfigurationBundleElementConfigurationItem) {
            // validation for constraint: itemType
            if (!$arrayOfBundleElementConfigurationBundleElementConfigurationItem instanceof \patest\StructType\BundleElementConfiguration) {
                $invalidValues[] = is_object($arrayOfBundleElementConfigurationBundleElementConfigurationItem) ? get_class($arrayOfBundleElementConfigurationBundleElementConfigurationItem) : sprintf('%s(%s)', gettype($arrayOfBundleElementConfigurationBundleElementConfigurationItem), var_export($arrayOfBundleElementConfigurationBundleElementConfigurationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BundleElementConfiguration property can only contain items of type \patest\StructType\BundleElementConfiguration, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BundleElementConfiguration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\BundleElementConfiguration[] $bundleElementConfiguration
     * @return \patest\ArrayType\ArrayOfBundleElementConfiguration
     */
    public function setBundleElementConfiguration(array $bundleElementConfiguration = array())
    {
        // validation for constraint: array
        if ('' !== ($bundleElementConfigurationArrayErrorMessage = self::validateBundleElementConfigurationForArrayConstraintsFromSetBundleElementConfiguration($bundleElementConfiguration))) {
            throw new \InvalidArgumentException($bundleElementConfigurationArrayErrorMessage, __LINE__);
        }
        if (is_null($bundleElementConfiguration) || (is_array($bundleElementConfiguration) && empty($bundleElementConfiguration))) {
            unset($this->BundleElementConfiguration);
        } else {
            $this->BundleElementConfiguration = $bundleElementConfiguration;
        }
        return $this;
    }
    /**
     * Add item to BundleElementConfiguration value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\BundleElementConfiguration $item
     * @return \patest\ArrayType\ArrayOfBundleElementConfiguration
     */
    public function addToBundleElementConfiguration(\patest\StructType\BundleElementConfiguration $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\BundleElementConfiguration) {
            throw new \InvalidArgumentException(sprintf('The BundleElementConfiguration property can only contain items of type \patest\StructType\BundleElementConfiguration, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BundleElementConfiguration[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\BundleElementConfiguration|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\BundleElementConfiguration|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\BundleElementConfiguration|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\BundleElementConfiguration|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\BundleElementConfiguration|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BundleElementConfiguration
     */
    public function getAttributeName()
    {
        return 'BundleElementConfiguration';
    }
}
