<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WithdrawPendingTransferTicketsDetails-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WithdrawPendingTransferTicketsDetails-Request
 * @subpackage Structs
 */
class WithdrawPendingTransferTicketsDetails_Request extends AbstractStructBase
{
    /**
     * The HasUserCanceled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasUserCanceled;
    /**
     * The Module
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Module;
    /**
     * The SelectedTicketsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SelectedTicketsCount;
    /**
     * The TicketsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TicketsCount;
    /**
     * Constructor method for WithdrawPendingTransferTicketsDetails-Request
     * @uses WithdrawPendingTransferTicketsDetails_Request::setHasUserCanceled()
     * @uses WithdrawPendingTransferTicketsDetails_Request::setModule()
     * @uses WithdrawPendingTransferTicketsDetails_Request::setSelectedTicketsCount()
     * @uses WithdrawPendingTransferTicketsDetails_Request::setTicketsCount()
     * @param bool $hasUserCanceled
     * @param string $module
     * @param int $selectedTicketsCount
     * @param int $ticketsCount
     */
    public function __construct($hasUserCanceled = null, $module = null, $selectedTicketsCount = null, $ticketsCount = null)
    {
        $this
            ->setHasUserCanceled($hasUserCanceled)
            ->setModule($module)
            ->setSelectedTicketsCount($selectedTicketsCount)
            ->setTicketsCount($ticketsCount);
    }
    /**
     * Get HasUserCanceled value
     * @return bool|null
     */
    public function getHasUserCanceled()
    {
        return $this->HasUserCanceled;
    }
    /**
     * Set HasUserCanceled value
     * @param bool $hasUserCanceled
     * @return \patest\StructType\WithdrawPendingTransferTicketsDetails_Request
     */
    public function setHasUserCanceled($hasUserCanceled = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasUserCanceled) && !is_bool($hasUserCanceled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasUserCanceled, true), gettype($hasUserCanceled)), __LINE__);
        }
        $this->HasUserCanceled = $hasUserCanceled;
        return $this;
    }
    /**
     * Get Module value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModule()
    {
        return isset($this->Module) ? $this->Module : null;
    }
    /**
     * Set Module value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $module
     * @return \patest\StructType\WithdrawPendingTransferTicketsDetails_Request
     */
    public function setModule($module = null)
    {
        // validation for constraint: string
        if (!is_null($module) && !is_string($module)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($module, true), gettype($module)), __LINE__);
        }
        if (is_null($module) || (is_array($module) && empty($module))) {
            unset($this->Module);
        } else {
            $this->Module = $module;
        }
        return $this;
    }
    /**
     * Get SelectedTicketsCount value
     * @return int|null
     */
    public function getSelectedTicketsCount()
    {
        return $this->SelectedTicketsCount;
    }
    /**
     * Set SelectedTicketsCount value
     * @param int $selectedTicketsCount
     * @return \patest\StructType\WithdrawPendingTransferTicketsDetails_Request
     */
    public function setSelectedTicketsCount($selectedTicketsCount = null)
    {
        // validation for constraint: int
        if (!is_null($selectedTicketsCount) && !(is_int($selectedTicketsCount) || ctype_digit($selectedTicketsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($selectedTicketsCount, true), gettype($selectedTicketsCount)), __LINE__);
        }
        $this->SelectedTicketsCount = $selectedTicketsCount;
        return $this;
    }
    /**
     * Get TicketsCount value
     * @return int|null
     */
    public function getTicketsCount()
    {
        return $this->TicketsCount;
    }
    /**
     * Set TicketsCount value
     * @param int $ticketsCount
     * @return \patest\StructType\WithdrawPendingTransferTicketsDetails_Request
     */
    public function setTicketsCount($ticketsCount = null)
    {
        // validation for constraint: int
        if (!is_null($ticketsCount) && !(is_int($ticketsCount) || ctype_digit($ticketsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketsCount, true), gettype($ticketsCount)), __LINE__);
        }
        $this->TicketsCount = $ticketsCount;
        return $this;
    }
}
