<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WithdrawDepositsToBasket-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WithdrawDepositsToBasket-Response
 * @subpackage Structs
 */
class WithdrawDepositsToBasket_Response extends ExtensibleDataContract
{
    /**
     * The InsertedItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfint
     */
    public $InsertedItemIds;
    /**
     * The ResumeRequired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ResumeRequired;
    /**
     * The TransactionSnapshot
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TransactionSnapshot
     */
    public $TransactionSnapshot;
    /**
     * The ActuallyPaidAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $ActuallyPaidAmount;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfCodeDescription
     */
    public $Warnings;
    /**
     * Constructor method for WithdrawDepositsToBasket-Response
     * @uses WithdrawDepositsToBasket_Response::setInsertedItemIds()
     * @uses WithdrawDepositsToBasket_Response::setResumeRequired()
     * @uses WithdrawDepositsToBasket_Response::setTransactionSnapshot()
     * @uses WithdrawDepositsToBasket_Response::setActuallyPaidAmount()
     * @uses WithdrawDepositsToBasket_Response::setWarnings()
     * @param \patest\ArrayType\ArrayOfint $insertedItemIds
     * @param bool $resumeRequired
     * @param \patest\StructType\TransactionSnapshot $transactionSnapshot
     * @param \patest\StructType\Money $actuallyPaidAmount
     * @param \patest\ArrayType\ArrayOfCodeDescription $warnings
     */
    public function __construct(\patest\ArrayType\ArrayOfint $insertedItemIds = null, $resumeRequired = null, \patest\StructType\TransactionSnapshot $transactionSnapshot = null, \patest\StructType\Money $actuallyPaidAmount = null, \patest\ArrayType\ArrayOfCodeDescription $warnings = null)
    {
        $this
            ->setInsertedItemIds($insertedItemIds)
            ->setResumeRequired($resumeRequired)
            ->setTransactionSnapshot($transactionSnapshot)
            ->setActuallyPaidAmount($actuallyPaidAmount)
            ->setWarnings($warnings);
    }
    /**
     * Get InsertedItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfint|null
     */
    public function getInsertedItemIds()
    {
        return isset($this->InsertedItemIds) ? $this->InsertedItemIds : null;
    }
    /**
     * Set InsertedItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfint $insertedItemIds
     * @return \patest\StructType\WithdrawDepositsToBasket_Response
     */
    public function setInsertedItemIds(\patest\ArrayType\ArrayOfint $insertedItemIds = null)
    {
        if (is_null($insertedItemIds) || (is_array($insertedItemIds) && empty($insertedItemIds))) {
            unset($this->InsertedItemIds);
        } else {
            $this->InsertedItemIds = $insertedItemIds;
        }
        return $this;
    }
    /**
     * Get ResumeRequired value
     * @return bool|null
     */
    public function getResumeRequired()
    {
        return $this->ResumeRequired;
    }
    /**
     * Set ResumeRequired value
     * @param bool $resumeRequired
     * @return \patest\StructType\WithdrawDepositsToBasket_Response
     */
    public function setResumeRequired($resumeRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($resumeRequired) && !is_bool($resumeRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($resumeRequired, true), gettype($resumeRequired)), __LINE__);
        }
        $this->ResumeRequired = $resumeRequired;
        return $this;
    }
    /**
     * Get TransactionSnapshot value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TransactionSnapshot|null
     */
    public function getTransactionSnapshot()
    {
        return isset($this->TransactionSnapshot) ? $this->TransactionSnapshot : null;
    }
    /**
     * Set TransactionSnapshot value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TransactionSnapshot $transactionSnapshot
     * @return \patest\StructType\WithdrawDepositsToBasket_Response
     */
    public function setTransactionSnapshot(\patest\StructType\TransactionSnapshot $transactionSnapshot = null)
    {
        if (is_null($transactionSnapshot) || (is_array($transactionSnapshot) && empty($transactionSnapshot))) {
            unset($this->TransactionSnapshot);
        } else {
            $this->TransactionSnapshot = $transactionSnapshot;
        }
        return $this;
    }
    /**
     * Get ActuallyPaidAmount value
     * @return \patest\StructType\Money|null
     */
    public function getActuallyPaidAmount()
    {
        return $this->ActuallyPaidAmount;
    }
    /**
     * Set ActuallyPaidAmount value
     * @param \patest\StructType\Money $actuallyPaidAmount
     * @return \patest\StructType\WithdrawDepositsToBasket_Response
     */
    public function setActuallyPaidAmount(\patest\StructType\Money $actuallyPaidAmount = null)
    {
        $this->ActuallyPaidAmount = $actuallyPaidAmount;
        return $this;
    }
    /**
     * Get Warnings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfCodeDescription|null
     */
    public function getWarnings()
    {
        return isset($this->Warnings) ? $this->Warnings : null;
    }
    /**
     * Set Warnings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfCodeDescription $warnings
     * @return \patest\StructType\WithdrawDepositsToBasket_Response
     */
    public function setWarnings(\patest\ArrayType\ArrayOfCodeDescription $warnings = null)
    {
        if (is_null($warnings) || (is_array($warnings) && empty($warnings))) {
            unset($this->Warnings);
        } else {
            $this->Warnings = $warnings;
        }
        return $this;
    }
}
