<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WithdrawDepositPaymentItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WithdrawDepositPaymentItem
 * @subpackage Structs
 */
class WithdrawDepositPaymentItem extends AbstractPaymentItem
{
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $Balance;
    /**
     * The ContinuationDeposit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Payment_Deposit
     */
    public $ContinuationDeposit;
    /**
     * The Deposit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Payment_Deposit
     */
    public $Deposit;
    /**
     * Constructor method for WithdrawDepositPaymentItem
     * @uses WithdrawDepositPaymentItem::setBalance()
     * @uses WithdrawDepositPaymentItem::setContinuationDeposit()
     * @uses WithdrawDepositPaymentItem::setDeposit()
     * @param \patest\StructType\Money $balance
     * @param \patest\StructType\Payment_Deposit $continuationDeposit
     * @param \patest\StructType\Payment_Deposit $deposit
     */
    public function __construct(\patest\StructType\Money $balance = null, \patest\StructType\Payment_Deposit $continuationDeposit = null, \patest\StructType\Payment_Deposit $deposit = null)
    {
        $this
            ->setBalance($balance)
            ->setContinuationDeposit($continuationDeposit)
            ->setDeposit($deposit);
    }
    /**
     * Get Balance value
     * @return \patest\StructType\Money|null
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param \patest\StructType\Money $balance
     * @return \patest\StructType\WithdrawDepositPaymentItem
     */
    public function setBalance(\patest\StructType\Money $balance = null)
    {
        $this->Balance = $balance;
        return $this;
    }
    /**
     * Get ContinuationDeposit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Payment_Deposit|null
     */
    public function getContinuationDeposit()
    {
        return isset($this->ContinuationDeposit) ? $this->ContinuationDeposit : null;
    }
    /**
     * Set ContinuationDeposit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Payment_Deposit $continuationDeposit
     * @return \patest\StructType\WithdrawDepositPaymentItem
     */
    public function setContinuationDeposit(\patest\StructType\Payment_Deposit $continuationDeposit = null)
    {
        if (is_null($continuationDeposit) || (is_array($continuationDeposit) && empty($continuationDeposit))) {
            unset($this->ContinuationDeposit);
        } else {
            $this->ContinuationDeposit = $continuationDeposit;
        }
        return $this;
    }
    /**
     * Get Deposit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Payment_Deposit|null
     */
    public function getDeposit()
    {
        return isset($this->Deposit) ? $this->Deposit : null;
    }
    /**
     * Set Deposit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Payment_Deposit $deposit
     * @return \patest\StructType\WithdrawDepositPaymentItem
     */
    public function setDeposit(\patest\StructType\Payment_Deposit $deposit = null)
    {
        if (is_null($deposit) || (is_array($deposit) && empty($deposit))) {
            unset($this->Deposit);
        } else {
            $this->Deposit = $deposit;
        }
        return $this;
    }
}
