<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VersionAreaDesign StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:VersionAreaDesign
 * @subpackage Structs
 */
class VersionAreaDesign extends AbstractStructBase
{
    /**
     * The AreaLevelViewXaml
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AreaLevelViewXaml;
    /**
     * The AreaMapGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaMapGuid;
    /**
     * The BackgroundImageIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfint
     */
    public $BackgroundImageIds;
    /**
     * The BestAvailableReservation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $BestAvailableReservation;
    /**
     * The HallLevelViewXaml
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HallLevelViewXaml;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Ordinal;
    /**
     * The ParentVersionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ParentVersionGuid;
    /**
     * The ViewFromAreaImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ViewFromAreaImageId;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The SeatingType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SeatingType;
    /**
     * Constructor method for VersionAreaDesign
     * @uses VersionAreaDesign::setAreaLevelViewXaml()
     * @uses VersionAreaDesign::setAreaMapGuid()
     * @uses VersionAreaDesign::setBackgroundImageIds()
     * @uses VersionAreaDesign::setBestAvailableReservation()
     * @uses VersionAreaDesign::setHallLevelViewXaml()
     * @uses VersionAreaDesign::setOrdinal()
     * @uses VersionAreaDesign::setParentVersionGuid()
     * @uses VersionAreaDesign::setViewFromAreaImageId()
     * @uses VersionAreaDesign::setAreaId()
     * @uses VersionAreaDesign::setSeatingType()
     * @param string $areaLevelViewXaml
     * @param string $areaMapGuid
     * @param \patest\ArrayType\ArrayOfint $backgroundImageIds
     * @param bool $bestAvailableReservation
     * @param string $hallLevelViewXaml
     * @param int $ordinal
     * @param string $parentVersionGuid
     * @param int $viewFromAreaImageId
     * @param string $areaId
     * @param string $seatingType
     */
    public function __construct($areaLevelViewXaml = null, $areaMapGuid = null, \patest\ArrayType\ArrayOfint $backgroundImageIds = null, $bestAvailableReservation = null, $hallLevelViewXaml = null, $ordinal = null, $parentVersionGuid = null, $viewFromAreaImageId = null, $areaId = null, $seatingType = null)
    {
        $this
            ->setAreaLevelViewXaml($areaLevelViewXaml)
            ->setAreaMapGuid($areaMapGuid)
            ->setBackgroundImageIds($backgroundImageIds)
            ->setBestAvailableReservation($bestAvailableReservation)
            ->setHallLevelViewXaml($hallLevelViewXaml)
            ->setOrdinal($ordinal)
            ->setParentVersionGuid($parentVersionGuid)
            ->setViewFromAreaImageId($viewFromAreaImageId)
            ->setAreaId($areaId)
            ->setSeatingType($seatingType);
    }
    /**
     * Get AreaLevelViewXaml value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaLevelViewXaml()
    {
        return isset($this->AreaLevelViewXaml) ? $this->AreaLevelViewXaml : null;
    }
    /**
     * Set AreaLevelViewXaml value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaLevelViewXaml
     * @return \patest\StructType\VersionAreaDesign
     */
    public function setAreaLevelViewXaml($areaLevelViewXaml = null)
    {
        // validation for constraint: string
        if (!is_null($areaLevelViewXaml) && !is_string($areaLevelViewXaml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaLevelViewXaml, true), gettype($areaLevelViewXaml)), __LINE__);
        }
        if (is_null($areaLevelViewXaml) || (is_array($areaLevelViewXaml) && empty($areaLevelViewXaml))) {
            unset($this->AreaLevelViewXaml);
        } else {
            $this->AreaLevelViewXaml = $areaLevelViewXaml;
        }
        return $this;
    }
    /**
     * Get AreaMapGuid value
     * @return string|null
     */
    public function getAreaMapGuid()
    {
        return $this->AreaMapGuid;
    }
    /**
     * Set AreaMapGuid value
     * @param string $areaMapGuid
     * @return \patest\StructType\VersionAreaDesign
     */
    public function setAreaMapGuid($areaMapGuid = null)
    {
        // validation for constraint: string
        if (!is_null($areaMapGuid) && !is_string($areaMapGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaMapGuid, true), gettype($areaMapGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaMapGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaMapGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaMapGuid, true)), __LINE__);
        }
        $this->AreaMapGuid = $areaMapGuid;
        return $this;
    }
    /**
     * Get BackgroundImageIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfint|null
     */
    public function getBackgroundImageIds()
    {
        return isset($this->BackgroundImageIds) ? $this->BackgroundImageIds : null;
    }
    /**
     * Set BackgroundImageIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfint $backgroundImageIds
     * @return \patest\StructType\VersionAreaDesign
     */
    public function setBackgroundImageIds(\patest\ArrayType\ArrayOfint $backgroundImageIds = null)
    {
        if (is_null($backgroundImageIds) || (is_array($backgroundImageIds) && empty($backgroundImageIds))) {
            unset($this->BackgroundImageIds);
        } else {
            $this->BackgroundImageIds = $backgroundImageIds;
        }
        return $this;
    }
    /**
     * Get BestAvailableReservation value
     * @return bool|null
     */
    public function getBestAvailableReservation()
    {
        return $this->BestAvailableReservation;
    }
    /**
     * Set BestAvailableReservation value
     * @param bool $bestAvailableReservation
     * @return \patest\StructType\VersionAreaDesign
     */
    public function setBestAvailableReservation($bestAvailableReservation = null)
    {
        // validation for constraint: boolean
        if (!is_null($bestAvailableReservation) && !is_bool($bestAvailableReservation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bestAvailableReservation, true), gettype($bestAvailableReservation)), __LINE__);
        }
        $this->BestAvailableReservation = $bestAvailableReservation;
        return $this;
    }
    /**
     * Get HallLevelViewXaml value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallLevelViewXaml()
    {
        return isset($this->HallLevelViewXaml) ? $this->HallLevelViewXaml : null;
    }
    /**
     * Set HallLevelViewXaml value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallLevelViewXaml
     * @return \patest\StructType\VersionAreaDesign
     */
    public function setHallLevelViewXaml($hallLevelViewXaml = null)
    {
        // validation for constraint: string
        if (!is_null($hallLevelViewXaml) && !is_string($hallLevelViewXaml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallLevelViewXaml, true), gettype($hallLevelViewXaml)), __LINE__);
        }
        if (is_null($hallLevelViewXaml) || (is_array($hallLevelViewXaml) && empty($hallLevelViewXaml))) {
            unset($this->HallLevelViewXaml);
        } else {
            $this->HallLevelViewXaml = $hallLevelViewXaml;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * @return int|null
     */
    public function getOrdinal()
    {
        return $this->Ordinal;
    }
    /**
     * Set Ordinal value
     * @param int $ordinal
     * @return \patest\StructType\VersionAreaDesign
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        $this->Ordinal = $ordinal;
        return $this;
    }
    /**
     * Get ParentVersionGuid value
     * @return string|null
     */
    public function getParentVersionGuid()
    {
        return $this->ParentVersionGuid;
    }
    /**
     * Set ParentVersionGuid value
     * @param string $parentVersionGuid
     * @return \patest\StructType\VersionAreaDesign
     */
    public function setParentVersionGuid($parentVersionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($parentVersionGuid) && !is_string($parentVersionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentVersionGuid, true), gettype($parentVersionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($parentVersionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $parentVersionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($parentVersionGuid, true)), __LINE__);
        }
        $this->ParentVersionGuid = $parentVersionGuid;
        return $this;
    }
    /**
     * Get ViewFromAreaImageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getViewFromAreaImageId()
    {
        return isset($this->ViewFromAreaImageId) ? $this->ViewFromAreaImageId : null;
    }
    /**
     * Set ViewFromAreaImageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $viewFromAreaImageId
     * @return \patest\StructType\VersionAreaDesign
     */
    public function setViewFromAreaImageId($viewFromAreaImageId = null)
    {
        // validation for constraint: int
        if (!is_null($viewFromAreaImageId) && !(is_int($viewFromAreaImageId) || ctype_digit($viewFromAreaImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($viewFromAreaImageId, true), gettype($viewFromAreaImageId)), __LINE__);
        }
        if (is_null($viewFromAreaImageId) || (is_array($viewFromAreaImageId) && empty($viewFromAreaImageId))) {
            unset($this->ViewFromAreaImageId);
        } else {
            $this->ViewFromAreaImageId = $viewFromAreaImageId;
        }
        return $this;
    }
    /**
     * Get AreaId value
     * @return string|null
     */
    public function getAreaId()
    {
        return $this->AreaId;
    }
    /**
     * Set AreaId value
     * @param string $areaId
     * @return \patest\StructType\VersionAreaDesign
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        $this->AreaId = $areaId;
        return $this;
    }
    /**
     * Get SeatingType value
     * @return string|null
     */
    public function getSeatingType()
    {
        return $this->SeatingType;
    }
    /**
     * Set SeatingType value
     * @uses \patest\EnumType\AreaSeatingType::valueIsValid()
     * @uses \patest\EnumType\AreaSeatingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seatingType
     * @return \patest\StructType\VersionAreaDesign
     */
    public function setSeatingType($seatingType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AreaSeatingType::valueIsValid($seatingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AreaSeatingType', is_array($seatingType) ? implode(', ', $seatingType) : var_export($seatingType, true), implode(', ', \patest\EnumType\AreaSeatingType::getValidValues())), __LINE__);
        }
        $this->SeatingType = $seatingType;
        return $this;
    }
}
