<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerifyLogin-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:VerifyLogin-Request
 * @subpackage Structs
 */
class VerifyLogin_Request extends AbstractStructBase
{
    /**
     * The LoginName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoginName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Password;
    /**
     * Constructor method for VerifyLogin-Request
     * @uses VerifyLogin_Request::setLoginName()
     * @uses VerifyLogin_Request::setPassword()
     * @param string $loginName
     * @param string $password
     */
    public function __construct($loginName = null, $password = null)
    {
        $this
            ->setLoginName($loginName)
            ->setPassword($password);
    }
    /**
     * Get LoginName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoginName()
    {
        return isset($this->LoginName) ? $this->LoginName : null;
    }
    /**
     * Set LoginName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loginName
     * @return \patest\StructType\VerifyLogin_Request
     */
    public function setLoginName($loginName = null)
    {
        // validation for constraint: string
        if (!is_null($loginName) && !is_string($loginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginName, true), gettype($loginName)), __LINE__);
        }
        if (is_null($loginName) || (is_array($loginName) && empty($loginName))) {
            unset($this->LoginName);
        } else {
            $this->LoginName = $loginName;
        }
        return $this;
    }
    /**
     * Get Password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->Password) ? $this->Password : null;
    }
    /**
     * Set Password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \patest\StructType\VerifyLogin_Request
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->Password);
        } else {
            $this->Password = $password;
        }
        return $this;
    }
}
