<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * ValidateForAnyClientsContainedInAnotherBallotApplicationRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ValidateForAnyClientsContainedInAnotherBallotApplicationRequest
 * @subpackage Structs
 */
class ValidateForAnyClientsContainedInAnotherBallotApplicationRequest extends AbstractStructBase
{
    /**
     * The BallotId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotId;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The OwnerIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $OwnerIds;
    /**
     * Constructor method for
     * ValidateForAnyClientsContainedInAnotherBallotApplicationRequest
     * @uses ValidateForAnyClientsContainedInAnotherBallotApplicationRequest::setBallotId()
     * @uses ValidateForAnyClientsContainedInAnotherBallotApplicationRequest::setClientId()
     * @uses ValidateForAnyClientsContainedInAnotherBallotApplicationRequest::setOwnerIds()
     * @param string $ballotId
     * @param string $clientId
     * @param \patest\ArrayType\ArrayOfguid $ownerIds
     */
    public function __construct($ballotId = null, $clientId = null, \patest\ArrayType\ArrayOfguid $ownerIds = null)
    {
        $this
            ->setBallotId($ballotId)
            ->setClientId($clientId)
            ->setOwnerIds($ownerIds);
    }
    /**
     * Get BallotId value
     * @return string|null
     */
    public function getBallotId()
    {
        return $this->BallotId;
    }
    /**
     * Set BallotId value
     * @param string $ballotId
     * @return \patest\StructType\ValidateForAnyClientsContainedInAnotherBallotApplicationRequest
     */
    public function setBallotId($ballotId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotId) && !is_string($ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotId, true), gettype($ballotId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotId, true)), __LINE__);
        }
        $this->BallotId = $ballotId;
        return $this;
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \patest\StructType\ValidateForAnyClientsContainedInAnotherBallotApplicationRequest
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
    /**
     * Get OwnerIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getOwnerIds()
    {
        return isset($this->OwnerIds) ? $this->OwnerIds : null;
    }
    /**
     * Set OwnerIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $ownerIds
     * @return \patest\StructType\ValidateForAnyClientsContainedInAnotherBallotApplicationRequest
     */
    public function setOwnerIds(\patest\ArrayType\ArrayOfguid $ownerIds = null)
    {
        if (is_null($ownerIds) || (is_array($ownerIds) && empty($ownerIds))) {
            unset($this->OwnerIds);
        } else {
            $this->OwnerIds = $ownerIds;
        }
        return $this;
    }
}
