<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateContactDetail-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ValidateContactDetail-Request
 * @subpackage Structs
 */
class ValidateContactDetail_Request extends AbstractStructBase
{
    /**
     * The ContactDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContactDetail;
    /**
     * The EntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EntityId;
    /**
     * The EntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityName;
    /**
     * The IsNew
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsNew;
    /**
     * The PropertyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PropertyName;
    /**
     * The ValidationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ValidationType;
    /**
     * Constructor method for ValidateContactDetail-Request
     * @uses ValidateContactDetail_Request::setContactDetail()
     * @uses ValidateContactDetail_Request::setEntityId()
     * @uses ValidateContactDetail_Request::setEntityName()
     * @uses ValidateContactDetail_Request::setIsNew()
     * @uses ValidateContactDetail_Request::setPropertyName()
     * @uses ValidateContactDetail_Request::setValidationType()
     * @param string $contactDetail
     * @param string $entityId
     * @param string $entityName
     * @param bool $isNew
     * @param string $propertyName
     * @param string $validationType
     */
    public function __construct($contactDetail = null, $entityId = null, $entityName = null, $isNew = null, $propertyName = null, $validationType = null)
    {
        $this
            ->setContactDetail($contactDetail)
            ->setEntityId($entityId)
            ->setEntityName($entityName)
            ->setIsNew($isNew)
            ->setPropertyName($propertyName)
            ->setValidationType($validationType);
    }
    /**
     * Get ContactDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactDetail()
    {
        return isset($this->ContactDetail) ? $this->ContactDetail : null;
    }
    /**
     * Set ContactDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactDetail
     * @return \patest\StructType\ValidateContactDetail_Request
     */
    public function setContactDetail($contactDetail = null)
    {
        // validation for constraint: string
        if (!is_null($contactDetail) && !is_string($contactDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactDetail, true), gettype($contactDetail)), __LINE__);
        }
        if (is_null($contactDetail) || (is_array($contactDetail) && empty($contactDetail))) {
            unset($this->ContactDetail);
        } else {
            $this->ContactDetail = $contactDetail;
        }
        return $this;
    }
    /**
     * Get EntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityId()
    {
        return isset($this->EntityId) ? $this->EntityId : null;
    }
    /**
     * Set EntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityId
     * @return \patest\StructType\ValidateContactDetail_Request
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: string
        if (!is_null($entityId) && !is_string($entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($entityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($entityId, true)), __LINE__);
        }
        if (is_null($entityId) || (is_array($entityId) && empty($entityId))) {
            unset($this->EntityId);
        } else {
            $this->EntityId = $entityId;
        }
        return $this;
    }
    /**
     * Get EntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityName()
    {
        return isset($this->EntityName) ? $this->EntityName : null;
    }
    /**
     * Set EntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityName
     * @return \patest\StructType\ValidateContactDetail_Request
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        if (is_null($entityName) || (is_array($entityName) && empty($entityName))) {
            unset($this->EntityName);
        } else {
            $this->EntityName = $entityName;
        }
        return $this;
    }
    /**
     * Get IsNew value
     * @return bool|null
     */
    public function getIsNew()
    {
        return $this->IsNew;
    }
    /**
     * Set IsNew value
     * @param bool $isNew
     * @return \patest\StructType\ValidateContactDetail_Request
     */
    public function setIsNew($isNew = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNew) && !is_bool($isNew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNew, true), gettype($isNew)), __LINE__);
        }
        $this->IsNew = $isNew;
        return $this;
    }
    /**
     * Get PropertyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPropertyName()
    {
        return isset($this->PropertyName) ? $this->PropertyName : null;
    }
    /**
     * Set PropertyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $propertyName
     * @return \patest\StructType\ValidateContactDetail_Request
     */
    public function setPropertyName($propertyName = null)
    {
        // validation for constraint: string
        if (!is_null($propertyName) && !is_string($propertyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyName, true), gettype($propertyName)), __LINE__);
        }
        if (is_null($propertyName) || (is_array($propertyName) && empty($propertyName))) {
            unset($this->PropertyName);
        } else {
            $this->PropertyName = $propertyName;
        }
        return $this;
    }
    /**
     * Get ValidationType value
     * @return string|null
     */
    public function getValidationType()
    {
        return $this->ValidationType;
    }
    /**
     * Set ValidationType value
     * @uses \patest\EnumType\ValidationType::valueIsValid()
     * @uses \patest\EnumType\ValidationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $validationType
     * @return \patest\StructType\ValidateContactDetail_Request
     */
    public function setValidationType($validationType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ValidationType::valueIsValid($validationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ValidationType', is_array($validationType) ? implode(', ', $validationType) : var_export($validationType, true), implode(', ', \patest\EnumType\ValidationType::getValidValues())), __LINE__);
        }
        $this->ValidationType = $validationType;
        return $this;
    }
}
