<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserInteractionDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UserInteractionDetails
 * @subpackage Structs
 */
class UserInteractionDetails extends AbstractStructBase
{
    /**
     * The ExtraData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfstringstring
     */
    public $ExtraData;
    /**
     * The InteractionKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InteractionKind;
    /**
     * The InteractionReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InteractionReason;
    /**
     * Constructor method for UserInteractionDetails
     * @uses UserInteractionDetails::setExtraData()
     * @uses UserInteractionDetails::setInteractionKind()
     * @uses UserInteractionDetails::setInteractionReason()
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $extraData
     * @param string $interactionKind
     * @param string $interactionReason
     */
    public function __construct(\patest\ArrayType\ArrayOfKeyValueOfstringstring $extraData = null, $interactionKind = null, $interactionReason = null)
    {
        $this
            ->setExtraData($extraData)
            ->setInteractionKind($interactionKind)
            ->setInteractionReason($interactionReason);
    }
    /**
     * Get ExtraData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfstringstring|null
     */
    public function getExtraData()
    {
        return isset($this->ExtraData) ? $this->ExtraData : null;
    }
    /**
     * Set ExtraData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $extraData
     * @return \patest\StructType\UserInteractionDetails
     */
    public function setExtraData(\patest\ArrayType\ArrayOfKeyValueOfstringstring $extraData = null)
    {
        if (is_null($extraData) || (is_array($extraData) && empty($extraData))) {
            unset($this->ExtraData);
        } else {
            $this->ExtraData = $extraData;
        }
        return $this;
    }
    /**
     * Get InteractionKind value
     * @return string|null
     */
    public function getInteractionKind()
    {
        return $this->InteractionKind;
    }
    /**
     * Set InteractionKind value
     * @uses \patest\EnumType\UserInteractionKind::valueIsValid()
     * @uses \patest\EnumType\UserInteractionKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $interactionKind
     * @return \patest\StructType\UserInteractionDetails
     */
    public function setInteractionKind($interactionKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\UserInteractionKind::valueIsValid($interactionKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\UserInteractionKind', is_array($interactionKind) ? implode(', ', $interactionKind) : var_export($interactionKind, true), implode(', ', \patest\EnumType\UserInteractionKind::getValidValues())), __LINE__);
        }
        $this->InteractionKind = $interactionKind;
        return $this;
    }
    /**
     * Get InteractionReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInteractionReason()
    {
        return isset($this->InteractionReason) ? $this->InteractionReason : null;
    }
    /**
     * Set InteractionReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $interactionReason
     * @return \patest\StructType\UserInteractionDetails
     */
    public function setInteractionReason($interactionReason = null)
    {
        // validation for constraint: string
        if (!is_null($interactionReason) && !is_string($interactionReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interactionReason, true), gettype($interactionReason)), __LINE__);
        }
        if (is_null($interactionReason) || (is_array($interactionReason) && empty($interactionReason))) {
            unset($this->InteractionReason);
        } else {
            $this->InteractionReason = $interactionReason;
        }
        return $this;
    }
}
