<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdatingDeliveryItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdatingDeliveryItem
 * @subpackage Structs
 */
class UpdatingDeliveryItem extends AbstractStructBase
{
    /**
     * The DeliveryItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DeliveryItemId;
    /**
     * The NewAddressDetailId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewAddressDetailId;
    /**
     * The NewDeliveryMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewDeliveryMethodId;
    /**
     * Constructor method for UpdatingDeliveryItem
     * @uses UpdatingDeliveryItem::setDeliveryItemId()
     * @uses UpdatingDeliveryItem::setNewAddressDetailId()
     * @uses UpdatingDeliveryItem::setNewDeliveryMethodId()
     * @param string $deliveryItemId
     * @param string $newAddressDetailId
     * @param string $newDeliveryMethodId
     */
    public function __construct($deliveryItemId = null, $newAddressDetailId = null, $newDeliveryMethodId = null)
    {
        $this
            ->setDeliveryItemId($deliveryItemId)
            ->setNewAddressDetailId($newAddressDetailId)
            ->setNewDeliveryMethodId($newDeliveryMethodId);
    }
    /**
     * Get DeliveryItemId value
     * @return string|null
     */
    public function getDeliveryItemId()
    {
        return $this->DeliveryItemId;
    }
    /**
     * Set DeliveryItemId value
     * @param string $deliveryItemId
     * @return \patest\StructType\UpdatingDeliveryItem
     */
    public function setDeliveryItemId($deliveryItemId = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryItemId) && !is_string($deliveryItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryItemId, true), gettype($deliveryItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($deliveryItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $deliveryItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($deliveryItemId, true)), __LINE__);
        }
        $this->DeliveryItemId = $deliveryItemId;
        return $this;
    }
    /**
     * Get NewAddressDetailId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewAddressDetailId()
    {
        return isset($this->NewAddressDetailId) ? $this->NewAddressDetailId : null;
    }
    /**
     * Set NewAddressDetailId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newAddressDetailId
     * @return \patest\StructType\UpdatingDeliveryItem
     */
    public function setNewAddressDetailId($newAddressDetailId = null)
    {
        // validation for constraint: string
        if (!is_null($newAddressDetailId) && !is_string($newAddressDetailId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newAddressDetailId, true), gettype($newAddressDetailId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newAddressDetailId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newAddressDetailId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newAddressDetailId, true)), __LINE__);
        }
        if (is_null($newAddressDetailId) || (is_array($newAddressDetailId) && empty($newAddressDetailId))) {
            unset($this->NewAddressDetailId);
        } else {
            $this->NewAddressDetailId = $newAddressDetailId;
        }
        return $this;
    }
    /**
     * Get NewDeliveryMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewDeliveryMethodId()
    {
        return isset($this->NewDeliveryMethodId) ? $this->NewDeliveryMethodId : null;
    }
    /**
     * Set NewDeliveryMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newDeliveryMethodId
     * @return \patest\StructType\UpdatingDeliveryItem
     */
    public function setNewDeliveryMethodId($newDeliveryMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($newDeliveryMethodId) && !is_string($newDeliveryMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newDeliveryMethodId, true), gettype($newDeliveryMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newDeliveryMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newDeliveryMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newDeliveryMethodId, true)), __LINE__);
        }
        if (is_null($newDeliveryMethodId) || (is_array($newDeliveryMethodId) && empty($newDeliveryMethodId))) {
            unset($this->NewDeliveryMethodId);
        } else {
            $this->NewDeliveryMethodId = $newDeliveryMethodId;
        }
        return $this;
    }
}
