<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateUppConfigurationRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateUppConfigurationRequest
 * @subpackage Structs
 */
class UpdateUppConfigurationRequest extends AbstractStructBase
{
    /**
     * The AD_ApiKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AD_ApiKey;
    /**
     * The AD_ClientKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AD_ClientKey;
    /**
     * The AD_LivePrefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AD_LivePrefix;
    /**
     * The AD_Password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AD_Password;
    /**
     * The AD_PrefixForPaymentReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AD_PrefixForPaymentReference;
    /**
     * The AlternatedPaymentTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AlternatedPaymentTypes;
    /**
     * The AvsMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AvsMode;
    /**
     * The CYS_Secret
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CYS_Secret;
    /**
     * The CcNumberFormat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CcNumberFormat;
    /**
     * The CvvMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CvvMode;
    /**
     * The DefaultCountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultCountryCode;
    /**
     * The DisplayEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayEmail;
    /**
     * The DisplayPhoneNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayPhoneNumber;
    /**
     * The EnablePayByLink
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EnablePayByLink;
    /**
     * The HL_SecretApiKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HL_SecretApiKey;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The PayPal_MerchantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayPal_MerchantId;
    /**
     * The PayPal_PayLaterEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PayPal_PayLaterEnabled;
    /**
     * The PayPal_PrivateKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayPal_PrivateKey;
    /**
     * The PayPal_PublicKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayPal_PublicKey;
    /**
     * The ProviderId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProviderId;
    /**
     * The S4_AuthToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $S4_AuthToken;
    /**
     * The ST_Secret
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ST_Secret;
    /**
     * The WP_ApiId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WP_ApiId;
    /**
     * The WP_ApiKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WP_ApiKey;
    /**
     * The WP_OrgUnitId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WP_OrgUnitId;
    /**
     * The WP_Password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WP_Password;
    /**
     * The WP_Recurring_Password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WP_Recurring_Password;
    /**
     * Constructor method for UpdateUppConfigurationRequest
     * @uses UpdateUppConfigurationRequest::setAD_ApiKey()
     * @uses UpdateUppConfigurationRequest::setAD_ClientKey()
     * @uses UpdateUppConfigurationRequest::setAD_LivePrefix()
     * @uses UpdateUppConfigurationRequest::setAD_Password()
     * @uses UpdateUppConfigurationRequest::setAD_PrefixForPaymentReference()
     * @uses UpdateUppConfigurationRequest::setAlternatedPaymentTypes()
     * @uses UpdateUppConfigurationRequest::setAvsMode()
     * @uses UpdateUppConfigurationRequest::setCYS_Secret()
     * @uses UpdateUppConfigurationRequest::setCcNumberFormat()
     * @uses UpdateUppConfigurationRequest::setCvvMode()
     * @uses UpdateUppConfigurationRequest::setDefaultCountryCode()
     * @uses UpdateUppConfigurationRequest::setDisplayEmail()
     * @uses UpdateUppConfigurationRequest::setDisplayPhoneNumber()
     * @uses UpdateUppConfigurationRequest::setEnablePayByLink()
     * @uses UpdateUppConfigurationRequest::setHL_SecretApiKey()
     * @uses UpdateUppConfigurationRequest::setId()
     * @uses UpdateUppConfigurationRequest::setName()
     * @uses UpdateUppConfigurationRequest::setPayPal_MerchantId()
     * @uses UpdateUppConfigurationRequest::setPayPal_PayLaterEnabled()
     * @uses UpdateUppConfigurationRequest::setPayPal_PrivateKey()
     * @uses UpdateUppConfigurationRequest::setPayPal_PublicKey()
     * @uses UpdateUppConfigurationRequest::setProviderId()
     * @uses UpdateUppConfigurationRequest::setS4_AuthToken()
     * @uses UpdateUppConfigurationRequest::setST_Secret()
     * @uses UpdateUppConfigurationRequest::setWP_ApiId()
     * @uses UpdateUppConfigurationRequest::setWP_ApiKey()
     * @uses UpdateUppConfigurationRequest::setWP_OrgUnitId()
     * @uses UpdateUppConfigurationRequest::setWP_Password()
     * @uses UpdateUppConfigurationRequest::setWP_Recurring_Password()
     * @param string $aD_ApiKey
     * @param string $aD_ClientKey
     * @param string $aD_LivePrefix
     * @param string $aD_Password
     * @param string $aD_PrefixForPaymentReference
     * @param string $alternatedPaymentTypes
     * @param string $avsMode
     * @param string $cYS_Secret
     * @param string $ccNumberFormat
     * @param string $cvvMode
     * @param string $defaultCountryCode
     * @param bool $displayEmail
     * @param bool $displayPhoneNumber
     * @param bool $enablePayByLink
     * @param string $hL_SecretApiKey
     * @param string $id
     * @param string $name
     * @param string $payPal_MerchantId
     * @param bool $payPal_PayLaterEnabled
     * @param string $payPal_PrivateKey
     * @param string $payPal_PublicKey
     * @param string $providerId
     * @param string $s4_AuthToken
     * @param string $sT_Secret
     * @param string $wP_ApiId
     * @param string $wP_ApiKey
     * @param string $wP_OrgUnitId
     * @param string $wP_Password
     * @param string $wP_Recurring_Password
     */
    public function __construct($aD_ApiKey = null, $aD_ClientKey = null, $aD_LivePrefix = null, $aD_Password = null, $aD_PrefixForPaymentReference = null, $alternatedPaymentTypes = null, $avsMode = null, $cYS_Secret = null, $ccNumberFormat = null, $cvvMode = null, $defaultCountryCode = null, $displayEmail = null, $displayPhoneNumber = null, $enablePayByLink = null, $hL_SecretApiKey = null, $id = null, $name = null, $payPal_MerchantId = null, $payPal_PayLaterEnabled = null, $payPal_PrivateKey = null, $payPal_PublicKey = null, $providerId = null, $s4_AuthToken = null, $sT_Secret = null, $wP_ApiId = null, $wP_ApiKey = null, $wP_OrgUnitId = null, $wP_Password = null, $wP_Recurring_Password = null)
    {
        $this
            ->setAD_ApiKey($aD_ApiKey)
            ->setAD_ClientKey($aD_ClientKey)
            ->setAD_LivePrefix($aD_LivePrefix)
            ->setAD_Password($aD_Password)
            ->setAD_PrefixForPaymentReference($aD_PrefixForPaymentReference)
            ->setAlternatedPaymentTypes($alternatedPaymentTypes)
            ->setAvsMode($avsMode)
            ->setCYS_Secret($cYS_Secret)
            ->setCcNumberFormat($ccNumberFormat)
            ->setCvvMode($cvvMode)
            ->setDefaultCountryCode($defaultCountryCode)
            ->setDisplayEmail($displayEmail)
            ->setDisplayPhoneNumber($displayPhoneNumber)
            ->setEnablePayByLink($enablePayByLink)
            ->setHL_SecretApiKey($hL_SecretApiKey)
            ->setId($id)
            ->setName($name)
            ->setPayPal_MerchantId($payPal_MerchantId)
            ->setPayPal_PayLaterEnabled($payPal_PayLaterEnabled)
            ->setPayPal_PrivateKey($payPal_PrivateKey)
            ->setPayPal_PublicKey($payPal_PublicKey)
            ->setProviderId($providerId)
            ->setS4_AuthToken($s4_AuthToken)
            ->setST_Secret($sT_Secret)
            ->setWP_ApiId($wP_ApiId)
            ->setWP_ApiKey($wP_ApiKey)
            ->setWP_OrgUnitId($wP_OrgUnitId)
            ->setWP_Password($wP_Password)
            ->setWP_Recurring_Password($wP_Recurring_Password);
    }
    /**
     * Get AD_ApiKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAD_ApiKey()
    {
        return isset($this->AD_ApiKey) ? $this->AD_ApiKey : null;
    }
    /**
     * Set AD_ApiKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aD_ApiKey
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setAD_ApiKey($aD_ApiKey = null)
    {
        // validation for constraint: string
        if (!is_null($aD_ApiKey) && !is_string($aD_ApiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aD_ApiKey, true), gettype($aD_ApiKey)), __LINE__);
        }
        if (is_null($aD_ApiKey) || (is_array($aD_ApiKey) && empty($aD_ApiKey))) {
            unset($this->AD_ApiKey);
        } else {
            $this->AD_ApiKey = $aD_ApiKey;
        }
        return $this;
    }
    /**
     * Get AD_ClientKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAD_ClientKey()
    {
        return isset($this->AD_ClientKey) ? $this->AD_ClientKey : null;
    }
    /**
     * Set AD_ClientKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aD_ClientKey
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setAD_ClientKey($aD_ClientKey = null)
    {
        // validation for constraint: string
        if (!is_null($aD_ClientKey) && !is_string($aD_ClientKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aD_ClientKey, true), gettype($aD_ClientKey)), __LINE__);
        }
        if (is_null($aD_ClientKey) || (is_array($aD_ClientKey) && empty($aD_ClientKey))) {
            unset($this->AD_ClientKey);
        } else {
            $this->AD_ClientKey = $aD_ClientKey;
        }
        return $this;
    }
    /**
     * Get AD_LivePrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAD_LivePrefix()
    {
        return isset($this->AD_LivePrefix) ? $this->AD_LivePrefix : null;
    }
    /**
     * Set AD_LivePrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aD_LivePrefix
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setAD_LivePrefix($aD_LivePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($aD_LivePrefix) && !is_string($aD_LivePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aD_LivePrefix, true), gettype($aD_LivePrefix)), __LINE__);
        }
        if (is_null($aD_LivePrefix) || (is_array($aD_LivePrefix) && empty($aD_LivePrefix))) {
            unset($this->AD_LivePrefix);
        } else {
            $this->AD_LivePrefix = $aD_LivePrefix;
        }
        return $this;
    }
    /**
     * Get AD_Password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAD_Password()
    {
        return isset($this->AD_Password) ? $this->AD_Password : null;
    }
    /**
     * Set AD_Password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aD_Password
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setAD_Password($aD_Password = null)
    {
        // validation for constraint: string
        if (!is_null($aD_Password) && !is_string($aD_Password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aD_Password, true), gettype($aD_Password)), __LINE__);
        }
        if (is_null($aD_Password) || (is_array($aD_Password) && empty($aD_Password))) {
            unset($this->AD_Password);
        } else {
            $this->AD_Password = $aD_Password;
        }
        return $this;
    }
    /**
     * Get AD_PrefixForPaymentReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAD_PrefixForPaymentReference()
    {
        return isset($this->AD_PrefixForPaymentReference) ? $this->AD_PrefixForPaymentReference : null;
    }
    /**
     * Set AD_PrefixForPaymentReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aD_PrefixForPaymentReference
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setAD_PrefixForPaymentReference($aD_PrefixForPaymentReference = null)
    {
        // validation for constraint: string
        if (!is_null($aD_PrefixForPaymentReference) && !is_string($aD_PrefixForPaymentReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aD_PrefixForPaymentReference, true), gettype($aD_PrefixForPaymentReference)), __LINE__);
        }
        if (is_null($aD_PrefixForPaymentReference) || (is_array($aD_PrefixForPaymentReference) && empty($aD_PrefixForPaymentReference))) {
            unset($this->AD_PrefixForPaymentReference);
        } else {
            $this->AD_PrefixForPaymentReference = $aD_PrefixForPaymentReference;
        }
        return $this;
    }
    /**
     * Get AlternatedPaymentTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlternatedPaymentTypes()
    {
        return isset($this->AlternatedPaymentTypes) ? $this->AlternatedPaymentTypes : null;
    }
    /**
     * Set AlternatedPaymentTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alternatedPaymentTypes
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setAlternatedPaymentTypes($alternatedPaymentTypes = null)
    {
        // validation for constraint: string
        if (!is_null($alternatedPaymentTypes) && !is_string($alternatedPaymentTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternatedPaymentTypes, true), gettype($alternatedPaymentTypes)), __LINE__);
        }
        if (is_null($alternatedPaymentTypes) || (is_array($alternatedPaymentTypes) && empty($alternatedPaymentTypes))) {
            unset($this->AlternatedPaymentTypes);
        } else {
            $this->AlternatedPaymentTypes = $alternatedPaymentTypes;
        }
        return $this;
    }
    /**
     * Get AvsMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvsMode()
    {
        return isset($this->AvsMode) ? $this->AvsMode : null;
    }
    /**
     * Set AvsMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AvsMode::valueIsValid()
     * @uses \patest\EnumType\AvsMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $avsMode
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setAvsMode($avsMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AvsMode::valueIsValid($avsMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AvsMode', is_array($avsMode) ? implode(', ', $avsMode) : var_export($avsMode, true), implode(', ', \patest\EnumType\AvsMode::getValidValues())), __LINE__);
        }
        if (is_null($avsMode) || (is_array($avsMode) && empty($avsMode))) {
            unset($this->AvsMode);
        } else {
            $this->AvsMode = $avsMode;
        }
        return $this;
    }
    /**
     * Get CYS_Secret value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCYS_Secret()
    {
        return isset($this->CYS_Secret) ? $this->CYS_Secret : null;
    }
    /**
     * Set CYS_Secret value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cYS_Secret
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setCYS_Secret($cYS_Secret = null)
    {
        // validation for constraint: string
        if (!is_null($cYS_Secret) && !is_string($cYS_Secret)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cYS_Secret, true), gettype($cYS_Secret)), __LINE__);
        }
        if (is_null($cYS_Secret) || (is_array($cYS_Secret) && empty($cYS_Secret))) {
            unset($this->CYS_Secret);
        } else {
            $this->CYS_Secret = $cYS_Secret;
        }
        return $this;
    }
    /**
     * Get CcNumberFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCcNumberFormat()
    {
        return isset($this->CcNumberFormat) ? $this->CcNumberFormat : null;
    }
    /**
     * Set CcNumberFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ccNumberFormat
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setCcNumberFormat($ccNumberFormat = null)
    {
        // validation for constraint: string
        if (!is_null($ccNumberFormat) && !is_string($ccNumberFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccNumberFormat, true), gettype($ccNumberFormat)), __LINE__);
        }
        if (is_null($ccNumberFormat) || (is_array($ccNumberFormat) && empty($ccNumberFormat))) {
            unset($this->CcNumberFormat);
        } else {
            $this->CcNumberFormat = $ccNumberFormat;
        }
        return $this;
    }
    /**
     * Get CvvMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCvvMode()
    {
        return isset($this->CvvMode) ? $this->CvvMode : null;
    }
    /**
     * Set CvvMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CvvMode::valueIsValid()
     * @uses \patest\EnumType\CvvMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cvvMode
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setCvvMode($cvvMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CvvMode::valueIsValid($cvvMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CvvMode', is_array($cvvMode) ? implode(', ', $cvvMode) : var_export($cvvMode, true), implode(', ', \patest\EnumType\CvvMode::getValidValues())), __LINE__);
        }
        if (is_null($cvvMode) || (is_array($cvvMode) && empty($cvvMode))) {
            unset($this->CvvMode);
        } else {
            $this->CvvMode = $cvvMode;
        }
        return $this;
    }
    /**
     * Get DefaultCountryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultCountryCode()
    {
        return isset($this->DefaultCountryCode) ? $this->DefaultCountryCode : null;
    }
    /**
     * Set DefaultCountryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultCountryCode
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setDefaultCountryCode($defaultCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($defaultCountryCode) && !is_string($defaultCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultCountryCode, true), gettype($defaultCountryCode)), __LINE__);
        }
        if (is_null($defaultCountryCode) || (is_array($defaultCountryCode) && empty($defaultCountryCode))) {
            unset($this->DefaultCountryCode);
        } else {
            $this->DefaultCountryCode = $defaultCountryCode;
        }
        return $this;
    }
    /**
     * Get DisplayEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayEmail()
    {
        return isset($this->DisplayEmail) ? $this->DisplayEmail : null;
    }
    /**
     * Set DisplayEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayEmail
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setDisplayEmail($displayEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayEmail) && !is_bool($displayEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayEmail, true), gettype($displayEmail)), __LINE__);
        }
        if (is_null($displayEmail) || (is_array($displayEmail) && empty($displayEmail))) {
            unset($this->DisplayEmail);
        } else {
            $this->DisplayEmail = $displayEmail;
        }
        return $this;
    }
    /**
     * Get DisplayPhoneNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayPhoneNumber()
    {
        return isset($this->DisplayPhoneNumber) ? $this->DisplayPhoneNumber : null;
    }
    /**
     * Set DisplayPhoneNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayPhoneNumber
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setDisplayPhoneNumber($displayPhoneNumber = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayPhoneNumber) && !is_bool($displayPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayPhoneNumber, true), gettype($displayPhoneNumber)), __LINE__);
        }
        if (is_null($displayPhoneNumber) || (is_array($displayPhoneNumber) && empty($displayPhoneNumber))) {
            unset($this->DisplayPhoneNumber);
        } else {
            $this->DisplayPhoneNumber = $displayPhoneNumber;
        }
        return $this;
    }
    /**
     * Get EnablePayByLink value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEnablePayByLink()
    {
        return isset($this->EnablePayByLink) ? $this->EnablePayByLink : null;
    }
    /**
     * Set EnablePayByLink value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $enablePayByLink
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setEnablePayByLink($enablePayByLink = null)
    {
        // validation for constraint: boolean
        if (!is_null($enablePayByLink) && !is_bool($enablePayByLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enablePayByLink, true), gettype($enablePayByLink)), __LINE__);
        }
        if (is_null($enablePayByLink) || (is_array($enablePayByLink) && empty($enablePayByLink))) {
            unset($this->EnablePayByLink);
        } else {
            $this->EnablePayByLink = $enablePayByLink;
        }
        return $this;
    }
    /**
     * Get HL_SecretApiKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHL_SecretApiKey()
    {
        return isset($this->HL_SecretApiKey) ? $this->HL_SecretApiKey : null;
    }
    /**
     * Set HL_SecretApiKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hL_SecretApiKey
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setHL_SecretApiKey($hL_SecretApiKey = null)
    {
        // validation for constraint: string
        if (!is_null($hL_SecretApiKey) && !is_string($hL_SecretApiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hL_SecretApiKey, true), gettype($hL_SecretApiKey)), __LINE__);
        }
        if (is_null($hL_SecretApiKey) || (is_array($hL_SecretApiKey) && empty($hL_SecretApiKey))) {
            unset($this->HL_SecretApiKey);
        } else {
            $this->HL_SecretApiKey = $hL_SecretApiKey;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get PayPal_MerchantId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayPal_MerchantId()
    {
        return isset($this->PayPal_MerchantId) ? $this->PayPal_MerchantId : null;
    }
    /**
     * Set PayPal_MerchantId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payPal_MerchantId
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setPayPal_MerchantId($payPal_MerchantId = null)
    {
        // validation for constraint: string
        if (!is_null($payPal_MerchantId) && !is_string($payPal_MerchantId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payPal_MerchantId, true), gettype($payPal_MerchantId)), __LINE__);
        }
        if (is_null($payPal_MerchantId) || (is_array($payPal_MerchantId) && empty($payPal_MerchantId))) {
            unset($this->PayPal_MerchantId);
        } else {
            $this->PayPal_MerchantId = $payPal_MerchantId;
        }
        return $this;
    }
    /**
     * Get PayPal_PayLaterEnabled value
     * @return bool|null
     */
    public function getPayPal_PayLaterEnabled()
    {
        return $this->PayPal_PayLaterEnabled;
    }
    /**
     * Set PayPal_PayLaterEnabled value
     * @param bool $payPal_PayLaterEnabled
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setPayPal_PayLaterEnabled($payPal_PayLaterEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($payPal_PayLaterEnabled) && !is_bool($payPal_PayLaterEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($payPal_PayLaterEnabled, true), gettype($payPal_PayLaterEnabled)), __LINE__);
        }
        $this->PayPal_PayLaterEnabled = $payPal_PayLaterEnabled;
        return $this;
    }
    /**
     * Get PayPal_PrivateKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayPal_PrivateKey()
    {
        return isset($this->PayPal_PrivateKey) ? $this->PayPal_PrivateKey : null;
    }
    /**
     * Set PayPal_PrivateKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payPal_PrivateKey
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setPayPal_PrivateKey($payPal_PrivateKey = null)
    {
        // validation for constraint: string
        if (!is_null($payPal_PrivateKey) && !is_string($payPal_PrivateKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payPal_PrivateKey, true), gettype($payPal_PrivateKey)), __LINE__);
        }
        if (is_null($payPal_PrivateKey) || (is_array($payPal_PrivateKey) && empty($payPal_PrivateKey))) {
            unset($this->PayPal_PrivateKey);
        } else {
            $this->PayPal_PrivateKey = $payPal_PrivateKey;
        }
        return $this;
    }
    /**
     * Get PayPal_PublicKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayPal_PublicKey()
    {
        return isset($this->PayPal_PublicKey) ? $this->PayPal_PublicKey : null;
    }
    /**
     * Set PayPal_PublicKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payPal_PublicKey
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setPayPal_PublicKey($payPal_PublicKey = null)
    {
        // validation for constraint: string
        if (!is_null($payPal_PublicKey) && !is_string($payPal_PublicKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payPal_PublicKey, true), gettype($payPal_PublicKey)), __LINE__);
        }
        if (is_null($payPal_PublicKey) || (is_array($payPal_PublicKey) && empty($payPal_PublicKey))) {
            unset($this->PayPal_PublicKey);
        } else {
            $this->PayPal_PublicKey = $payPal_PublicKey;
        }
        return $this;
    }
    /**
     * Get ProviderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProviderId()
    {
        return isset($this->ProviderId) ? $this->ProviderId : null;
    }
    /**
     * Set ProviderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $providerId
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setProviderId($providerId = null)
    {
        // validation for constraint: string
        if (!is_null($providerId) && !is_string($providerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerId, true), gettype($providerId)), __LINE__);
        }
        if (is_null($providerId) || (is_array($providerId) && empty($providerId))) {
            unset($this->ProviderId);
        } else {
            $this->ProviderId = $providerId;
        }
        return $this;
    }
    /**
     * Get S4_AuthToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getS4_AuthToken()
    {
        return isset($this->S4_AuthToken) ? $this->S4_AuthToken : null;
    }
    /**
     * Set S4_AuthToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $s4_AuthToken
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setS4_AuthToken($s4_AuthToken = null)
    {
        // validation for constraint: string
        if (!is_null($s4_AuthToken) && !is_string($s4_AuthToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($s4_AuthToken, true), gettype($s4_AuthToken)), __LINE__);
        }
        if (is_null($s4_AuthToken) || (is_array($s4_AuthToken) && empty($s4_AuthToken))) {
            unset($this->S4_AuthToken);
        } else {
            $this->S4_AuthToken = $s4_AuthToken;
        }
        return $this;
    }
    /**
     * Get ST_Secret value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getST_Secret()
    {
        return isset($this->ST_Secret) ? $this->ST_Secret : null;
    }
    /**
     * Set ST_Secret value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sT_Secret
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setST_Secret($sT_Secret = null)
    {
        // validation for constraint: string
        if (!is_null($sT_Secret) && !is_string($sT_Secret)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sT_Secret, true), gettype($sT_Secret)), __LINE__);
        }
        if (is_null($sT_Secret) || (is_array($sT_Secret) && empty($sT_Secret))) {
            unset($this->ST_Secret);
        } else {
            $this->ST_Secret = $sT_Secret;
        }
        return $this;
    }
    /**
     * Get WP_ApiId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWP_ApiId()
    {
        return isset($this->WP_ApiId) ? $this->WP_ApiId : null;
    }
    /**
     * Set WP_ApiId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wP_ApiId
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setWP_ApiId($wP_ApiId = null)
    {
        // validation for constraint: string
        if (!is_null($wP_ApiId) && !is_string($wP_ApiId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wP_ApiId, true), gettype($wP_ApiId)), __LINE__);
        }
        if (is_null($wP_ApiId) || (is_array($wP_ApiId) && empty($wP_ApiId))) {
            unset($this->WP_ApiId);
        } else {
            $this->WP_ApiId = $wP_ApiId;
        }
        return $this;
    }
    /**
     * Get WP_ApiKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWP_ApiKey()
    {
        return isset($this->WP_ApiKey) ? $this->WP_ApiKey : null;
    }
    /**
     * Set WP_ApiKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wP_ApiKey
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setWP_ApiKey($wP_ApiKey = null)
    {
        // validation for constraint: string
        if (!is_null($wP_ApiKey) && !is_string($wP_ApiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wP_ApiKey, true), gettype($wP_ApiKey)), __LINE__);
        }
        if (is_null($wP_ApiKey) || (is_array($wP_ApiKey) && empty($wP_ApiKey))) {
            unset($this->WP_ApiKey);
        } else {
            $this->WP_ApiKey = $wP_ApiKey;
        }
        return $this;
    }
    /**
     * Get WP_OrgUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWP_OrgUnitId()
    {
        return isset($this->WP_OrgUnitId) ? $this->WP_OrgUnitId : null;
    }
    /**
     * Set WP_OrgUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wP_OrgUnitId
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setWP_OrgUnitId($wP_OrgUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($wP_OrgUnitId) && !is_string($wP_OrgUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wP_OrgUnitId, true), gettype($wP_OrgUnitId)), __LINE__);
        }
        if (is_null($wP_OrgUnitId) || (is_array($wP_OrgUnitId) && empty($wP_OrgUnitId))) {
            unset($this->WP_OrgUnitId);
        } else {
            $this->WP_OrgUnitId = $wP_OrgUnitId;
        }
        return $this;
    }
    /**
     * Get WP_Password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWP_Password()
    {
        return isset($this->WP_Password) ? $this->WP_Password : null;
    }
    /**
     * Set WP_Password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wP_Password
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setWP_Password($wP_Password = null)
    {
        // validation for constraint: string
        if (!is_null($wP_Password) && !is_string($wP_Password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wP_Password, true), gettype($wP_Password)), __LINE__);
        }
        if (is_null($wP_Password) || (is_array($wP_Password) && empty($wP_Password))) {
            unset($this->WP_Password);
        } else {
            $this->WP_Password = $wP_Password;
        }
        return $this;
    }
    /**
     * Get WP_Recurring_Password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWP_Recurring_Password()
    {
        return isset($this->WP_Recurring_Password) ? $this->WP_Recurring_Password : null;
    }
    /**
     * Set WP_Recurring_Password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wP_Recurring_Password
     * @return \patest\StructType\UpdateUppConfigurationRequest
     */
    public function setWP_Recurring_Password($wP_Recurring_Password = null)
    {
        // validation for constraint: string
        if (!is_null($wP_Recurring_Password) && !is_string($wP_Recurring_Password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wP_Recurring_Password, true), gettype($wP_Recurring_Password)), __LINE__);
        }
        if (is_null($wP_Recurring_Password) || (is_array($wP_Recurring_Password) && empty($wP_Recurring_Password))) {
            unset($this->WP_Recurring_Password);
        } else {
            $this->WP_Recurring_Password = $wP_Recurring_Password;
        }
        return $this;
    }
}
