<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateTicketViewConfigurationImageRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateTicketViewConfigurationImageRequest
 * @subpackage Structs
 */
class UpdateTicketViewConfigurationImageRequest extends AbstractStructBase
{
    /**
     * The AdaDominantColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AdaDominantColor;
    /**
     * The ImageGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ImageGuid;
    /**
     * The IsHidden
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHidden;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * Constructor method for UpdateTicketViewConfigurationImageRequest
     * @uses UpdateTicketViewConfigurationImageRequest::setAdaDominantColor()
     * @uses UpdateTicketViewConfigurationImageRequest::setImageGuid()
     * @uses UpdateTicketViewConfigurationImageRequest::setIsHidden()
     * @uses UpdateTicketViewConfigurationImageRequest::setName()
     * @param string $adaDominantColor
     * @param string $imageGuid
     * @param bool $isHidden
     * @param string $name
     */
    public function __construct($adaDominantColor = null, $imageGuid = null, $isHidden = null, $name = null)
    {
        $this
            ->setAdaDominantColor($adaDominantColor)
            ->setImageGuid($imageGuid)
            ->setIsHidden($isHidden)
            ->setName($name);
    }
    /**
     * Get AdaDominantColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdaDominantColor()
    {
        return isset($this->AdaDominantColor) ? $this->AdaDominantColor : null;
    }
    /**
     * Set AdaDominantColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adaDominantColor
     * @return \patest\StructType\UpdateTicketViewConfigurationImageRequest
     */
    public function setAdaDominantColor($adaDominantColor = null)
    {
        // validation for constraint: string
        if (!is_null($adaDominantColor) && !is_string($adaDominantColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adaDominantColor, true), gettype($adaDominantColor)), __LINE__);
        }
        if (is_null($adaDominantColor) || (is_array($adaDominantColor) && empty($adaDominantColor))) {
            unset($this->AdaDominantColor);
        } else {
            $this->AdaDominantColor = $adaDominantColor;
        }
        return $this;
    }
    /**
     * Get ImageGuid value
     * @return string|null
     */
    public function getImageGuid()
    {
        return $this->ImageGuid;
    }
    /**
     * Set ImageGuid value
     * @param string $imageGuid
     * @return \patest\StructType\UpdateTicketViewConfigurationImageRequest
     */
    public function setImageGuid($imageGuid = null)
    {
        // validation for constraint: string
        if (!is_null($imageGuid) && !is_string($imageGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageGuid, true), gettype($imageGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($imageGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $imageGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($imageGuid, true)), __LINE__);
        }
        $this->ImageGuid = $imageGuid;
        return $this;
    }
    /**
     * Get IsHidden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHidden()
    {
        return isset($this->IsHidden) ? $this->IsHidden : null;
    }
    /**
     * Set IsHidden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHidden
     * @return \patest\StructType\UpdateTicketViewConfigurationImageRequest
     */
    public function setIsHidden($isHidden = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHidden) && !is_bool($isHidden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHidden, true), gettype($isHidden)), __LINE__);
        }
        if (is_null($isHidden) || (is_array($isHidden) && empty($isHidden))) {
            unset($this->IsHidden);
        } else {
            $this->IsHidden = $isHidden;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\UpdateTicketViewConfigurationImageRequest
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
}
