<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSubscriptionRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateSubscriptionRequest
 * @subpackage Structs
 */
class UpdateSubscriptionRequest extends AbstractStructBase
{
    /**
     * The SubscriptionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionId;
    /**
     * The Topics
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfSubscriberTopicDetails
     */
    public $Topics;
    /**
     * The UpdateMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UpdateMode;
    /**
     * Constructor method for UpdateSubscriptionRequest
     * @uses UpdateSubscriptionRequest::setSubscriptionId()
     * @uses UpdateSubscriptionRequest::setTopics()
     * @uses UpdateSubscriptionRequest::setUpdateMode()
     * @param string $subscriptionId
     * @param \patest\ArrayType\ArrayOfSubscriberTopicDetails $topics
     * @param string $updateMode
     */
    public function __construct($subscriptionId = null, \patest\ArrayType\ArrayOfSubscriberTopicDetails $topics = null, $updateMode = null)
    {
        $this
            ->setSubscriptionId($subscriptionId)
            ->setTopics($topics)
            ->setUpdateMode($updateMode);
    }
    /**
     * Get SubscriptionId value
     * @return string|null
     */
    public function getSubscriptionId()
    {
        return $this->SubscriptionId;
    }
    /**
     * Set SubscriptionId value
     * @param string $subscriptionId
     * @return \patest\StructType\UpdateSubscriptionRequest
     */
    public function setSubscriptionId($subscriptionId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionId) && !is_string($subscriptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionId, true), gettype($subscriptionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionId, true)), __LINE__);
        }
        $this->SubscriptionId = $subscriptionId;
        return $this;
    }
    /**
     * Get Topics value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfSubscriberTopicDetails|null
     */
    public function getTopics()
    {
        return isset($this->Topics) ? $this->Topics : null;
    }
    /**
     * Set Topics value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfSubscriberTopicDetails $topics
     * @return \patest\StructType\UpdateSubscriptionRequest
     */
    public function setTopics(\patest\ArrayType\ArrayOfSubscriberTopicDetails $topics = null)
    {
        if (is_null($topics) || (is_array($topics) && empty($topics))) {
            unset($this->Topics);
        } else {
            $this->Topics = $topics;
        }
        return $this;
    }
    /**
     * Get UpdateMode value
     * @return string|null
     */
    public function getUpdateMode()
    {
        return $this->UpdateMode;
    }
    /**
     * Set UpdateMode value
     * @uses \patest\EnumType\UpdateSubscriptionMode::valueIsValid()
     * @uses \patest\EnumType\UpdateSubscriptionMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $updateMode
     * @return \patest\StructType\UpdateSubscriptionRequest
     */
    public function setUpdateMode($updateMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\UpdateSubscriptionMode::valueIsValid($updateMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\UpdateSubscriptionMode', is_array($updateMode) ? implode(', ', $updateMode) : var_export($updateMode, true), implode(', ', \patest\EnumType\UpdateSubscriptionMode::getValidValues())), __LINE__);
        }
        $this->UpdateMode = $updateMode;
        return $this;
    }
}
