<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateOnsale-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateOnsale-Request
 * @subpackage Structs
 */
class UpdateOnsale_Request extends ExtensibleDataContract
{
    /**
     * The Onsale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\OnsaleDescriptor
     */
    public $Onsale;
    /**
     * The OnsaleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OnsaleId;
    /**
     * Constructor method for UpdateOnsale-Request
     * @uses UpdateOnsale_Request::setOnsale()
     * @uses UpdateOnsale_Request::setOnsaleId()
     * @param \patest\StructType\OnsaleDescriptor $onsale
     * @param string $onsaleId
     */
    public function __construct(\patest\StructType\OnsaleDescriptor $onsale = null, $onsaleId = null)
    {
        $this
            ->setOnsale($onsale)
            ->setOnsaleId($onsaleId);
    }
    /**
     * Get Onsale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\OnsaleDescriptor|null
     */
    public function getOnsale()
    {
        return isset($this->Onsale) ? $this->Onsale : null;
    }
    /**
     * Set Onsale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\OnsaleDescriptor $onsale
     * @return \patest\StructType\UpdateOnsale_Request
     */
    public function setOnsale(\patest\StructType\OnsaleDescriptor $onsale = null)
    {
        if (is_null($onsale) || (is_array($onsale) && empty($onsale))) {
            unset($this->Onsale);
        } else {
            $this->Onsale = $onsale;
        }
        return $this;
    }
    /**
     * Get OnsaleId value
     * @return string|null
     */
    public function getOnsaleId()
    {
        return $this->OnsaleId;
    }
    /**
     * Set OnsaleId value
     * @param string $onsaleId
     * @return \patest\StructType\UpdateOnsale_Request
     */
    public function setOnsaleId($onsaleId = null)
    {
        // validation for constraint: string
        if (!is_null($onsaleId) && !is_string($onsaleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onsaleId, true), gettype($onsaleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($onsaleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $onsaleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($onsaleId, true)), __LINE__);
        }
        $this->OnsaleId = $onsaleId;
        return $this;
    }
}
