<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateItemProperties-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateItemProperties-Request
 * @subpackage Structs
 */
class UpdateItemProperties_Request extends ExtensibleDataContract
{
    /**
     * The AffectProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $AffectProperties;
    /**
     * The ItemOwners
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfTransactionClientDetails
     */
    public $ItemOwners;
    /**
     * The ItemsToUpdate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfOverridableGeneralItemProperties
     */
    public $ItemsToUpdate;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * The IsConvertPricingErrorsIntoIncomplete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsConvertPricingErrorsIntoIncomplete;
    /**
     * Constructor method for UpdateItemProperties-Request
     * @uses UpdateItemProperties_Request::setAffectProperties()
     * @uses UpdateItemProperties_Request::setItemOwners()
     * @uses UpdateItemProperties_Request::setItemsToUpdate()
     * @uses UpdateItemProperties_Request::setTransactionGuid()
     * @uses UpdateItemProperties_Request::setTransactionSnapshotType()
     * @uses UpdateItemProperties_Request::setIsConvertPricingErrorsIntoIncomplete()
     * @param string[] $affectProperties
     * @param \patest\ArrayType\ArrayOfTransactionClientDetails $itemOwners
     * @param \patest\ArrayType\ArrayOfOverridableGeneralItemProperties $itemsToUpdate
     * @param string $transactionGuid
     * @param string $transactionSnapshotType
     * @param bool $isConvertPricingErrorsIntoIncomplete
     */
    public function __construct(array $affectProperties = array(), \patest\ArrayType\ArrayOfTransactionClientDetails $itemOwners = null, \patest\ArrayType\ArrayOfOverridableGeneralItemProperties $itemsToUpdate = null, $transactionGuid = null, $transactionSnapshotType = null, $isConvertPricingErrorsIntoIncomplete = null)
    {
        $this
            ->setAffectProperties($affectProperties)
            ->setItemOwners($itemOwners)
            ->setItemsToUpdate($itemsToUpdate)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshotType($transactionSnapshotType)
            ->setIsConvertPricingErrorsIntoIncomplete($isConvertPricingErrorsIntoIncomplete);
    }
    /**
     * Get AffectProperties value
     * @return string[]|null
     */
    public function getAffectProperties()
    {
        return $this->AffectProperties;
    }
    /**
     * This method is responsible for validating the values passed to the setAffectProperties method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAffectProperties method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAffectPropertiesForArrayConstraintsFromSetAffectProperties(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $updateItemProperties_RequestAffectPropertiesItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\OverridableItemProperties::valueIsValid($updateItemProperties_RequestAffectPropertiesItem)) {
                $invalidValues[] = is_object($updateItemProperties_RequestAffectPropertiesItem) ? get_class($updateItemProperties_RequestAffectPropertiesItem) : sprintf('%s(%s)', gettype($updateItemProperties_RequestAffectPropertiesItem), var_export($updateItemProperties_RequestAffectPropertiesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OverridableItemProperties', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\OverridableItemProperties::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AffectProperties value
     * @uses \patest\EnumType\OverridableItemProperties::valueIsValid()
     * @uses \patest\EnumType\OverridableItemProperties::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $affectProperties
     * @return \patest\StructType\UpdateItemProperties_Request
     */
    public function setAffectProperties(array $affectProperties = array())
    {
        // validation for constraint: list
        if ('' !== ($affectPropertiesArrayErrorMessage = self::validateAffectPropertiesForArrayConstraintsFromSetAffectProperties($affectProperties))) {
            throw new \InvalidArgumentException($affectPropertiesArrayErrorMessage, __LINE__);
        }
        $this->AffectProperties = is_array($affectProperties) ? implode(' ', $affectProperties) : null;
        return $this;
    }
    /**
     * Get ItemOwners value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfTransactionClientDetails|null
     */
    public function getItemOwners()
    {
        return isset($this->ItemOwners) ? $this->ItemOwners : null;
    }
    /**
     * Set ItemOwners value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfTransactionClientDetails $itemOwners
     * @return \patest\StructType\UpdateItemProperties_Request
     */
    public function setItemOwners(\patest\ArrayType\ArrayOfTransactionClientDetails $itemOwners = null)
    {
        if (is_null($itemOwners) || (is_array($itemOwners) && empty($itemOwners))) {
            unset($this->ItemOwners);
        } else {
            $this->ItemOwners = $itemOwners;
        }
        return $this;
    }
    /**
     * Get ItemsToUpdate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfOverridableGeneralItemProperties|null
     */
    public function getItemsToUpdate()
    {
        return isset($this->ItemsToUpdate) ? $this->ItemsToUpdate : null;
    }
    /**
     * Set ItemsToUpdate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfOverridableGeneralItemProperties $itemsToUpdate
     * @return \patest\StructType\UpdateItemProperties_Request
     */
    public function setItemsToUpdate(\patest\ArrayType\ArrayOfOverridableGeneralItemProperties $itemsToUpdate = null)
    {
        if (is_null($itemsToUpdate) || (is_array($itemsToUpdate) && empty($itemsToUpdate))) {
            unset($this->ItemsToUpdate);
        } else {
            $this->ItemsToUpdate = $itemsToUpdate;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\UpdateItemProperties_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\UpdateItemProperties_Request
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
    /**
     * Get IsConvertPricingErrorsIntoIncomplete value
     * @return bool|null
     */
    public function getIsConvertPricingErrorsIntoIncomplete()
    {
        return $this->IsConvertPricingErrorsIntoIncomplete;
    }
    /**
     * Set IsConvertPricingErrorsIntoIncomplete value
     * @param bool $isConvertPricingErrorsIntoIncomplete
     * @return \patest\StructType\UpdateItemProperties_Request
     */
    public function setIsConvertPricingErrorsIntoIncomplete($isConvertPricingErrorsIntoIncomplete = null)
    {
        // validation for constraint: boolean
        if (!is_null($isConvertPricingErrorsIntoIncomplete) && !is_bool($isConvertPricingErrorsIntoIncomplete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isConvertPricingErrorsIntoIncomplete, true), gettype($isConvertPricingErrorsIntoIncomplete)), __LINE__);
        }
        $this->IsConvertPricingErrorsIntoIncomplete = $isConvertPricingErrorsIntoIncomplete;
        return $this;
    }
}
