<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateDirectDebitRecordStatus StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateDirectDebitRecordStatus
 * @subpackage Structs
 */
class UpdateDirectDebitRecordStatus extends AbstractStructBase
{
    /**
     * The NewStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NewStatus;
    /**
     * The RecordId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecordId;
    /**
     * Constructor method for UpdateDirectDebitRecordStatus
     * @uses UpdateDirectDebitRecordStatus::setNewStatus()
     * @uses UpdateDirectDebitRecordStatus::setRecordId()
     * @param string $newStatus
     * @param string $recordId
     */
    public function __construct($newStatus = null, $recordId = null)
    {
        $this
            ->setNewStatus($newStatus)
            ->setRecordId($recordId);
    }
    /**
     * Get NewStatus value
     * @return string|null
     */
    public function getNewStatus()
    {
        return $this->NewStatus;
    }
    /**
     * Set NewStatus value
     * @uses \patest\EnumType\DirectDebitRecordStatus::valueIsValid()
     * @uses \patest\EnumType\DirectDebitRecordStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $newStatus
     * @return \patest\StructType\UpdateDirectDebitRecordStatus
     */
    public function setNewStatus($newStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DirectDebitRecordStatus::valueIsValid($newStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DirectDebitRecordStatus', is_array($newStatus) ? implode(', ', $newStatus) : var_export($newStatus, true), implode(', ', \patest\EnumType\DirectDebitRecordStatus::getValidValues())), __LINE__);
        }
        $this->NewStatus = $newStatus;
        return $this;
    }
    /**
     * Get RecordId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecordId()
    {
        return isset($this->RecordId) ? $this->RecordId : null;
    }
    /**
     * Set RecordId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recordId
     * @return \patest\StructType\UpdateDirectDebitRecordStatus
     */
    public function setRecordId($recordId = null)
    {
        // validation for constraint: string
        if (!is_null($recordId) && !is_string($recordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordId, true), gettype($recordId)), __LINE__);
        }
        if (is_null($recordId) || (is_array($recordId) && empty($recordId))) {
            unset($this->RecordId);
        } else {
            $this->RecordId = $recordId;
        }
        return $this;
    }
}
