<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCustomerRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateCustomerRequest
 * @subpackage Structs
 */
class UpdateCustomerRequest extends AbstractStructBase
{
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_SimplifiedCustomer
     */
    public $Customer;
    /**
     * The RetunStoredCustomer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RetunStoredCustomer;
    /**
     * Constructor method for UpdateCustomerRequest
     * @uses UpdateCustomerRequest::setCustomer()
     * @uses UpdateCustomerRequest::setRetunStoredCustomer()
     * @param \patest\StructType\Crm_SimplifiedCustomer $customer
     * @param bool $retunStoredCustomer
     */
    public function __construct(\patest\StructType\Crm_SimplifiedCustomer $customer = null, $retunStoredCustomer = null)
    {
        $this
            ->setCustomer($customer)
            ->setRetunStoredCustomer($retunStoredCustomer);
    }
    /**
     * Get Customer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_SimplifiedCustomer|null
     */
    public function getCustomer()
    {
        return isset($this->Customer) ? $this->Customer : null;
    }
    /**
     * Set Customer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_SimplifiedCustomer $customer
     * @return \patest\StructType\UpdateCustomerRequest
     */
    public function setCustomer(\patest\StructType\Crm_SimplifiedCustomer $customer = null)
    {
        if (is_null($customer) || (is_array($customer) && empty($customer))) {
            unset($this->Customer);
        } else {
            $this->Customer = $customer;
        }
        return $this;
    }
    /**
     * Get RetunStoredCustomer value
     * @return bool|null
     */
    public function getRetunStoredCustomer()
    {
        return $this->RetunStoredCustomer;
    }
    /**
     * Set RetunStoredCustomer value
     * @param bool $retunStoredCustomer
     * @return \patest\StructType\UpdateCustomerRequest
     */
    public function setRetunStoredCustomer($retunStoredCustomer = null)
    {
        // validation for constraint: boolean
        if (!is_null($retunStoredCustomer) && !is_bool($retunStoredCustomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($retunStoredCustomer, true), gettype($retunStoredCustomer)), __LINE__);
        }
        $this->RetunStoredCustomer = $retunStoredCustomer;
        return $this;
    }
}
