<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCommittedMembershipItemProperties-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateCommittedMembershipItemProperties-Request
 * @subpackage Structs
 */
class UpdateCommittedMembershipItemProperties_Request extends ExtensibleDataContract
{
    /**
     * The AffectProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $AffectProperties;
    /**
     * The MembershipInstancesToUpdate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfOverridableCommittedMembershipItemProperties
     */
    public $MembershipInstancesToUpdate;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for UpdateCommittedMembershipItemProperties-Request
     * @uses UpdateCommittedMembershipItemProperties_Request::setAffectProperties()
     * @uses UpdateCommittedMembershipItemProperties_Request::setMembershipInstancesToUpdate()
     * @uses UpdateCommittedMembershipItemProperties_Request::setTransactionGuid()
     * @uses UpdateCommittedMembershipItemProperties_Request::setTransactionNumber()
     * @param string[] $affectProperties
     * @param \patest\ArrayType\ArrayOfOverridableCommittedMembershipItemProperties $membershipInstancesToUpdate
     * @param string $transactionGuid
     * @param int $transactionNumber
     */
    public function __construct(array $affectProperties = array(), \patest\ArrayType\ArrayOfOverridableCommittedMembershipItemProperties $membershipInstancesToUpdate = null, $transactionGuid = null, $transactionNumber = null)
    {
        $this
            ->setAffectProperties($affectProperties)
            ->setMembershipInstancesToUpdate($membershipInstancesToUpdate)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get AffectProperties value
     * @return string[]|null
     */
    public function getAffectProperties()
    {
        return $this->AffectProperties;
    }
    /**
     * This method is responsible for validating the values passed to the setAffectProperties method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAffectProperties method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAffectPropertiesForArrayConstraintsFromSetAffectProperties(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $updateCommittedMembershipItemProperties_RequestAffectPropertiesItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\OverridableAffectCommittedMembershipItemProperties::valueIsValid($updateCommittedMembershipItemProperties_RequestAffectPropertiesItem)) {
                $invalidValues[] = is_object($updateCommittedMembershipItemProperties_RequestAffectPropertiesItem) ? get_class($updateCommittedMembershipItemProperties_RequestAffectPropertiesItem) : sprintf('%s(%s)', gettype($updateCommittedMembershipItemProperties_RequestAffectPropertiesItem), var_export($updateCommittedMembershipItemProperties_RequestAffectPropertiesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OverridableAffectCommittedMembershipItemProperties', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\OverridableAffectCommittedMembershipItemProperties::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AffectProperties value
     * @uses \patest\EnumType\OverridableAffectCommittedMembershipItemProperties::valueIsValid()
     * @uses \patest\EnumType\OverridableAffectCommittedMembershipItemProperties::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $affectProperties
     * @return \patest\StructType\UpdateCommittedMembershipItemProperties_Request
     */
    public function setAffectProperties(array $affectProperties = array())
    {
        // validation for constraint: list
        if ('' !== ($affectPropertiesArrayErrorMessage = self::validateAffectPropertiesForArrayConstraintsFromSetAffectProperties($affectProperties))) {
            throw new \InvalidArgumentException($affectPropertiesArrayErrorMessage, __LINE__);
        }
        $this->AffectProperties = is_array($affectProperties) ? implode(' ', $affectProperties) : null;
        return $this;
    }
    /**
     * Get MembershipInstancesToUpdate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfOverridableCommittedMembershipItemProperties|null
     */
    public function getMembershipInstancesToUpdate()
    {
        return isset($this->MembershipInstancesToUpdate) ? $this->MembershipInstancesToUpdate : null;
    }
    /**
     * Set MembershipInstancesToUpdate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfOverridableCommittedMembershipItemProperties $membershipInstancesToUpdate
     * @return \patest\StructType\UpdateCommittedMembershipItemProperties_Request
     */
    public function setMembershipInstancesToUpdate(\patest\ArrayType\ArrayOfOverridableCommittedMembershipItemProperties $membershipInstancesToUpdate = null)
    {
        if (is_null($membershipInstancesToUpdate) || (is_array($membershipInstancesToUpdate) && empty($membershipInstancesToUpdate))) {
            unset($this->MembershipInstancesToUpdate);
        } else {
            $this->MembershipInstancesToUpdate = $membershipInstancesToUpdate;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\UpdateCommittedMembershipItemProperties_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\UpdateCommittedMembershipItemProperties_Request
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
