<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCommittedItemProperties-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateCommittedItemProperties-Request
 * @subpackage Structs
 */
class UpdateCommittedItemProperties_Request extends ExtensibleDataContract
{
    /**
     * The AffectProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $AffectProperties;
    /**
     * The ItemsToUpdate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfOverridableCommittedGeneralItemProperties
     */
    public $ItemsToUpdate;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for UpdateCommittedItemProperties-Request
     * @uses UpdateCommittedItemProperties_Request::setAffectProperties()
     * @uses UpdateCommittedItemProperties_Request::setItemsToUpdate()
     * @uses UpdateCommittedItemProperties_Request::setTransactionGuid()
     * @uses UpdateCommittedItemProperties_Request::setTransactionNumber()
     * @param string[] $affectProperties
     * @param \patest\ArrayType\ArrayOfOverridableCommittedGeneralItemProperties $itemsToUpdate
     * @param string $transactionGuid
     * @param int $transactionNumber
     */
    public function __construct(array $affectProperties = array(), \patest\ArrayType\ArrayOfOverridableCommittedGeneralItemProperties $itemsToUpdate = null, $transactionGuid = null, $transactionNumber = null)
    {
        $this
            ->setAffectProperties($affectProperties)
            ->setItemsToUpdate($itemsToUpdate)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get AffectProperties value
     * @return string[]|null
     */
    public function getAffectProperties()
    {
        return $this->AffectProperties;
    }
    /**
     * This method is responsible for validating the values passed to the setAffectProperties method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAffectProperties method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAffectPropertiesForArrayConstraintsFromSetAffectProperties(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $updateCommittedItemProperties_RequestAffectPropertiesItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\OverridableCommittedItemProperties::valueIsValid($updateCommittedItemProperties_RequestAffectPropertiesItem)) {
                $invalidValues[] = is_object($updateCommittedItemProperties_RequestAffectPropertiesItem) ? get_class($updateCommittedItemProperties_RequestAffectPropertiesItem) : sprintf('%s(%s)', gettype($updateCommittedItemProperties_RequestAffectPropertiesItem), var_export($updateCommittedItemProperties_RequestAffectPropertiesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OverridableCommittedItemProperties', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\OverridableCommittedItemProperties::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AffectProperties value
     * @uses \patest\EnumType\OverridableCommittedItemProperties::valueIsValid()
     * @uses \patest\EnumType\OverridableCommittedItemProperties::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $affectProperties
     * @return \patest\StructType\UpdateCommittedItemProperties_Request
     */
    public function setAffectProperties(array $affectProperties = array())
    {
        // validation for constraint: list
        if ('' !== ($affectPropertiesArrayErrorMessage = self::validateAffectPropertiesForArrayConstraintsFromSetAffectProperties($affectProperties))) {
            throw new \InvalidArgumentException($affectPropertiesArrayErrorMessage, __LINE__);
        }
        $this->AffectProperties = is_array($affectProperties) ? implode(' ', $affectProperties) : null;
        return $this;
    }
    /**
     * Get ItemsToUpdate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfOverridableCommittedGeneralItemProperties|null
     */
    public function getItemsToUpdate()
    {
        return isset($this->ItemsToUpdate) ? $this->ItemsToUpdate : null;
    }
    /**
     * Set ItemsToUpdate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfOverridableCommittedGeneralItemProperties $itemsToUpdate
     * @return \patest\StructType\UpdateCommittedItemProperties_Request
     */
    public function setItemsToUpdate(\patest\ArrayType\ArrayOfOverridableCommittedGeneralItemProperties $itemsToUpdate = null)
    {
        if (is_null($itemsToUpdate) || (is_array($itemsToUpdate) && empty($itemsToUpdate))) {
            unset($this->ItemsToUpdate);
        } else {
            $this->ItemsToUpdate = $itemsToUpdate;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\UpdateCommittedItemProperties_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\UpdateCommittedItemProperties_Request
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
