<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateClientLinkRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateClientLinkRequest
 * @subpackage Structs
 */
class UpdateClientLinkRequest extends AbstractStructBase
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The IsFavourite
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFavourite;
    /**
     * The LinkTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LinkTypeId;
    /**
     * The LinkeeClientRoleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LinkeeClientRoleId;
    /**
     * The LinkerClientRoleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LinkerClientRoleId;
    /**
     * The RelationshipId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelationshipId;
    /**
     * Constructor method for UpdateClientLinkRequest
     * @uses UpdateClientLinkRequest::setClientId()
     * @uses UpdateClientLinkRequest::setIsFavourite()
     * @uses UpdateClientLinkRequest::setLinkTypeId()
     * @uses UpdateClientLinkRequest::setLinkeeClientRoleId()
     * @uses UpdateClientLinkRequest::setLinkerClientRoleId()
     * @uses UpdateClientLinkRequest::setRelationshipId()
     * @param string $clientId
     * @param bool $isFavourite
     * @param string $linkTypeId
     * @param string $linkeeClientRoleId
     * @param string $linkerClientRoleId
     * @param string $relationshipId
     */
    public function __construct($clientId = null, $isFavourite = null, $linkTypeId = null, $linkeeClientRoleId = null, $linkerClientRoleId = null, $relationshipId = null)
    {
        $this
            ->setClientId($clientId)
            ->setIsFavourite($isFavourite)
            ->setLinkTypeId($linkTypeId)
            ->setLinkeeClientRoleId($linkeeClientRoleId)
            ->setLinkerClientRoleId($linkerClientRoleId)
            ->setRelationshipId($relationshipId);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\UpdateClientLinkRequest
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get IsFavourite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFavourite()
    {
        return isset($this->IsFavourite) ? $this->IsFavourite : null;
    }
    /**
     * Set IsFavourite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFavourite
     * @return \patest\StructType\UpdateClientLinkRequest
     */
    public function setIsFavourite($isFavourite = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFavourite) && !is_bool($isFavourite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFavourite, true), gettype($isFavourite)), __LINE__);
        }
        if (is_null($isFavourite) || (is_array($isFavourite) && empty($isFavourite))) {
            unset($this->IsFavourite);
        } else {
            $this->IsFavourite = $isFavourite;
        }
        return $this;
    }
    /**
     * Get LinkTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLinkTypeId()
    {
        return isset($this->LinkTypeId) ? $this->LinkTypeId : null;
    }
    /**
     * Set LinkTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $linkTypeId
     * @return \patest\StructType\UpdateClientLinkRequest
     */
    public function setLinkTypeId($linkTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($linkTypeId) && !is_string($linkTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkTypeId, true), gettype($linkTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($linkTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $linkTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($linkTypeId, true)), __LINE__);
        }
        if (is_null($linkTypeId) || (is_array($linkTypeId) && empty($linkTypeId))) {
            unset($this->LinkTypeId);
        } else {
            $this->LinkTypeId = $linkTypeId;
        }
        return $this;
    }
    /**
     * Get LinkeeClientRoleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLinkeeClientRoleId()
    {
        return isset($this->LinkeeClientRoleId) ? $this->LinkeeClientRoleId : null;
    }
    /**
     * Set LinkeeClientRoleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $linkeeClientRoleId
     * @return \patest\StructType\UpdateClientLinkRequest
     */
    public function setLinkeeClientRoleId($linkeeClientRoleId = null)
    {
        // validation for constraint: string
        if (!is_null($linkeeClientRoleId) && !is_string($linkeeClientRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkeeClientRoleId, true), gettype($linkeeClientRoleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($linkeeClientRoleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $linkeeClientRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($linkeeClientRoleId, true)), __LINE__);
        }
        if (is_null($linkeeClientRoleId) || (is_array($linkeeClientRoleId) && empty($linkeeClientRoleId))) {
            unset($this->LinkeeClientRoleId);
        } else {
            $this->LinkeeClientRoleId = $linkeeClientRoleId;
        }
        return $this;
    }
    /**
     * Get LinkerClientRoleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLinkerClientRoleId()
    {
        return isset($this->LinkerClientRoleId) ? $this->LinkerClientRoleId : null;
    }
    /**
     * Set LinkerClientRoleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $linkerClientRoleId
     * @return \patest\StructType\UpdateClientLinkRequest
     */
    public function setLinkerClientRoleId($linkerClientRoleId = null)
    {
        // validation for constraint: string
        if (!is_null($linkerClientRoleId) && !is_string($linkerClientRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkerClientRoleId, true), gettype($linkerClientRoleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($linkerClientRoleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $linkerClientRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($linkerClientRoleId, true)), __LINE__);
        }
        if (is_null($linkerClientRoleId) || (is_array($linkerClientRoleId) && empty($linkerClientRoleId))) {
            unset($this->LinkerClientRoleId);
        } else {
            $this->LinkerClientRoleId = $linkerClientRoleId;
        }
        return $this;
    }
    /**
     * Get RelationshipId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationshipId()
    {
        return isset($this->RelationshipId) ? $this->RelationshipId : null;
    }
    /**
     * Set RelationshipId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relationshipId
     * @return \patest\StructType\UpdateClientLinkRequest
     */
    public function setRelationshipId($relationshipId = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipId) && !is_string($relationshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipId, true), gettype($relationshipId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relationshipId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relationshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relationshipId, true)), __LINE__);
        }
        if (is_null($relationshipId) || (is_array($relationshipId) && empty($relationshipId))) {
            unset($this->RelationshipId);
        } else {
            $this->RelationshipId = $relationshipId;
        }
        return $this;
    }
}
