<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UI.Crm.Merge StructType
 * @subpackage Structs
 */
class UI_Crm_Merge extends AnyEntity
{
    /**
     * The DestinationClient
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DestinationClient;
    /**
     * The SourceClient
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SourceClient;
    /**
     * Constructor method for UI.Crm.Merge
     * @uses UI_Crm_Merge::setDestinationClient()
     * @uses UI_Crm_Merge::setSourceClient()
     * @param string $destinationClient
     * @param string $sourceClient
     */
    public function __construct($destinationClient = null, $sourceClient = null)
    {
        $this
            ->setDestinationClient($destinationClient)
            ->setSourceClient($sourceClient);
    }
    /**
     * Get DestinationClient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationClient()
    {
        return isset($this->DestinationClient) ? $this->DestinationClient : null;
    }
    /**
     * Set DestinationClient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationClient
     * @return \patest\StructType\UI_Crm_Merge
     */
    public function setDestinationClient($destinationClient = null)
    {
        // validation for constraint: string
        if (!is_null($destinationClient) && !is_string($destinationClient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationClient, true), gettype($destinationClient)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($destinationClient) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $destinationClient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($destinationClient, true)), __LINE__);
        }
        if (is_null($destinationClient) || (is_array($destinationClient) && empty($destinationClient))) {
            unset($this->DestinationClient);
        } else {
            $this->DestinationClient = $destinationClient;
        }
        return $this;
    }
    /**
     * Get SourceClient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceClient()
    {
        return isset($this->SourceClient) ? $this->SourceClient : null;
    }
    /**
     * Set SourceClient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceClient
     * @return \patest\StructType\UI_Crm_Merge
     */
    public function setSourceClient($sourceClient = null)
    {
        // validation for constraint: string
        if (!is_null($sourceClient) && !is_string($sourceClient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceClient, true), gettype($sourceClient)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sourceClient) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sourceClient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sourceClient, true)), __LINE__);
        }
        if (is_null($sourceClient) || (is_array($sourceClient) && empty($sourceClient))) {
            unset($this->SourceClient);
        } else {
            $this->SourceClient = $sourceClient;
        }
        return $this;
    }
}
