<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TryAdjustInstallmentsAmountRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TryAdjustInstallmentsAmountRequest
 * @subpackage Structs
 */
class TryAdjustInstallmentsAmountRequest extends AbstractStructBase
{
    /**
     * The AdjustmentAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $AdjustmentAmount;
    /**
     * The AdjustmentOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AdjustmentOption;
    /**
     * The InstallmentEntity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Payment_Installment
     */
    public $InstallmentEntity;
    /**
     * Constructor method for TryAdjustInstallmentsAmountRequest
     * @uses TryAdjustInstallmentsAmountRequest::setAdjustmentAmount()
     * @uses TryAdjustInstallmentsAmountRequest::setAdjustmentOption()
     * @uses TryAdjustInstallmentsAmountRequest::setInstallmentEntity()
     * @param \patest\StructType\Money $adjustmentAmount
     * @param string $adjustmentOption
     * @param \patest\StructType\Payment_Installment $installmentEntity
     */
    public function __construct(\patest\StructType\Money $adjustmentAmount = null, $adjustmentOption = null, \patest\StructType\Payment_Installment $installmentEntity = null)
    {
        $this
            ->setAdjustmentAmount($adjustmentAmount)
            ->setAdjustmentOption($adjustmentOption)
            ->setInstallmentEntity($installmentEntity);
    }
    /**
     * Get AdjustmentAmount value
     * @return \patest\StructType\Money|null
     */
    public function getAdjustmentAmount()
    {
        return $this->AdjustmentAmount;
    }
    /**
     * Set AdjustmentAmount value
     * @param \patest\StructType\Money $adjustmentAmount
     * @return \patest\StructType\TryAdjustInstallmentsAmountRequest
     */
    public function setAdjustmentAmount(\patest\StructType\Money $adjustmentAmount = null)
    {
        $this->AdjustmentAmount = $adjustmentAmount;
        return $this;
    }
    /**
     * Get AdjustmentOption value
     * @return string|null
     */
    public function getAdjustmentOption()
    {
        return $this->AdjustmentOption;
    }
    /**
     * Set AdjustmentOption value
     * @uses \patest\EnumType\InstallmentsAmountAdjustmentOption::valueIsValid()
     * @uses \patest\EnumType\InstallmentsAmountAdjustmentOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $adjustmentOption
     * @return \patest\StructType\TryAdjustInstallmentsAmountRequest
     */
    public function setAdjustmentOption($adjustmentOption = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\InstallmentsAmountAdjustmentOption::valueIsValid($adjustmentOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InstallmentsAmountAdjustmentOption', is_array($adjustmentOption) ? implode(', ', $adjustmentOption) : var_export($adjustmentOption, true), implode(', ', \patest\EnumType\InstallmentsAmountAdjustmentOption::getValidValues())), __LINE__);
        }
        $this->AdjustmentOption = $adjustmentOption;
        return $this;
    }
    /**
     * Get InstallmentEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Payment_Installment|null
     */
    public function getInstallmentEntity()
    {
        return isset($this->InstallmentEntity) ? $this->InstallmentEntity : null;
    }
    /**
     * Set InstallmentEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Payment_Installment $installmentEntity
     * @return \patest\StructType\TryAdjustInstallmentsAmountRequest
     */
    public function setInstallmentEntity(\patest\StructType\Payment_Installment $installmentEntity = null)
    {
        if (is_null($installmentEntity) || (is_array($installmentEntity) && empty($installmentEntity))) {
            unset($this->InstallmentEntity);
        } else {
            $this->InstallmentEntity = $installmentEntity;
        }
        return $this;
    }
}
