<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionSnapshot StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TransactionSnapshot
 * @subpackage Structs
 */
class TransactionSnapshot extends AbstractStructBase
{
    /**
     * The AccountGroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountGroupId;
    /**
     * The ApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannel;
    /**
     * The Basket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\BasketSnapshot
     */
    public $Basket;
    /**
     * The Client
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TransactionClient
     */
    public $Client;
    /**
     * The Clients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfguidTransactionClienthpjoQDea
     */
    public $Clients;
    /**
     * The CommitDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\DateTimeOffset
     */
    public $CommitDate;
    /**
     * The ConfirmationShiftGlobalNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ConfirmationShiftGlobalNumber;
    /**
     * The ConfirmationShiftId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ConfirmationShiftId;
    /**
     * The ConnectionProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ConnectionProperties
     */
    public $ConnectionProperties;
    /**
     * The ExtraInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ExtraFields
     */
    public $ExtraInfo;
    /**
     * The ForeignId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ForeignId;
    /**
     * The InteractionChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InteractionChannel;
    /**
     * The IsPrintable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsPrintable;
    /**
     * The OnBehalfOfAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OnBehalfOfAccountId;
    /**
     * The RecoAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RecoAccountId;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReferenceNumber;
    /**
     * The RetailerCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RetailerCompanyId;
    /**
     * The RetailerTransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RetailerTransactionGuid;
    /**
     * The RetailerTransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RetailerTransactionNumber;
    /**
     * The SaleMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TransactionSaleMode
     */
    public $SaleMode;
    /**
     * The SaleModeAccountTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SaleModeAccountTypeId;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The TransactionStateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\DateTimeOffset
     */
    public $TransactionStateDate;
    /**
     * The UseUnpublishedRules
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UseUnpublishedRules;
    /**
     * The WorkShiftGlobalNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $WorkShiftGlobalNumber;
    /**
     * The WorkShiftId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $WorkShiftId;
    /**
     * The GroupedBasketSnapshot
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GroupedBasketSnapshot
     */
    public $GroupedBasketSnapshot;
    /**
     * The InvoiceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $InvoiceNumber;
    /**
     * The InvoiceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InvoiceType;
    /**
     * The AgencyAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AgencyAccountId;
    /**
     * The SellerBranchId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SellerBranchId;
    /**
     * The SellerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SellerId;
    /**
     * The SingleSupplierBranchId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SingleSupplierBranchId;
    /**
     * The AccountContactPersonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountContactPersonId;
    /**
     * The AgencyContactPersonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AgencyContactPersonId;
    /**
     * The Purpose
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Purpose;
    /**
     * The CreditNoteNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CreditNoteNumber;
    /**
     * The IsPartOfTransactionGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsPartOfTransactionGroup;
    /**
     * The WorkflowType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WorkflowType;
    /**
     * Constructor method for TransactionSnapshot
     * @uses TransactionSnapshot::setAccountGroupId()
     * @uses TransactionSnapshot::setApplicationChannel()
     * @uses TransactionSnapshot::setBasket()
     * @uses TransactionSnapshot::setClient()
     * @uses TransactionSnapshot::setClients()
     * @uses TransactionSnapshot::setCommitDate()
     * @uses TransactionSnapshot::setConfirmationShiftGlobalNumber()
     * @uses TransactionSnapshot::setConfirmationShiftId()
     * @uses TransactionSnapshot::setConnectionProperties()
     * @uses TransactionSnapshot::setExtraInfo()
     * @uses TransactionSnapshot::setForeignId()
     * @uses TransactionSnapshot::setInteractionChannel()
     * @uses TransactionSnapshot::setIsPrintable()
     * @uses TransactionSnapshot::setOnBehalfOfAccountId()
     * @uses TransactionSnapshot::setRecoAccountId()
     * @uses TransactionSnapshot::setReferenceNumber()
     * @uses TransactionSnapshot::setRetailerCompanyId()
     * @uses TransactionSnapshot::setRetailerTransactionGuid()
     * @uses TransactionSnapshot::setRetailerTransactionNumber()
     * @uses TransactionSnapshot::setSaleMode()
     * @uses TransactionSnapshot::setSaleModeAccountTypeId()
     * @uses TransactionSnapshot::setState()
     * @uses TransactionSnapshot::setTransactionGuid()
     * @uses TransactionSnapshot::setTransactionNumber()
     * @uses TransactionSnapshot::setTransactionStateDate()
     * @uses TransactionSnapshot::setUseUnpublishedRules()
     * @uses TransactionSnapshot::setWorkShiftGlobalNumber()
     * @uses TransactionSnapshot::setWorkShiftId()
     * @uses TransactionSnapshot::setGroupedBasketSnapshot()
     * @uses TransactionSnapshot::setInvoiceNumber()
     * @uses TransactionSnapshot::setInvoiceType()
     * @uses TransactionSnapshot::setAgencyAccountId()
     * @uses TransactionSnapshot::setSellerBranchId()
     * @uses TransactionSnapshot::setSellerId()
     * @uses TransactionSnapshot::setSingleSupplierBranchId()
     * @uses TransactionSnapshot::setAccountContactPersonId()
     * @uses TransactionSnapshot::setAgencyContactPersonId()
     * @uses TransactionSnapshot::setPurpose()
     * @uses TransactionSnapshot::setCreditNoteNumber()
     * @uses TransactionSnapshot::setIsPartOfTransactionGroup()
     * @uses TransactionSnapshot::setWorkflowType()
     * @param string $accountGroupId
     * @param string $applicationChannel
     * @param \patest\StructType\BasketSnapshot $basket
     * @param \patest\StructType\TransactionClient $client
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidTransactionClienthpjoQDea $clients
     * @param \patest\StructType\DateTimeOffset $commitDate
     * @param int $confirmationShiftGlobalNumber
     * @param int $confirmationShiftId
     * @param \patest\StructType\ConnectionProperties $connectionProperties
     * @param \patest\StructType\ExtraFields $extraInfo
     * @param string $foreignId
     * @param string $interactionChannel
     * @param bool $isPrintable
     * @param string $onBehalfOfAccountId
     * @param string $recoAccountId
     * @param int $referenceNumber
     * @param int $retailerCompanyId
     * @param string $retailerTransactionGuid
     * @param int $retailerTransactionNumber
     * @param \patest\StructType\TransactionSaleMode $saleMode
     * @param string $saleModeAccountTypeId
     * @param string $state
     * @param string $transactionGuid
     * @param int $transactionNumber
     * @param \patest\StructType\DateTimeOffset $transactionStateDate
     * @param bool $useUnpublishedRules
     * @param int $workShiftGlobalNumber
     * @param int $workShiftId
     * @param \patest\StructType\GroupedBasketSnapshot $groupedBasketSnapshot
     * @param int $invoiceNumber
     * @param string $invoiceType
     * @param string $agencyAccountId
     * @param string $sellerBranchId
     * @param string $sellerId
     * @param string $singleSupplierBranchId
     * @param string $accountContactPersonId
     * @param string $agencyContactPersonId
     * @param string $purpose
     * @param int $creditNoteNumber
     * @param bool $isPartOfTransactionGroup
     * @param string $workflowType
     */
    public function __construct($accountGroupId = null, $applicationChannel = null, \patest\StructType\BasketSnapshot $basket = null, \patest\StructType\TransactionClient $client = null, \patest\ArrayType\ArrayOfKeyValueOfguidTransactionClienthpjoQDea $clients = null, \patest\StructType\DateTimeOffset $commitDate = null, $confirmationShiftGlobalNumber = null, $confirmationShiftId = null, \patest\StructType\ConnectionProperties $connectionProperties = null, \patest\StructType\ExtraFields $extraInfo = null, $foreignId = null, $interactionChannel = null, $isPrintable = null, $onBehalfOfAccountId = null, $recoAccountId = null, $referenceNumber = null, $retailerCompanyId = null, $retailerTransactionGuid = null, $retailerTransactionNumber = null, \patest\StructType\TransactionSaleMode $saleMode = null, $saleModeAccountTypeId = null, $state = null, $transactionGuid = null, $transactionNumber = null, \patest\StructType\DateTimeOffset $transactionStateDate = null, $useUnpublishedRules = null, $workShiftGlobalNumber = null, $workShiftId = null, \patest\StructType\GroupedBasketSnapshot $groupedBasketSnapshot = null, $invoiceNumber = null, $invoiceType = null, $agencyAccountId = null, $sellerBranchId = null, $sellerId = null, $singleSupplierBranchId = null, $accountContactPersonId = null, $agencyContactPersonId = null, $purpose = null, $creditNoteNumber = null, $isPartOfTransactionGroup = null, $workflowType = null)
    {
        $this
            ->setAccountGroupId($accountGroupId)
            ->setApplicationChannel($applicationChannel)
            ->setBasket($basket)
            ->setClient($client)
            ->setClients($clients)
            ->setCommitDate($commitDate)
            ->setConfirmationShiftGlobalNumber($confirmationShiftGlobalNumber)
            ->setConfirmationShiftId($confirmationShiftId)
            ->setConnectionProperties($connectionProperties)
            ->setExtraInfo($extraInfo)
            ->setForeignId($foreignId)
            ->setInteractionChannel($interactionChannel)
            ->setIsPrintable($isPrintable)
            ->setOnBehalfOfAccountId($onBehalfOfAccountId)
            ->setRecoAccountId($recoAccountId)
            ->setReferenceNumber($referenceNumber)
            ->setRetailerCompanyId($retailerCompanyId)
            ->setRetailerTransactionGuid($retailerTransactionGuid)
            ->setRetailerTransactionNumber($retailerTransactionNumber)
            ->setSaleMode($saleMode)
            ->setSaleModeAccountTypeId($saleModeAccountTypeId)
            ->setState($state)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionNumber($transactionNumber)
            ->setTransactionStateDate($transactionStateDate)
            ->setUseUnpublishedRules($useUnpublishedRules)
            ->setWorkShiftGlobalNumber($workShiftGlobalNumber)
            ->setWorkShiftId($workShiftId)
            ->setGroupedBasketSnapshot($groupedBasketSnapshot)
            ->setInvoiceNumber($invoiceNumber)
            ->setInvoiceType($invoiceType)
            ->setAgencyAccountId($agencyAccountId)
            ->setSellerBranchId($sellerBranchId)
            ->setSellerId($sellerId)
            ->setSingleSupplierBranchId($singleSupplierBranchId)
            ->setAccountContactPersonId($accountContactPersonId)
            ->setAgencyContactPersonId($agencyContactPersonId)
            ->setPurpose($purpose)
            ->setCreditNoteNumber($creditNoteNumber)
            ->setIsPartOfTransactionGroup($isPartOfTransactionGroup)
            ->setWorkflowType($workflowType);
    }
    /**
     * Get AccountGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountGroupId()
    {
        return isset($this->AccountGroupId) ? $this->AccountGroupId : null;
    }
    /**
     * Set AccountGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountGroupId
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setAccountGroupId($accountGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($accountGroupId) && !is_string($accountGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountGroupId, true), gettype($accountGroupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountGroupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountGroupId, true)), __LINE__);
        }
        if (is_null($accountGroupId) || (is_array($accountGroupId) && empty($accountGroupId))) {
            unset($this->AccountGroupId);
        } else {
            $this->AccountGroupId = $accountGroupId;
        }
        return $this;
    }
    /**
     * Get ApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannel()
    {
        return isset($this->ApplicationChannel) ? $this->ApplicationChannel : null;
    }
    /**
     * Set ApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannel
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setApplicationChannel($applicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannel) && !is_string($applicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannel, true), gettype($applicationChannel)), __LINE__);
        }
        if (is_null($applicationChannel) || (is_array($applicationChannel) && empty($applicationChannel))) {
            unset($this->ApplicationChannel);
        } else {
            $this->ApplicationChannel = $applicationChannel;
        }
        return $this;
    }
    /**
     * Get Basket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\BasketSnapshot|null
     */
    public function getBasket()
    {
        return isset($this->Basket) ? $this->Basket : null;
    }
    /**
     * Set Basket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\BasketSnapshot $basket
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setBasket(\patest\StructType\BasketSnapshot $basket = null)
    {
        if (is_null($basket) || (is_array($basket) && empty($basket))) {
            unset($this->Basket);
        } else {
            $this->Basket = $basket;
        }
        return $this;
    }
    /**
     * Get Client value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TransactionClient|null
     */
    public function getClient()
    {
        return isset($this->Client) ? $this->Client : null;
    }
    /**
     * Set Client value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TransactionClient $client
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setClient(\patest\StructType\TransactionClient $client = null)
    {
        if (is_null($client) || (is_array($client) && empty($client))) {
            unset($this->Client);
        } else {
            $this->Client = $client;
        }
        return $this;
    }
    /**
     * Get Clients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfguidTransactionClienthpjoQDea|null
     */
    public function getClients()
    {
        return isset($this->Clients) ? $this->Clients : null;
    }
    /**
     * Set Clients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidTransactionClienthpjoQDea $clients
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setClients(\patest\ArrayType\ArrayOfKeyValueOfguidTransactionClienthpjoQDea $clients = null)
    {
        if (is_null($clients) || (is_array($clients) && empty($clients))) {
            unset($this->Clients);
        } else {
            $this->Clients = $clients;
        }
        return $this;
    }
    /**
     * Get CommitDate value
     * @return \patest\StructType\DateTimeOffset|null
     */
    public function getCommitDate()
    {
        return $this->CommitDate;
    }
    /**
     * Set CommitDate value
     * @param \patest\StructType\DateTimeOffset $commitDate
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setCommitDate(\patest\StructType\DateTimeOffset $commitDate = null)
    {
        $this->CommitDate = $commitDate;
        return $this;
    }
    /**
     * Get ConfirmationShiftGlobalNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getConfirmationShiftGlobalNumber()
    {
        return isset($this->ConfirmationShiftGlobalNumber) ? $this->ConfirmationShiftGlobalNumber : null;
    }
    /**
     * Set ConfirmationShiftGlobalNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $confirmationShiftGlobalNumber
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setConfirmationShiftGlobalNumber($confirmationShiftGlobalNumber = null)
    {
        // validation for constraint: int
        if (!is_null($confirmationShiftGlobalNumber) && !(is_int($confirmationShiftGlobalNumber) || ctype_digit($confirmationShiftGlobalNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($confirmationShiftGlobalNumber, true), gettype($confirmationShiftGlobalNumber)), __LINE__);
        }
        if (is_null($confirmationShiftGlobalNumber) || (is_array($confirmationShiftGlobalNumber) && empty($confirmationShiftGlobalNumber))) {
            unset($this->ConfirmationShiftGlobalNumber);
        } else {
            $this->ConfirmationShiftGlobalNumber = $confirmationShiftGlobalNumber;
        }
        return $this;
    }
    /**
     * Get ConfirmationShiftId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getConfirmationShiftId()
    {
        return isset($this->ConfirmationShiftId) ? $this->ConfirmationShiftId : null;
    }
    /**
     * Set ConfirmationShiftId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $confirmationShiftId
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setConfirmationShiftId($confirmationShiftId = null)
    {
        // validation for constraint: int
        if (!is_null($confirmationShiftId) && !(is_int($confirmationShiftId) || ctype_digit($confirmationShiftId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($confirmationShiftId, true), gettype($confirmationShiftId)), __LINE__);
        }
        if (is_null($confirmationShiftId) || (is_array($confirmationShiftId) && empty($confirmationShiftId))) {
            unset($this->ConfirmationShiftId);
        } else {
            $this->ConfirmationShiftId = $confirmationShiftId;
        }
        return $this;
    }
    /**
     * Get ConnectionProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ConnectionProperties|null
     */
    public function getConnectionProperties()
    {
        return isset($this->ConnectionProperties) ? $this->ConnectionProperties : null;
    }
    /**
     * Set ConnectionProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ConnectionProperties $connectionProperties
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setConnectionProperties(\patest\StructType\ConnectionProperties $connectionProperties = null)
    {
        if (is_null($connectionProperties) || (is_array($connectionProperties) && empty($connectionProperties))) {
            unset($this->ConnectionProperties);
        } else {
            $this->ConnectionProperties = $connectionProperties;
        }
        return $this;
    }
    /**
     * Get ExtraInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ExtraFields|null
     */
    public function getExtraInfo()
    {
        return isset($this->ExtraInfo) ? $this->ExtraInfo : null;
    }
    /**
     * Set ExtraInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ExtraFields $extraInfo
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setExtraInfo(\patest\StructType\ExtraFields $extraInfo = null)
    {
        if (is_null($extraInfo) || (is_array($extraInfo) && empty($extraInfo))) {
            unset($this->ExtraInfo);
        } else {
            $this->ExtraInfo = $extraInfo;
        }
        return $this;
    }
    /**
     * Get ForeignId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForeignId()
    {
        return isset($this->ForeignId) ? $this->ForeignId : null;
    }
    /**
     * Set ForeignId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $foreignId
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setForeignId($foreignId = null)
    {
        // validation for constraint: string
        if (!is_null($foreignId) && !is_string($foreignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foreignId, true), gettype($foreignId)), __LINE__);
        }
        if (is_null($foreignId) || (is_array($foreignId) && empty($foreignId))) {
            unset($this->ForeignId);
        } else {
            $this->ForeignId = $foreignId;
        }
        return $this;
    }
    /**
     * Get InteractionChannel value
     * @return string|null
     */
    public function getInteractionChannel()
    {
        return $this->InteractionChannel;
    }
    /**
     * Set InteractionChannel value
     * @uses \patest\EnumType\TransactionInteractionChannel::valueIsValid()
     * @uses \patest\EnumType\TransactionInteractionChannel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $interactionChannel
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setInteractionChannel($interactionChannel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionInteractionChannel::valueIsValid($interactionChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionInteractionChannel', is_array($interactionChannel) ? implode(', ', $interactionChannel) : var_export($interactionChannel, true), implode(', ', \patest\EnumType\TransactionInteractionChannel::getValidValues())), __LINE__);
        }
        $this->InteractionChannel = $interactionChannel;
        return $this;
    }
    /**
     * Get IsPrintable value
     * @return bool|null
     */
    public function getIsPrintable()
    {
        return $this->IsPrintable;
    }
    /**
     * Set IsPrintable value
     * @param bool $isPrintable
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setIsPrintable($isPrintable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrintable) && !is_bool($isPrintable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrintable, true), gettype($isPrintable)), __LINE__);
        }
        $this->IsPrintable = $isPrintable;
        return $this;
    }
    /**
     * Get OnBehalfOfAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOnBehalfOfAccountId()
    {
        return isset($this->OnBehalfOfAccountId) ? $this->OnBehalfOfAccountId : null;
    }
    /**
     * Set OnBehalfOfAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $onBehalfOfAccountId
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setOnBehalfOfAccountId($onBehalfOfAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($onBehalfOfAccountId) && !is_string($onBehalfOfAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onBehalfOfAccountId, true), gettype($onBehalfOfAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($onBehalfOfAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $onBehalfOfAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($onBehalfOfAccountId, true)), __LINE__);
        }
        if (is_null($onBehalfOfAccountId) || (is_array($onBehalfOfAccountId) && empty($onBehalfOfAccountId))) {
            unset($this->OnBehalfOfAccountId);
        } else {
            $this->OnBehalfOfAccountId = $onBehalfOfAccountId;
        }
        return $this;
    }
    /**
     * Get RecoAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecoAccountId()
    {
        return isset($this->RecoAccountId) ? $this->RecoAccountId : null;
    }
    /**
     * Set RecoAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recoAccountId
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setRecoAccountId($recoAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($recoAccountId) && !is_string($recoAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recoAccountId, true), gettype($recoAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($recoAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $recoAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($recoAccountId, true)), __LINE__);
        }
        if (is_null($recoAccountId) || (is_array($recoAccountId) && empty($recoAccountId))) {
            unset($this->RecoAccountId);
        } else {
            $this->RecoAccountId = $recoAccountId;
        }
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return int|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param int $referenceNumber
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($referenceNumber) && !(is_int($referenceNumber) || ctype_digit($referenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get RetailerCompanyId value
     * @return int|null
     */
    public function getRetailerCompanyId()
    {
        return $this->RetailerCompanyId;
    }
    /**
     * Set RetailerCompanyId value
     * @param int $retailerCompanyId
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setRetailerCompanyId($retailerCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($retailerCompanyId) && !(is_int($retailerCompanyId) || ctype_digit($retailerCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($retailerCompanyId, true), gettype($retailerCompanyId)), __LINE__);
        }
        $this->RetailerCompanyId = $retailerCompanyId;
        return $this;
    }
    /**
     * Get RetailerTransactionGuid value
     * @return string|null
     */
    public function getRetailerTransactionGuid()
    {
        return $this->RetailerTransactionGuid;
    }
    /**
     * Set RetailerTransactionGuid value
     * @param string $retailerTransactionGuid
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setRetailerTransactionGuid($retailerTransactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($retailerTransactionGuid) && !is_string($retailerTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retailerTransactionGuid, true), gettype($retailerTransactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($retailerTransactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $retailerTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($retailerTransactionGuid, true)), __LINE__);
        }
        $this->RetailerTransactionGuid = $retailerTransactionGuid;
        return $this;
    }
    /**
     * Get RetailerTransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRetailerTransactionNumber()
    {
        return isset($this->RetailerTransactionNumber) ? $this->RetailerTransactionNumber : null;
    }
    /**
     * Set RetailerTransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $retailerTransactionNumber
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setRetailerTransactionNumber($retailerTransactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($retailerTransactionNumber) && !(is_int($retailerTransactionNumber) || ctype_digit($retailerTransactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($retailerTransactionNumber, true), gettype($retailerTransactionNumber)), __LINE__);
        }
        if (is_null($retailerTransactionNumber) || (is_array($retailerTransactionNumber) && empty($retailerTransactionNumber))) {
            unset($this->RetailerTransactionNumber);
        } else {
            $this->RetailerTransactionNumber = $retailerTransactionNumber;
        }
        return $this;
    }
    /**
     * Get SaleMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TransactionSaleMode|null
     */
    public function getSaleMode()
    {
        return isset($this->SaleMode) ? $this->SaleMode : null;
    }
    /**
     * Set SaleMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TransactionSaleMode $saleMode
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setSaleMode(\patest\StructType\TransactionSaleMode $saleMode = null)
    {
        if (is_null($saleMode) || (is_array($saleMode) && empty($saleMode))) {
            unset($this->SaleMode);
        } else {
            $this->SaleMode = $saleMode;
        }
        return $this;
    }
    /**
     * Get SaleModeAccountTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleModeAccountTypeId()
    {
        return isset($this->SaleModeAccountTypeId) ? $this->SaleModeAccountTypeId : null;
    }
    /**
     * Set SaleModeAccountTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleModeAccountTypeId
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setSaleModeAccountTypeId($saleModeAccountTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($saleModeAccountTypeId) && !is_string($saleModeAccountTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleModeAccountTypeId, true), gettype($saleModeAccountTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($saleModeAccountTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $saleModeAccountTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($saleModeAccountTypeId, true)), __LINE__);
        }
        if (is_null($saleModeAccountTypeId) || (is_array($saleModeAccountTypeId) && empty($saleModeAccountTypeId))) {
            unset($this->SaleModeAccountTypeId);
        } else {
            $this->SaleModeAccountTypeId = $saleModeAccountTypeId;
        }
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @uses \patest\EnumType\TransactionState::valueIsValid()
     * @uses \patest\EnumType\TransactionState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionState::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionState', is_array($state) ? implode(', ', $state) : var_export($state, true), implode(', ', \patest\EnumType\TransactionState::getValidValues())), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get TransactionStateDate value
     * @return \patest\StructType\DateTimeOffset|null
     */
    public function getTransactionStateDate()
    {
        return $this->TransactionStateDate;
    }
    /**
     * Set TransactionStateDate value
     * @param \patest\StructType\DateTimeOffset $transactionStateDate
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setTransactionStateDate(\patest\StructType\DateTimeOffset $transactionStateDate = null)
    {
        $this->TransactionStateDate = $transactionStateDate;
        return $this;
    }
    /**
     * Get UseUnpublishedRules value
     * @return bool|null
     */
    public function getUseUnpublishedRules()
    {
        return $this->UseUnpublishedRules;
    }
    /**
     * Set UseUnpublishedRules value
     * @param bool $useUnpublishedRules
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setUseUnpublishedRules($useUnpublishedRules = null)
    {
        // validation for constraint: boolean
        if (!is_null($useUnpublishedRules) && !is_bool($useUnpublishedRules)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useUnpublishedRules, true), gettype($useUnpublishedRules)), __LINE__);
        }
        $this->UseUnpublishedRules = $useUnpublishedRules;
        return $this;
    }
    /**
     * Get WorkShiftGlobalNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getWorkShiftGlobalNumber()
    {
        return isset($this->WorkShiftGlobalNumber) ? $this->WorkShiftGlobalNumber : null;
    }
    /**
     * Set WorkShiftGlobalNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $workShiftGlobalNumber
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setWorkShiftGlobalNumber($workShiftGlobalNumber = null)
    {
        // validation for constraint: int
        if (!is_null($workShiftGlobalNumber) && !(is_int($workShiftGlobalNumber) || ctype_digit($workShiftGlobalNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($workShiftGlobalNumber, true), gettype($workShiftGlobalNumber)), __LINE__);
        }
        if (is_null($workShiftGlobalNumber) || (is_array($workShiftGlobalNumber) && empty($workShiftGlobalNumber))) {
            unset($this->WorkShiftGlobalNumber);
        } else {
            $this->WorkShiftGlobalNumber = $workShiftGlobalNumber;
        }
        return $this;
    }
    /**
     * Get WorkShiftId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getWorkShiftId()
    {
        return isset($this->WorkShiftId) ? $this->WorkShiftId : null;
    }
    /**
     * Set WorkShiftId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $workShiftId
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setWorkShiftId($workShiftId = null)
    {
        // validation for constraint: int
        if (!is_null($workShiftId) && !(is_int($workShiftId) || ctype_digit($workShiftId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($workShiftId, true), gettype($workShiftId)), __LINE__);
        }
        if (is_null($workShiftId) || (is_array($workShiftId) && empty($workShiftId))) {
            unset($this->WorkShiftId);
        } else {
            $this->WorkShiftId = $workShiftId;
        }
        return $this;
    }
    /**
     * Get GroupedBasketSnapshot value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GroupedBasketSnapshot|null
     */
    public function getGroupedBasketSnapshot()
    {
        return isset($this->GroupedBasketSnapshot) ? $this->GroupedBasketSnapshot : null;
    }
    /**
     * Set GroupedBasketSnapshot value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GroupedBasketSnapshot $groupedBasketSnapshot
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setGroupedBasketSnapshot(\patest\StructType\GroupedBasketSnapshot $groupedBasketSnapshot = null)
    {
        if (is_null($groupedBasketSnapshot) || (is_array($groupedBasketSnapshot) && empty($groupedBasketSnapshot))) {
            unset($this->GroupedBasketSnapshot);
        } else {
            $this->GroupedBasketSnapshot = $groupedBasketSnapshot;
        }
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInvoiceNumber()
    {
        return isset($this->InvoiceNumber) ? $this->InvoiceNumber : null;
    }
    /**
     * Set InvoiceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $invoiceNumber
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceNumber) && !(is_int($invoiceNumber) || ctype_digit($invoiceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        if (is_null($invoiceNumber) || (is_array($invoiceNumber) && empty($invoiceNumber))) {
            unset($this->InvoiceNumber);
        } else {
            $this->InvoiceNumber = $invoiceNumber;
        }
        return $this;
    }
    /**
     * Get InvoiceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoiceType()
    {
        return isset($this->InvoiceType) ? $this->InvoiceType : null;
    }
    /**
     * Set InvoiceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AccountingDocumentType::valueIsValid()
     * @uses \patest\EnumType\AccountingDocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $invoiceType
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setInvoiceType($invoiceType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AccountingDocumentType::valueIsValid($invoiceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AccountingDocumentType', is_array($invoiceType) ? implode(', ', $invoiceType) : var_export($invoiceType, true), implode(', ', \patest\EnumType\AccountingDocumentType::getValidValues())), __LINE__);
        }
        if (is_null($invoiceType) || (is_array($invoiceType) && empty($invoiceType))) {
            unset($this->InvoiceType);
        } else {
            $this->InvoiceType = $invoiceType;
        }
        return $this;
    }
    /**
     * Get AgencyAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgencyAccountId()
    {
        return isset($this->AgencyAccountId) ? $this->AgencyAccountId : null;
    }
    /**
     * Set AgencyAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agencyAccountId
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setAgencyAccountId($agencyAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($agencyAccountId) && !is_string($agencyAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyAccountId, true), gettype($agencyAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($agencyAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $agencyAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($agencyAccountId, true)), __LINE__);
        }
        if (is_null($agencyAccountId) || (is_array($agencyAccountId) && empty($agencyAccountId))) {
            unset($this->AgencyAccountId);
        } else {
            $this->AgencyAccountId = $agencyAccountId;
        }
        return $this;
    }
    /**
     * Get SellerBranchId value
     * @return string|null
     */
    public function getSellerBranchId()
    {
        return $this->SellerBranchId;
    }
    /**
     * Set SellerBranchId value
     * @param string $sellerBranchId
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setSellerBranchId($sellerBranchId = null)
    {
        // validation for constraint: string
        if (!is_null($sellerBranchId) && !is_string($sellerBranchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerBranchId, true), gettype($sellerBranchId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sellerBranchId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sellerBranchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sellerBranchId, true)), __LINE__);
        }
        $this->SellerBranchId = $sellerBranchId;
        return $this;
    }
    /**
     * Get SellerId value
     * @return string|null
     */
    public function getSellerId()
    {
        return $this->SellerId;
    }
    /**
     * Set SellerId value
     * @param string $sellerId
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setSellerId($sellerId = null)
    {
        // validation for constraint: string
        if (!is_null($sellerId) && !is_string($sellerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerId, true), gettype($sellerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sellerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sellerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sellerId, true)), __LINE__);
        }
        $this->SellerId = $sellerId;
        return $this;
    }
    /**
     * Get SingleSupplierBranchId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSingleSupplierBranchId()
    {
        return isset($this->SingleSupplierBranchId) ? $this->SingleSupplierBranchId : null;
    }
    /**
     * Set SingleSupplierBranchId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $singleSupplierBranchId
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setSingleSupplierBranchId($singleSupplierBranchId = null)
    {
        // validation for constraint: string
        if (!is_null($singleSupplierBranchId) && !is_string($singleSupplierBranchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($singleSupplierBranchId, true), gettype($singleSupplierBranchId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($singleSupplierBranchId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $singleSupplierBranchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($singleSupplierBranchId, true)), __LINE__);
        }
        if (is_null($singleSupplierBranchId) || (is_array($singleSupplierBranchId) && empty($singleSupplierBranchId))) {
            unset($this->SingleSupplierBranchId);
        } else {
            $this->SingleSupplierBranchId = $singleSupplierBranchId;
        }
        return $this;
    }
    /**
     * Get AccountContactPersonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountContactPersonId()
    {
        return isset($this->AccountContactPersonId) ? $this->AccountContactPersonId : null;
    }
    /**
     * Set AccountContactPersonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountContactPersonId
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setAccountContactPersonId($accountContactPersonId = null)
    {
        // validation for constraint: string
        if (!is_null($accountContactPersonId) && !is_string($accountContactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountContactPersonId, true), gettype($accountContactPersonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountContactPersonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountContactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountContactPersonId, true)), __LINE__);
        }
        if (is_null($accountContactPersonId) || (is_array($accountContactPersonId) && empty($accountContactPersonId))) {
            unset($this->AccountContactPersonId);
        } else {
            $this->AccountContactPersonId = $accountContactPersonId;
        }
        return $this;
    }
    /**
     * Get AgencyContactPersonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgencyContactPersonId()
    {
        return isset($this->AgencyContactPersonId) ? $this->AgencyContactPersonId : null;
    }
    /**
     * Set AgencyContactPersonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agencyContactPersonId
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setAgencyContactPersonId($agencyContactPersonId = null)
    {
        // validation for constraint: string
        if (!is_null($agencyContactPersonId) && !is_string($agencyContactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyContactPersonId, true), gettype($agencyContactPersonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($agencyContactPersonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $agencyContactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($agencyContactPersonId, true)), __LINE__);
        }
        if (is_null($agencyContactPersonId) || (is_array($agencyContactPersonId) && empty($agencyContactPersonId))) {
            unset($this->AgencyContactPersonId);
        } else {
            $this->AgencyContactPersonId = $agencyContactPersonId;
        }
        return $this;
    }
    /**
     * Get Purpose value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurpose()
    {
        return isset($this->Purpose) ? $this->Purpose : null;
    }
    /**
     * Set Purpose value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purpose
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setPurpose($purpose = null)
    {
        // validation for constraint: string
        if (!is_null($purpose) && !is_string($purpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purpose, true), gettype($purpose)), __LINE__);
        }
        if (is_null($purpose) || (is_array($purpose) && empty($purpose))) {
            unset($this->Purpose);
        } else {
            $this->Purpose = $purpose;
        }
        return $this;
    }
    /**
     * Get CreditNoteNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCreditNoteNumber()
    {
        return isset($this->CreditNoteNumber) ? $this->CreditNoteNumber : null;
    }
    /**
     * Set CreditNoteNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $creditNoteNumber
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setCreditNoteNumber($creditNoteNumber = null)
    {
        // validation for constraint: int
        if (!is_null($creditNoteNumber) && !(is_int($creditNoteNumber) || ctype_digit($creditNoteNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creditNoteNumber, true), gettype($creditNoteNumber)), __LINE__);
        }
        if (is_null($creditNoteNumber) || (is_array($creditNoteNumber) && empty($creditNoteNumber))) {
            unset($this->CreditNoteNumber);
        } else {
            $this->CreditNoteNumber = $creditNoteNumber;
        }
        return $this;
    }
    /**
     * Get IsPartOfTransactionGroup value
     * @return bool|null
     */
    public function getIsPartOfTransactionGroup()
    {
        return $this->IsPartOfTransactionGroup;
    }
    /**
     * Set IsPartOfTransactionGroup value
     * @param bool $isPartOfTransactionGroup
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setIsPartOfTransactionGroup($isPartOfTransactionGroup = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPartOfTransactionGroup) && !is_bool($isPartOfTransactionGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPartOfTransactionGroup, true), gettype($isPartOfTransactionGroup)), __LINE__);
        }
        $this->IsPartOfTransactionGroup = $isPartOfTransactionGroup;
        return $this;
    }
    /**
     * Get WorkflowType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWorkflowType()
    {
        return isset($this->WorkflowType) ? $this->WorkflowType : null;
    }
    /**
     * Set WorkflowType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\WorkflowType::valueIsValid()
     * @uses \patest\EnumType\WorkflowType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $workflowType
     * @return \patest\StructType\TransactionSnapshot
     */
    public function setWorkflowType($workflowType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\WorkflowType::valueIsValid($workflowType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\WorkflowType', is_array($workflowType) ? implode(', ', $workflowType) : var_export($workflowType, true), implode(', ', \patest\EnumType\WorkflowType::getValidValues())), __LINE__);
        }
        if (is_null($workflowType) || (is_array($workflowType) && empty($workflowType))) {
            unset($this->WorkflowType);
        } else {
            $this->WorkflowType = $workflowType;
        }
        return $this;
    }
}
