<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionDataMedium StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TransactionDataMedium
 * @subpackage Structs
 */
class TransactionDataMedium extends TransactionDataMin
{
    /**
     * The HasHistory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasHistory;
    /**
     * The IncludesComplimentary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludesComplimentary;
    /**
     * The IncludesReservation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludesReservation;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notes;
    /**
     * The SGOrderId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SGOrderId;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The IncludesGiftVouchers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludesGiftVouchers;
    /**
     * The IncludesMemberships
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludesMemberships;
    /**
     * The OnBehalfOfAccountName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OnBehalfOfAccountName;
    /**
     * The SaleModeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SaleModeName;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * The TotalActualPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalActualPayment;
    /**
     * The TotalTransactionValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalTransactionValue;
    /**
     * Constructor method for TransactionDataMedium
     * @uses TransactionDataMedium::setHasHistory()
     * @uses TransactionDataMedium::setIncludesComplimentary()
     * @uses TransactionDataMedium::setIncludesReservation()
     * @uses TransactionDataMedium::setNotes()
     * @uses TransactionDataMedium::setSGOrderId()
     * @uses TransactionDataMedium::setStatus()
     * @uses TransactionDataMedium::setIncludesGiftVouchers()
     * @uses TransactionDataMedium::setIncludesMemberships()
     * @uses TransactionDataMedium::setOnBehalfOfAccountName()
     * @uses TransactionDataMedium::setSaleModeName()
     * @uses TransactionDataMedium::setUserName()
     * @uses TransactionDataMedium::setTotalActualPayment()
     * @uses TransactionDataMedium::setTotalTransactionValue()
     * @param bool $hasHistory
     * @param bool $includesComplimentary
     * @param bool $includesReservation
     * @param string $notes
     * @param string $sGOrderId
     * @param string $status
     * @param bool $includesGiftVouchers
     * @param bool $includesMemberships
     * @param string $onBehalfOfAccountName
     * @param string $saleModeName
     * @param string $userName
     * @param \patest\StructType\Money $totalActualPayment
     * @param \patest\StructType\Money $totalTransactionValue
     */
    public function __construct($hasHistory = null, $includesComplimentary = null, $includesReservation = null, $notes = null, $sGOrderId = null, $status = null, $includesGiftVouchers = null, $includesMemberships = null, $onBehalfOfAccountName = null, $saleModeName = null, $userName = null, \patest\StructType\Money $totalActualPayment = null, \patest\StructType\Money $totalTransactionValue = null)
    {
        $this
            ->setHasHistory($hasHistory)
            ->setIncludesComplimentary($includesComplimentary)
            ->setIncludesReservation($includesReservation)
            ->setNotes($notes)
            ->setSGOrderId($sGOrderId)
            ->setStatus($status)
            ->setIncludesGiftVouchers($includesGiftVouchers)
            ->setIncludesMemberships($includesMemberships)
            ->setOnBehalfOfAccountName($onBehalfOfAccountName)
            ->setSaleModeName($saleModeName)
            ->setUserName($userName)
            ->setTotalActualPayment($totalActualPayment)
            ->setTotalTransactionValue($totalTransactionValue);
    }
    /**
     * Get HasHistory value
     * @return bool|null
     */
    public function getHasHistory()
    {
        return $this->HasHistory;
    }
    /**
     * Set HasHistory value
     * @param bool $hasHistory
     * @return \patest\StructType\TransactionDataMedium
     */
    public function setHasHistory($hasHistory = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasHistory) && !is_bool($hasHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasHistory, true), gettype($hasHistory)), __LINE__);
        }
        $this->HasHistory = $hasHistory;
        return $this;
    }
    /**
     * Get IncludesComplimentary value
     * @return bool|null
     */
    public function getIncludesComplimentary()
    {
        return $this->IncludesComplimentary;
    }
    /**
     * Set IncludesComplimentary value
     * @param bool $includesComplimentary
     * @return \patest\StructType\TransactionDataMedium
     */
    public function setIncludesComplimentary($includesComplimentary = null)
    {
        // validation for constraint: boolean
        if (!is_null($includesComplimentary) && !is_bool($includesComplimentary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includesComplimentary, true), gettype($includesComplimentary)), __LINE__);
        }
        $this->IncludesComplimentary = $includesComplimentary;
        return $this;
    }
    /**
     * Get IncludesReservation value
     * @return bool|null
     */
    public function getIncludesReservation()
    {
        return $this->IncludesReservation;
    }
    /**
     * Set IncludesReservation value
     * @param bool $includesReservation
     * @return \patest\StructType\TransactionDataMedium
     */
    public function setIncludesReservation($includesReservation = null)
    {
        // validation for constraint: boolean
        if (!is_null($includesReservation) && !is_bool($includesReservation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includesReservation, true), gettype($includesReservation)), __LINE__);
        }
        $this->IncludesReservation = $includesReservation;
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notes
     * @return \patest\StructType\TransactionDataMedium
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get SGOrderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSGOrderId()
    {
        return isset($this->SGOrderId) ? $this->SGOrderId : null;
    }
    /**
     * Set SGOrderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sGOrderId
     * @return \patest\StructType\TransactionDataMedium
     */
    public function setSGOrderId($sGOrderId = null)
    {
        // validation for constraint: string
        if (!is_null($sGOrderId) && !is_string($sGOrderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sGOrderId, true), gettype($sGOrderId)), __LINE__);
        }
        if (is_null($sGOrderId) || (is_array($sGOrderId) && empty($sGOrderId))) {
            unset($this->SGOrderId);
        } else {
            $this->SGOrderId = $sGOrderId;
        }
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \patest\EnumType\TransactionStatusSearchType::valueIsValid()
     * @uses \patest\EnumType\TransactionStatusSearchType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\TransactionDataMedium
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionStatusSearchType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionStatusSearchType', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\TransactionStatusSearchType::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get IncludesGiftVouchers value
     * @return bool|null
     */
    public function getIncludesGiftVouchers()
    {
        return $this->IncludesGiftVouchers;
    }
    /**
     * Set IncludesGiftVouchers value
     * @param bool $includesGiftVouchers
     * @return \patest\StructType\TransactionDataMedium
     */
    public function setIncludesGiftVouchers($includesGiftVouchers = null)
    {
        // validation for constraint: boolean
        if (!is_null($includesGiftVouchers) && !is_bool($includesGiftVouchers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includesGiftVouchers, true), gettype($includesGiftVouchers)), __LINE__);
        }
        $this->IncludesGiftVouchers = $includesGiftVouchers;
        return $this;
    }
    /**
     * Get IncludesMemberships value
     * @return bool|null
     */
    public function getIncludesMemberships()
    {
        return $this->IncludesMemberships;
    }
    /**
     * Set IncludesMemberships value
     * @param bool $includesMemberships
     * @return \patest\StructType\TransactionDataMedium
     */
    public function setIncludesMemberships($includesMemberships = null)
    {
        // validation for constraint: boolean
        if (!is_null($includesMemberships) && !is_bool($includesMemberships)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includesMemberships, true), gettype($includesMemberships)), __LINE__);
        }
        $this->IncludesMemberships = $includesMemberships;
        return $this;
    }
    /**
     * Get OnBehalfOfAccountName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOnBehalfOfAccountName()
    {
        return isset($this->OnBehalfOfAccountName) ? $this->OnBehalfOfAccountName : null;
    }
    /**
     * Set OnBehalfOfAccountName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $onBehalfOfAccountName
     * @return \patest\StructType\TransactionDataMedium
     */
    public function setOnBehalfOfAccountName($onBehalfOfAccountName = null)
    {
        // validation for constraint: string
        if (!is_null($onBehalfOfAccountName) && !is_string($onBehalfOfAccountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onBehalfOfAccountName, true), gettype($onBehalfOfAccountName)), __LINE__);
        }
        if (is_null($onBehalfOfAccountName) || (is_array($onBehalfOfAccountName) && empty($onBehalfOfAccountName))) {
            unset($this->OnBehalfOfAccountName);
        } else {
            $this->OnBehalfOfAccountName = $onBehalfOfAccountName;
        }
        return $this;
    }
    /**
     * Get SaleModeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleModeName()
    {
        return isset($this->SaleModeName) ? $this->SaleModeName : null;
    }
    /**
     * Set SaleModeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleModeName
     * @return \patest\StructType\TransactionDataMedium
     */
    public function setSaleModeName($saleModeName = null)
    {
        // validation for constraint: string
        if (!is_null($saleModeName) && !is_string($saleModeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleModeName, true), gettype($saleModeName)), __LINE__);
        }
        if (is_null($saleModeName) || (is_array($saleModeName) && empty($saleModeName))) {
            unset($this->SaleModeName);
        } else {
            $this->SaleModeName = $saleModeName;
        }
        return $this;
    }
    /**
     * Get UserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserName()
    {
        return isset($this->UserName) ? $this->UserName : null;
    }
    /**
     * Set UserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userName
     * @return \patest\StructType\TransactionDataMedium
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        if (is_null($userName) || (is_array($userName) && empty($userName))) {
            unset($this->UserName);
        } else {
            $this->UserName = $userName;
        }
        return $this;
    }
    /**
     * Get TotalActualPayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalActualPayment()
    {
        return isset($this->TotalActualPayment) ? $this->TotalActualPayment : null;
    }
    /**
     * Set TotalActualPayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalActualPayment
     * @return \patest\StructType\TransactionDataMedium
     */
    public function setTotalActualPayment(\patest\StructType\Money $totalActualPayment = null)
    {
        if (is_null($totalActualPayment) || (is_array($totalActualPayment) && empty($totalActualPayment))) {
            unset($this->TotalActualPayment);
        } else {
            $this->TotalActualPayment = $totalActualPayment;
        }
        return $this;
    }
    /**
     * Get TotalTransactionValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalTransactionValue()
    {
        return isset($this->TotalTransactionValue) ? $this->TotalTransactionValue : null;
    }
    /**
     * Set TotalTransactionValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalTransactionValue
     * @return \patest\StructType\TransactionDataMedium
     */
    public function setTotalTransactionValue(\patest\StructType\Money $totalTransactionValue = null)
    {
        if (is_null($totalTransactionValue) || (is_array($totalTransactionValue) && empty($totalTransactionValue))) {
            unset($this->TotalTransactionValue);
        } else {
            $this->TotalTransactionValue = $totalTransactionValue;
        }
        return $this;
    }
}
