<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TraceFilter StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TraceFilter
 * @subpackage Structs
 */
class TraceFilter extends AbstractStructBase
{
    /**
     * The FilterName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FilterName;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfTraceFilterItem
     */
    public $Items;
    /**
     * The TenantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TenantId;
    /**
     * Constructor method for TraceFilter
     * @uses TraceFilter::setFilterName()
     * @uses TraceFilter::setItems()
     * @uses TraceFilter::setTenantId()
     * @param string $filterName
     * @param \patest\ArrayType\ArrayOfTraceFilterItem $items
     * @param int $tenantId
     */
    public function __construct($filterName = null, \patest\ArrayType\ArrayOfTraceFilterItem $items = null, $tenantId = null)
    {
        $this
            ->setFilterName($filterName)
            ->setItems($items)
            ->setTenantId($tenantId);
    }
    /**
     * Get FilterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFilterName()
    {
        return isset($this->FilterName) ? $this->FilterName : null;
    }
    /**
     * Set FilterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $filterName
     * @return \patest\StructType\TraceFilter
     */
    public function setFilterName($filterName = null)
    {
        // validation for constraint: string
        if (!is_null($filterName) && !is_string($filterName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filterName, true), gettype($filterName)), __LINE__);
        }
        if (is_null($filterName) || (is_array($filterName) && empty($filterName))) {
            unset($this->FilterName);
        } else {
            $this->FilterName = $filterName;
        }
        return $this;
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfTraceFilterItem|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfTraceFilterItem $items
     * @return \patest\StructType\TraceFilter
     */
    public function setItems(\patest\ArrayType\ArrayOfTraceFilterItem $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Get TenantId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTenantId()
    {
        return isset($this->TenantId) ? $this->TenantId : null;
    }
    /**
     * Set TenantId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $tenantId
     * @return \patest\StructType\TraceFilter
     */
    public function setTenantId($tenantId = null)
    {
        // validation for constraint: int
        if (!is_null($tenantId) && !(is_int($tenantId) || ctype_digit($tenantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tenantId, true), gettype($tenantId)), __LINE__);
        }
        if (is_null($tenantId) || (is_array($tenantId) && empty($tenantId))) {
            unset($this->TenantId);
        } else {
            $this->TenantId = $tenantId;
        }
        return $this;
    }
}
