<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.Winner StructType
 * @subpackage Structs
 */
class Ticketing_Winner extends AnyEntity
{
    /**
     * The Area
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Area;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ProcessNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ProcessNumber;
    /**
     * The RequestedSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RequestedSeats;
    /**
     * The Row
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Row;
    /**
     * The Seats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Seats;
    /**
     * The Sector
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Sector;
    /**
     * The WonSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $WonSeats;
    /**
     * Constructor method for Ticketing.Winner
     * @uses Ticketing_Winner::setArea()
     * @uses Ticketing_Winner::setClientId()
     * @uses Ticketing_Winner::setProcessNumber()
     * @uses Ticketing_Winner::setRequestedSeats()
     * @uses Ticketing_Winner::setRow()
     * @uses Ticketing_Winner::setSeats()
     * @uses Ticketing_Winner::setSector()
     * @uses Ticketing_Winner::setWonSeats()
     * @param string $area
     * @param string $clientId
     * @param int $processNumber
     * @param int $requestedSeats
     * @param string $row
     * @param string $seats
     * @param string $sector
     * @param int $wonSeats
     */
    public function __construct($area = null, $clientId = null, $processNumber = null, $requestedSeats = null, $row = null, $seats = null, $sector = null, $wonSeats = null)
    {
        $this
            ->setArea($area)
            ->setClientId($clientId)
            ->setProcessNumber($processNumber)
            ->setRequestedSeats($requestedSeats)
            ->setRow($row)
            ->setSeats($seats)
            ->setSector($sector)
            ->setWonSeats($wonSeats);
    }
    /**
     * Get Area value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArea()
    {
        return isset($this->Area) ? $this->Area : null;
    }
    /**
     * Set Area value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $area
     * @return \patest\StructType\Ticketing_Winner
     */
    public function setArea($area = null)
    {
        // validation for constraint: string
        if (!is_null($area) && !is_string($area)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($area, true), gettype($area)), __LINE__);
        }
        if (is_null($area) || (is_array($area) && empty($area))) {
            unset($this->Area);
        } else {
            $this->Area = $area;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Ticketing_Winner
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ProcessNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProcessNumber()
    {
        return isset($this->ProcessNumber) ? $this->ProcessNumber : null;
    }
    /**
     * Set ProcessNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $processNumber
     * @return \patest\StructType\Ticketing_Winner
     */
    public function setProcessNumber($processNumber = null)
    {
        // validation for constraint: int
        if (!is_null($processNumber) && !(is_int($processNumber) || ctype_digit($processNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($processNumber, true), gettype($processNumber)), __LINE__);
        }
        if (is_null($processNumber) || (is_array($processNumber) && empty($processNumber))) {
            unset($this->ProcessNumber);
        } else {
            $this->ProcessNumber = $processNumber;
        }
        return $this;
    }
    /**
     * Get RequestedSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRequestedSeats()
    {
        return isset($this->RequestedSeats) ? $this->RequestedSeats : null;
    }
    /**
     * Set RequestedSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $requestedSeats
     * @return \patest\StructType\Ticketing_Winner
     */
    public function setRequestedSeats($requestedSeats = null)
    {
        // validation for constraint: int
        if (!is_null($requestedSeats) && !(is_int($requestedSeats) || ctype_digit($requestedSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestedSeats, true), gettype($requestedSeats)), __LINE__);
        }
        if (is_null($requestedSeats) || (is_array($requestedSeats) && empty($requestedSeats))) {
            unset($this->RequestedSeats);
        } else {
            $this->RequestedSeats = $requestedSeats;
        }
        return $this;
    }
    /**
     * Get Row value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRow()
    {
        return isset($this->Row) ? $this->Row : null;
    }
    /**
     * Set Row value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $row
     * @return \patest\StructType\Ticketing_Winner
     */
    public function setRow($row = null)
    {
        // validation for constraint: string
        if (!is_null($row) && !is_string($row)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($row, true), gettype($row)), __LINE__);
        }
        if (is_null($row) || (is_array($row) && empty($row))) {
            unset($this->Row);
        } else {
            $this->Row = $row;
        }
        return $this;
    }
    /**
     * Get Seats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeats()
    {
        return isset($this->Seats) ? $this->Seats : null;
    }
    /**
     * Set Seats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seats
     * @return \patest\StructType\Ticketing_Winner
     */
    public function setSeats($seats = null)
    {
        // validation for constraint: string
        if (!is_null($seats) && !is_string($seats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seats, true), gettype($seats)), __LINE__);
        }
        if (is_null($seats) || (is_array($seats) && empty($seats))) {
            unset($this->Seats);
        } else {
            $this->Seats = $seats;
        }
        return $this;
    }
    /**
     * Get Sector value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSector()
    {
        return isset($this->Sector) ? $this->Sector : null;
    }
    /**
     * Set Sector value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sector
     * @return \patest\StructType\Ticketing_Winner
     */
    public function setSector($sector = null)
    {
        // validation for constraint: string
        if (!is_null($sector) && !is_string($sector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sector, true), gettype($sector)), __LINE__);
        }
        if (is_null($sector) || (is_array($sector) && empty($sector))) {
            unset($this->Sector);
        } else {
            $this->Sector = $sector;
        }
        return $this;
    }
    /**
     * Get WonSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getWonSeats()
    {
        return isset($this->WonSeats) ? $this->WonSeats : null;
    }
    /**
     * Set WonSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $wonSeats
     * @return \patest\StructType\Ticketing_Winner
     */
    public function setWonSeats($wonSeats = null)
    {
        // validation for constraint: int
        if (!is_null($wonSeats) && !(is_int($wonSeats) || ctype_digit($wonSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wonSeats, true), gettype($wonSeats)), __LINE__);
        }
        if (is_null($wonSeats) || (is_array($wonSeats) && empty($wonSeats))) {
            unset($this->WonSeats);
        } else {
            $this->WonSeats = $wonSeats;
        }
        return $this;
    }
}
