<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.ViewWinners StructType
 * @subpackage Structs
 */
class Ticketing_ViewWinners extends AnyEntity
{
    /**
     * The AllocatedSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AllocatedSeats;
    /**
     * The HolderCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderCompanyId;
    /**
     * The SectionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SectionId;
    /**
     * The Winners
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_Winner
     */
    public $Winners;
    /**
     * The WonSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $WonSeats;
    /**
     * Constructor method for Ticketing.ViewWinners
     * @uses Ticketing_ViewWinners::setAllocatedSeats()
     * @uses Ticketing_ViewWinners::setHolderCompanyId()
     * @uses Ticketing_ViewWinners::setSectionId()
     * @uses Ticketing_ViewWinners::setWinners()
     * @uses Ticketing_ViewWinners::setWonSeats()
     * @param int $allocatedSeats
     * @param int $holderCompanyId
     * @param string $sectionId
     * @param \patest\StructType\RecordSetOfTicketing_Winner $winners
     * @param int $wonSeats
     */
    public function __construct($allocatedSeats = null, $holderCompanyId = null, $sectionId = null, \patest\StructType\RecordSetOfTicketing_Winner $winners = null, $wonSeats = null)
    {
        $this
            ->setAllocatedSeats($allocatedSeats)
            ->setHolderCompanyId($holderCompanyId)
            ->setSectionId($sectionId)
            ->setWinners($winners)
            ->setWonSeats($wonSeats);
    }
    /**
     * Get AllocatedSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAllocatedSeats()
    {
        return isset($this->AllocatedSeats) ? $this->AllocatedSeats : null;
    }
    /**
     * Set AllocatedSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $allocatedSeats
     * @return \patest\StructType\Ticketing_ViewWinners
     */
    public function setAllocatedSeats($allocatedSeats = null)
    {
        // validation for constraint: int
        if (!is_null($allocatedSeats) && !(is_int($allocatedSeats) || ctype_digit($allocatedSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($allocatedSeats, true), gettype($allocatedSeats)), __LINE__);
        }
        if (is_null($allocatedSeats) || (is_array($allocatedSeats) && empty($allocatedSeats))) {
            unset($this->AllocatedSeats);
        } else {
            $this->AllocatedSeats = $allocatedSeats;
        }
        return $this;
    }
    /**
     * Get HolderCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderCompanyId()
    {
        return isset($this->HolderCompanyId) ? $this->HolderCompanyId : null;
    }
    /**
     * Set HolderCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderCompanyId
     * @return \patest\StructType\Ticketing_ViewWinners
     */
    public function setHolderCompanyId($holderCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($holderCompanyId) && !(is_int($holderCompanyId) || ctype_digit($holderCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderCompanyId, true), gettype($holderCompanyId)), __LINE__);
        }
        if (is_null($holderCompanyId) || (is_array($holderCompanyId) && empty($holderCompanyId))) {
            unset($this->HolderCompanyId);
        } else {
            $this->HolderCompanyId = $holderCompanyId;
        }
        return $this;
    }
    /**
     * Get SectionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectionId()
    {
        return isset($this->SectionId) ? $this->SectionId : null;
    }
    /**
     * Set SectionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectionId
     * @return \patest\StructType\Ticketing_ViewWinners
     */
    public function setSectionId($sectionId = null)
    {
        // validation for constraint: string
        if (!is_null($sectionId) && !is_string($sectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectionId, true), gettype($sectionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sectionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sectionId, true)), __LINE__);
        }
        if (is_null($sectionId) || (is_array($sectionId) && empty($sectionId))) {
            unset($this->SectionId);
        } else {
            $this->SectionId = $sectionId;
        }
        return $this;
    }
    /**
     * Get Winners value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_Winner|null
     */
    public function getWinners()
    {
        return isset($this->Winners) ? $this->Winners : null;
    }
    /**
     * Set Winners value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_Winner $winners
     * @return \patest\StructType\Ticketing_ViewWinners
     */
    public function setWinners(\patest\StructType\RecordSetOfTicketing_Winner $winners = null)
    {
        if (is_null($winners) || (is_array($winners) && empty($winners))) {
            unset($this->Winners);
        } else {
            $this->Winners = $winners;
        }
        return $this;
    }
    /**
     * Get WonSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getWonSeats()
    {
        return isset($this->WonSeats) ? $this->WonSeats : null;
    }
    /**
     * Set WonSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $wonSeats
     * @return \patest\StructType\Ticketing_ViewWinners
     */
    public function setWonSeats($wonSeats = null)
    {
        // validation for constraint: int
        if (!is_null($wonSeats) && !(is_int($wonSeats) || ctype_digit($wonSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wonSeats, true), gettype($wonSeats)), __LINE__);
        }
        if (is_null($wonSeats) || (is_array($wonSeats) && empty($wonSeats))) {
            unset($this->WonSeats);
        } else {
            $this->WonSeats = $wonSeats;
        }
        return $this;
    }
}
