<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.TicketViewTemplateAssociationCriteria StructType
 * @subpackage Structs
 */
class Ticketing_TicketViewTemplateAssociationCriteria extends PersistableEntity
{
    /**
     * The AttributeToCheck
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AttributeToCheck;
    /**
     * The HallVersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallVersionId;
    /**
     * The Invert
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Invert;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Operation;
    /**
     * The PassingValues
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PassingValues;
    /**
     * The TicketViewTemplateAssociationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketViewTemplateAssociationId;
    /**
     * Constructor method for Ticketing.TicketViewTemplateAssociationCriteria
     * @uses Ticketing_TicketViewTemplateAssociationCriteria::setAttributeToCheck()
     * @uses Ticketing_TicketViewTemplateAssociationCriteria::setHallVersionId()
     * @uses Ticketing_TicketViewTemplateAssociationCriteria::setInvert()
     * @uses Ticketing_TicketViewTemplateAssociationCriteria::setOperation()
     * @uses Ticketing_TicketViewTemplateAssociationCriteria::setPassingValues()
     * @uses Ticketing_TicketViewTemplateAssociationCriteria::setTicketViewTemplateAssociationId()
     * @param string $attributeToCheck
     * @param string $hallVersionId
     * @param bool $invert
     * @param string $operation
     * @param string $passingValues
     * @param string $ticketViewTemplateAssociationId
     */
    public function __construct($attributeToCheck = null, $hallVersionId = null, $invert = null, $operation = null, $passingValues = null, $ticketViewTemplateAssociationId = null)
    {
        $this
            ->setAttributeToCheck($attributeToCheck)
            ->setHallVersionId($hallVersionId)
            ->setInvert($invert)
            ->setOperation($operation)
            ->setPassingValues($passingValues)
            ->setTicketViewTemplateAssociationId($ticketViewTemplateAssociationId);
    }
    /**
     * Get AttributeToCheck value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttributeToCheck()
    {
        return isset($this->AttributeToCheck) ? $this->AttributeToCheck : null;
    }
    /**
     * Set AttributeToCheck value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketViewTemplateAssociationCriteriaAttribute::valueIsValid()
     * @uses \patest\EnumType\TicketViewTemplateAssociationCriteriaAttribute::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $attributeToCheck
     * @return \patest\StructType\Ticketing_TicketViewTemplateAssociationCriteria
     */
    public function setAttributeToCheck($attributeToCheck = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketViewTemplateAssociationCriteriaAttribute::valueIsValid($attributeToCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketViewTemplateAssociationCriteriaAttribute', is_array($attributeToCheck) ? implode(', ', $attributeToCheck) : var_export($attributeToCheck, true), implode(', ', \patest\EnumType\TicketViewTemplateAssociationCriteriaAttribute::getValidValues())), __LINE__);
        }
        if (is_null($attributeToCheck) || (is_array($attributeToCheck) && empty($attributeToCheck))) {
            unset($this->AttributeToCheck);
        } else {
            $this->AttributeToCheck = $attributeToCheck;
        }
        return $this;
    }
    /**
     * Get HallVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallVersionId()
    {
        return isset($this->HallVersionId) ? $this->HallVersionId : null;
    }
    /**
     * Set HallVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallVersionId
     * @return \patest\StructType\Ticketing_TicketViewTemplateAssociationCriteria
     */
    public function setHallVersionId($hallVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($hallVersionId) && !is_string($hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallVersionId, true), gettype($hallVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallVersionId, true)), __LINE__);
        }
        if (is_null($hallVersionId) || (is_array($hallVersionId) && empty($hallVersionId))) {
            unset($this->HallVersionId);
        } else {
            $this->HallVersionId = $hallVersionId;
        }
        return $this;
    }
    /**
     * Get Invert value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getInvert()
    {
        return isset($this->Invert) ? $this->Invert : null;
    }
    /**
     * Set Invert value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $invert
     * @return \patest\StructType\Ticketing_TicketViewTemplateAssociationCriteria
     */
    public function setInvert($invert = null)
    {
        // validation for constraint: boolean
        if (!is_null($invert) && !is_bool($invert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($invert, true), gettype($invert)), __LINE__);
        }
        if (is_null($invert) || (is_array($invert) && empty($invert))) {
            unset($this->Invert);
        } else {
            $this->Invert = $invert;
        }
        return $this;
    }
    /**
     * Get Operation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperation()
    {
        return isset($this->Operation) ? $this->Operation : null;
    }
    /**
     * Set Operation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketViewTemplateAssociationCriteriaOperation::valueIsValid()
     * @uses \patest\EnumType\TicketViewTemplateAssociationCriteriaOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \patest\StructType\Ticketing_TicketViewTemplateAssociationCriteria
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketViewTemplateAssociationCriteriaOperation::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketViewTemplateAssociationCriteriaOperation', is_array($operation) ? implode(', ', $operation) : var_export($operation, true), implode(', ', \patest\EnumType\TicketViewTemplateAssociationCriteriaOperation::getValidValues())), __LINE__);
        }
        if (is_null($operation) || (is_array($operation) && empty($operation))) {
            unset($this->Operation);
        } else {
            $this->Operation = $operation;
        }
        return $this;
    }
    /**
     * Get PassingValues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassingValues()
    {
        return isset($this->PassingValues) ? $this->PassingValues : null;
    }
    /**
     * Set PassingValues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $passingValues
     * @return \patest\StructType\Ticketing_TicketViewTemplateAssociationCriteria
     */
    public function setPassingValues($passingValues = null)
    {
        // validation for constraint: string
        if (!is_null($passingValues) && !is_string($passingValues)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passingValues, true), gettype($passingValues)), __LINE__);
        }
        if (is_null($passingValues) || (is_array($passingValues) && empty($passingValues))) {
            unset($this->PassingValues);
        } else {
            $this->PassingValues = $passingValues;
        }
        return $this;
    }
    /**
     * Get TicketViewTemplateAssociationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketViewTemplateAssociationId()
    {
        return isset($this->TicketViewTemplateAssociationId) ? $this->TicketViewTemplateAssociationId : null;
    }
    /**
     * Set TicketViewTemplateAssociationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketViewTemplateAssociationId
     * @return \patest\StructType\Ticketing_TicketViewTemplateAssociationCriteria
     */
    public function setTicketViewTemplateAssociationId($ticketViewTemplateAssociationId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketViewTemplateAssociationId) && !is_string($ticketViewTemplateAssociationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketViewTemplateAssociationId, true), gettype($ticketViewTemplateAssociationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketViewTemplateAssociationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketViewTemplateAssociationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketViewTemplateAssociationId, true)), __LINE__);
        }
        if (is_null($ticketViewTemplateAssociationId) || (is_array($ticketViewTemplateAssociationId) && empty($ticketViewTemplateAssociationId))) {
            unset($this->TicketViewTemplateAssociationId);
        } else {
            $this->TicketViewTemplateAssociationId = $ticketViewTemplateAssociationId;
        }
        return $this;
    }
}
