<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.TicketTransaction StructType
 * @subpackage Structs
 */
class Ticketing_TicketTransaction extends PersistableEntity
{
    /**
     * The ApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannel;
    /**
     * The CommitDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommitDateTime;
    /**
     * The TicketGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketGuid;
    /**
     * The TicketVersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketVersionId;
    /**
     * The TicketWaitGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketWaitGuid;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The WaitMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WaitMode;
    /**
     * Constructor method for Ticketing.TicketTransaction
     * @uses Ticketing_TicketTransaction::setApplicationChannel()
     * @uses Ticketing_TicketTransaction::setCommitDateTime()
     * @uses Ticketing_TicketTransaction::setTicketGuid()
     * @uses Ticketing_TicketTransaction::setTicketVersionId()
     * @uses Ticketing_TicketTransaction::setTicketWaitGuid()
     * @uses Ticketing_TicketTransaction::setTransactionGuid()
     * @uses Ticketing_TicketTransaction::setWaitMode()
     * @param string $applicationChannel
     * @param string $commitDateTime
     * @param string $ticketGuid
     * @param string $ticketVersionId
     * @param string $ticketWaitGuid
     * @param string $transactionGuid
     * @param string $waitMode
     */
    public function __construct($applicationChannel = null, $commitDateTime = null, $ticketGuid = null, $ticketVersionId = null, $ticketWaitGuid = null, $transactionGuid = null, $waitMode = null)
    {
        $this
            ->setApplicationChannel($applicationChannel)
            ->setCommitDateTime($commitDateTime)
            ->setTicketGuid($ticketGuid)
            ->setTicketVersionId($ticketVersionId)
            ->setTicketWaitGuid($ticketWaitGuid)
            ->setTransactionGuid($transactionGuid)
            ->setWaitMode($waitMode);
    }
    /**
     * Get ApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannel()
    {
        return isset($this->ApplicationChannel) ? $this->ApplicationChannel : null;
    }
    /**
     * Set ApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannel
     * @return \patest\StructType\Ticketing_TicketTransaction
     */
    public function setApplicationChannel($applicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannel) && !is_string($applicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannel, true), gettype($applicationChannel)), __LINE__);
        }
        if (is_null($applicationChannel) || (is_array($applicationChannel) && empty($applicationChannel))) {
            unset($this->ApplicationChannel);
        } else {
            $this->ApplicationChannel = $applicationChannel;
        }
        return $this;
    }
    /**
     * Get CommitDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommitDateTime()
    {
        return isset($this->CommitDateTime) ? $this->CommitDateTime : null;
    }
    /**
     * Set CommitDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commitDateTime
     * @return \patest\StructType\Ticketing_TicketTransaction
     */
    public function setCommitDateTime($commitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($commitDateTime) && !is_string($commitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commitDateTime, true), gettype($commitDateTime)), __LINE__);
        }
        if (is_null($commitDateTime) || (is_array($commitDateTime) && empty($commitDateTime))) {
            unset($this->CommitDateTime);
        } else {
            $this->CommitDateTime = $commitDateTime;
        }
        return $this;
    }
    /**
     * Get TicketGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketGuid()
    {
        return isset($this->TicketGuid) ? $this->TicketGuid : null;
    }
    /**
     * Set TicketGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketGuid
     * @return \patest\StructType\Ticketing_TicketTransaction
     */
    public function setTicketGuid($ticketGuid = null)
    {
        // validation for constraint: string
        if (!is_null($ticketGuid) && !is_string($ticketGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketGuid, true), gettype($ticketGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketGuid, true)), __LINE__);
        }
        if (is_null($ticketGuid) || (is_array($ticketGuid) && empty($ticketGuid))) {
            unset($this->TicketGuid);
        } else {
            $this->TicketGuid = $ticketGuid;
        }
        return $this;
    }
    /**
     * Get TicketVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketVersionId()
    {
        return isset($this->TicketVersionId) ? $this->TicketVersionId : null;
    }
    /**
     * Set TicketVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketVersionId
     * @return \patest\StructType\Ticketing_TicketTransaction
     */
    public function setTicketVersionId($ticketVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketVersionId) && !is_string($ticketVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketVersionId, true), gettype($ticketVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketVersionId, true)), __LINE__);
        }
        if (is_null($ticketVersionId) || (is_array($ticketVersionId) && empty($ticketVersionId))) {
            unset($this->TicketVersionId);
        } else {
            $this->TicketVersionId = $ticketVersionId;
        }
        return $this;
    }
    /**
     * Get TicketWaitGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketWaitGuid()
    {
        return isset($this->TicketWaitGuid) ? $this->TicketWaitGuid : null;
    }
    /**
     * Set TicketWaitGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketWaitGuid
     * @return \patest\StructType\Ticketing_TicketTransaction
     */
    public function setTicketWaitGuid($ticketWaitGuid = null)
    {
        // validation for constraint: string
        if (!is_null($ticketWaitGuid) && !is_string($ticketWaitGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketWaitGuid, true), gettype($ticketWaitGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketWaitGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketWaitGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketWaitGuid, true)), __LINE__);
        }
        if (is_null($ticketWaitGuid) || (is_array($ticketWaitGuid) && empty($ticketWaitGuid))) {
            unset($this->TicketWaitGuid);
        } else {
            $this->TicketWaitGuid = $ticketWaitGuid;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\Ticketing_TicketTransaction
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get WaitMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWaitMode()
    {
        return isset($this->WaitMode) ? $this->WaitMode : null;
    }
    /**
     * Set WaitMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketWaitMode::valueIsValid()
     * @uses \patest\EnumType\TicketWaitMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $waitMode
     * @return \patest\StructType\Ticketing_TicketTransaction
     */
    public function setWaitMode($waitMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketWaitMode::valueIsValid($waitMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketWaitMode', is_array($waitMode) ? implode(', ', $waitMode) : var_export($waitMode, true), implode(', ', \patest\EnumType\TicketWaitMode::getValidValues())), __LINE__);
        }
        if (is_null($waitMode) || (is_array($waitMode) && empty($waitMode))) {
            unset($this->WaitMode);
        } else {
            $this->WaitMode = $waitMode;
        }
        return $this;
    }
}
