<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.TicketOfEnrollment StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Ticketing.TicketOfEnrollment
 * @subpackage Structs
 */
class Ticketing_TicketOfEnrollment extends Ticketing_Ticket
{
    /**
     * The CommissionsAmount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CommissionsAmount;
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayName;
    /**
     * The EnrollmentId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EnrollmentId;
    /**
     * The EventTags
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_EventTag
     */
    public $EventTags;
    /**
     * The ExtendedData1
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData1;
    /**
     * The ExtendedData10
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData10;
    /**
     * The ExtendedData11
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData11;
    /**
     * The ExtendedData12
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData12;
    /**
     * The ExtendedData13
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData13;
    /**
     * The ExtendedData14
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData14;
    /**
     * The ExtendedData15
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData15;
    /**
     * The ExtendedData2
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData2;
    /**
     * The ExtendedData3
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData3;
    /**
     * The ExtendedData4
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData4;
    /**
     * The ExtendedData5
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData5;
    /**
     * The ExtendedData6
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData6;
    /**
     * The ExtendedData7
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData7;
    /**
     * The ExtendedData8
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData8;
    /**
     * The ExtendedData9
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedData9;
    /**
     * The IdInTransaction
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IdInTransaction;
    /**
     * The IsReserved
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReserved;
    /**
     * The PaymentStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentStatus;
    /**
     * The ShouldPayOnEnroll
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShouldPayOnEnroll;
    /**
     * The SubstitutedForItemId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_ExchangeAndUpdateItemRelation
     */
    public $SubstitutedForItemId;
    /**
     * The TagIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TagIds
     */
    public $TagIds;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalPrice;
    /**
     * Constructor method for Ticketing.TicketOfEnrollment
     * @uses Ticketing_TicketOfEnrollment::setCommissionsAmount()
     * @uses Ticketing_TicketOfEnrollment::setDisplayName()
     * @uses Ticketing_TicketOfEnrollment::setEnrollmentId()
     * @uses Ticketing_TicketOfEnrollment::setEventTags()
     * @uses Ticketing_TicketOfEnrollment::setExtendedData1()
     * @uses Ticketing_TicketOfEnrollment::setExtendedData10()
     * @uses Ticketing_TicketOfEnrollment::setExtendedData11()
     * @uses Ticketing_TicketOfEnrollment::setExtendedData12()
     * @uses Ticketing_TicketOfEnrollment::setExtendedData13()
     * @uses Ticketing_TicketOfEnrollment::setExtendedData14()
     * @uses Ticketing_TicketOfEnrollment::setExtendedData15()
     * @uses Ticketing_TicketOfEnrollment::setExtendedData2()
     * @uses Ticketing_TicketOfEnrollment::setExtendedData3()
     * @uses Ticketing_TicketOfEnrollment::setExtendedData4()
     * @uses Ticketing_TicketOfEnrollment::setExtendedData5()
     * @uses Ticketing_TicketOfEnrollment::setExtendedData6()
     * @uses Ticketing_TicketOfEnrollment::setExtendedData7()
     * @uses Ticketing_TicketOfEnrollment::setExtendedData8()
     * @uses Ticketing_TicketOfEnrollment::setExtendedData9()
     * @uses Ticketing_TicketOfEnrollment::setIdInTransaction()
     * @uses Ticketing_TicketOfEnrollment::setIsReserved()
     * @uses Ticketing_TicketOfEnrollment::setPaymentStatus()
     * @uses Ticketing_TicketOfEnrollment::setShouldPayOnEnroll()
     * @uses Ticketing_TicketOfEnrollment::setSubstitutedForItemId()
     * @uses Ticketing_TicketOfEnrollment::setTagIds()
     * @uses Ticketing_TicketOfEnrollment::setTotalPrice()
     * @param \patest\StructType\Money $commissionsAmount
     * @param string $displayName
     * @param string $enrollmentId
     * @param \patest\StructType\RecordSetOfTicketing_EventTag $eventTags
     * @param string $extendedData1
     * @param string $extendedData10
     * @param string $extendedData11
     * @param string $extendedData12
     * @param string $extendedData13
     * @param string $extendedData14
     * @param string $extendedData15
     * @param string $extendedData2
     * @param string $extendedData3
     * @param string $extendedData4
     * @param string $extendedData5
     * @param string $extendedData6
     * @param string $extendedData7
     * @param string $extendedData8
     * @param string $extendedData9
     * @param int $idInTransaction
     * @param bool $isReserved
     * @param string $paymentStatus
     * @param bool $shouldPayOnEnroll
     * @param \patest\StructType\Sales_ExchangeAndUpdateItemRelation $substitutedForItemId
     * @param \patest\StructType\TagIds $tagIds
     * @param \patest\StructType\Money $totalPrice
     */
    public function __construct(\patest\StructType\Money $commissionsAmount = null, $displayName = null, $enrollmentId = null, \patest\StructType\RecordSetOfTicketing_EventTag $eventTags = null, $extendedData1 = null, $extendedData10 = null, $extendedData11 = null, $extendedData12 = null, $extendedData13 = null, $extendedData14 = null, $extendedData15 = null, $extendedData2 = null, $extendedData3 = null, $extendedData4 = null, $extendedData5 = null, $extendedData6 = null, $extendedData7 = null, $extendedData8 = null, $extendedData9 = null, $idInTransaction = null, $isReserved = null, $paymentStatus = null, $shouldPayOnEnroll = null, \patest\StructType\Sales_ExchangeAndUpdateItemRelation $substitutedForItemId = null, \patest\StructType\TagIds $tagIds = null, \patest\StructType\Money $totalPrice = null)
    {
        $this
            ->setCommissionsAmount($commissionsAmount)
            ->setDisplayName($displayName)
            ->setEnrollmentId($enrollmentId)
            ->setEventTags($eventTags)
            ->setExtendedData1($extendedData1)
            ->setExtendedData10($extendedData10)
            ->setExtendedData11($extendedData11)
            ->setExtendedData12($extendedData12)
            ->setExtendedData13($extendedData13)
            ->setExtendedData14($extendedData14)
            ->setExtendedData15($extendedData15)
            ->setExtendedData2($extendedData2)
            ->setExtendedData3($extendedData3)
            ->setExtendedData4($extendedData4)
            ->setExtendedData5($extendedData5)
            ->setExtendedData6($extendedData6)
            ->setExtendedData7($extendedData7)
            ->setExtendedData8($extendedData8)
            ->setExtendedData9($extendedData9)
            ->setIdInTransaction($idInTransaction)
            ->setIsReserved($isReserved)
            ->setPaymentStatus($paymentStatus)
            ->setShouldPayOnEnroll($shouldPayOnEnroll)
            ->setSubstitutedForItemId($substitutedForItemId)
            ->setTagIds($tagIds)
            ->setTotalPrice($totalPrice);
    }
    /**
     * Get CommissionsAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCommissionsAmount()
    {
        return isset($this->CommissionsAmount) ? $this->CommissionsAmount : null;
    }
    /**
     * Set CommissionsAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $commissionsAmount
     * @return \patest\StructType\Ticketing_TicketOfEnrollment
     */
    public function setCommissionsAmount(\patest\StructType\Money $commissionsAmount = null)
    {
        if (is_null($commissionsAmount) || (is_array($commissionsAmount) && empty($commissionsAmount))) {
            unset($this->CommissionsAmount);
        } else {
            $this->CommissionsAmount = $commissionsAmount;
        }
        return $this;
    }
    /**
     * Get DisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayName()
    {
        return isset($this->DisplayName) ? $this->DisplayName : null;
    }
    /**
     * Set DisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayName
     * @return \patest\StructType\Ticketing_TicketOfEnrollment
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        if (is_null($displayName) || (is_array($displayName) && empty($displayName))) {
            unset($this->DisplayName);
        } else {
            $this->DisplayName = $displayName;
        }
        return $this;
    }
    /**
     * Get EnrollmentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnrollmentId()
    {
        return isset($this->EnrollmentId) ? $this->EnrollmentId : null;
    }
    /**
     * Set EnrollmentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $enrollmentId
     * @return \patest\StructType\Ticketing_TicketOfEnrollment
     */
    public function setEnrollmentId($enrollmentId = null)
    {
        // validation for constraint: string
        if (!is_null($enrollmentId) && !is_string($enrollmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enrollmentId, true), gettype($enrollmentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($enrollmentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $enrollmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($enrollmentId, true)), __LINE__);
        }
        if (is_null($enrollmentId) || (is_array($enrollmentId) && empty($enrollmentId))) {
            unset($this->EnrollmentId);
        } else {
            $this->EnrollmentId = $enrollmentId;
        }
        return $this;
    }
    /**
     * Get EventTags value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_EventTag|null
     */
    public function getEventTags()
    {
        return isset($this->EventTags) ? $this->EventTags : null;
    }
    /**
     * Set EventTags value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_EventTag $eventTags
     * @return \patest\StructType\Ticketing_TicketOfEnrollment
     */
    public function setEventTags(\patest\StructType\RecordSetOfTicketing_EventTag $eventTags = null)
    {
        if (is_null($eventTags) || (is_array($eventTags) && empty($eventTags))) {
            unset($this->EventTags);
        } else {
            $this->EventTags = $eventTags;
        }
        return $this;
    }
    /**
     * Get ExtendedData1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData1()
    {
        return isset($this->ExtendedData1) ? $this->ExtendedData1 : null;
    }
    /**
     * Set ExtendedData1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData1
     * @return \patest\StructType\Ticketing_TicketOfEnrollment
     */
    public function setExtendedData1($extendedData1 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData1) && !is_string($extendedData1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData1, true), gettype($extendedData1)), __LINE__);
        }
        if (is_null($extendedData1) || (is_array($extendedData1) && empty($extendedData1))) {
            unset($this->ExtendedData1);
        } else {
            $this->ExtendedData1 = $extendedData1;
        }
        return $this;
    }
    /**
     * Get ExtendedData10 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData10()
    {
        return isset($this->ExtendedData10) ? $this->ExtendedData10 : null;
    }
    /**
     * Set ExtendedData10 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData10
     * @return \patest\StructType\Ticketing_TicketOfEnrollment
     */
    public function setExtendedData10($extendedData10 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData10) && !is_string($extendedData10)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData10, true), gettype($extendedData10)), __LINE__);
        }
        if (is_null($extendedData10) || (is_array($extendedData10) && empty($extendedData10))) {
            unset($this->ExtendedData10);
        } else {
            $this->ExtendedData10 = $extendedData10;
        }
        return $this;
    }
    /**
     * Get ExtendedData11 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData11()
    {
        return isset($this->ExtendedData11) ? $this->ExtendedData11 : null;
    }
    /**
     * Set ExtendedData11 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData11
     * @return \patest\StructType\Ticketing_TicketOfEnrollment
     */
    public function setExtendedData11($extendedData11 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData11) && !is_string($extendedData11)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData11, true), gettype($extendedData11)), __LINE__);
        }
        if (is_null($extendedData11) || (is_array($extendedData11) && empty($extendedData11))) {
            unset($this->ExtendedData11);
        } else {
            $this->ExtendedData11 = $extendedData11;
        }
        return $this;
    }
    /**
     * Get ExtendedData12 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData12()
    {
        return isset($this->ExtendedData12) ? $this->ExtendedData12 : null;
    }
    /**
     * Set ExtendedData12 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData12
     * @return \patest\StructType\Ticketing_TicketOfEnrollment
     */
    public function setExtendedData12($extendedData12 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData12) && !is_string($extendedData12)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData12, true), gettype($extendedData12)), __LINE__);
        }
        if (is_null($extendedData12) || (is_array($extendedData12) && empty($extendedData12))) {
            unset($this->ExtendedData12);
        } else {
            $this->ExtendedData12 = $extendedData12;
        }
        return $this;
    }
    /**
     * Get ExtendedData13 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData13()
    {
        return isset($this->ExtendedData13) ? $this->ExtendedData13 : null;
    }
    /**
     * Set ExtendedData13 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData13
     * @return \patest\StructType\Ticketing_TicketOfEnrollment
     */
    public function setExtendedData13($extendedData13 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData13) && !is_string($extendedData13)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData13, true), gettype($extendedData13)), __LINE__);
        }
        if (is_null($extendedData13) || (is_array($extendedData13) && empty($extendedData13))) {
            unset($this->ExtendedData13);
        } else {
            $this->ExtendedData13 = $extendedData13;
        }
        return $this;
    }
    /**
     * Get ExtendedData14 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData14()
    {
        return isset($this->ExtendedData14) ? $this->ExtendedData14 : null;
    }
    /**
     * Set ExtendedData14 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData14
     * @return \patest\StructType\Ticketing_TicketOfEnrollment
     */
    public function setExtendedData14($extendedData14 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData14) && !is_string($extendedData14)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData14, true), gettype($extendedData14)), __LINE__);
        }
        if (is_null($extendedData14) || (is_array($extendedData14) && empty($extendedData14))) {
            unset($this->ExtendedData14);
        } else {
            $this->ExtendedData14 = $extendedData14;
        }
        return $this;
    }
    /**
     * Get ExtendedData15 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData15()
    {
        return isset($this->ExtendedData15) ? $this->ExtendedData15 : null;
    }
    /**
     * Set ExtendedData15 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData15
     * @return \patest\StructType\Ticketing_TicketOfEnrollment
     */
    public function setExtendedData15($extendedData15 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData15) && !is_string($extendedData15)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData15, true), gettype($extendedData15)), __LINE__);
        }
        if (is_null($extendedData15) || (is_array($extendedData15) && empty($extendedData15))) {
            unset($this->ExtendedData15);
        } else {
            $this->ExtendedData15 = $extendedData15;
        }
        return $this;
    }
    /**
     * Get ExtendedData2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData2()
    {
        return isset($this->ExtendedData2) ? $this->ExtendedData2 : null;
    }
    /**
     * Set ExtendedData2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData2
     * @return \patest\StructType\Ticketing_TicketOfEnrollment
     */
    public function setExtendedData2($extendedData2 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData2) && !is_string($extendedData2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData2, true), gettype($extendedData2)), __LINE__);
        }
        if (is_null($extendedData2) || (is_array($extendedData2) && empty($extendedData2))) {
            unset($this->ExtendedData2);
        } else {
            $this->ExtendedData2 = $extendedData2;
        }
        return $this;
    }
    /**
     * Get ExtendedData3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData3()
    {
        return isset($this->ExtendedData3) ? $this->ExtendedData3 : null;
    }
    /**
     * Set ExtendedData3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData3
     * @return \patest\StructType\Ticketing_TicketOfEnrollment
     */
    public function setExtendedData3($extendedData3 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData3) && !is_string($extendedData3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData3, true), gettype($extendedData3)), __LINE__);
        }
        if (is_null($extendedData3) || (is_array($extendedData3) && empty($extendedData3))) {
            unset($this->ExtendedData3);
        } else {
            $this->ExtendedData3 = $extendedData3;
        }
        return $this;
    }
    /**
     * Get ExtendedData4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData4()
    {
        return isset($this->ExtendedData4) ? $this->ExtendedData4 : null;
    }
    /**
     * Set ExtendedData4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData4
     * @return \patest\StructType\Ticketing_TicketOfEnrollment
     */
    public function setExtendedData4($extendedData4 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData4) && !is_string($extendedData4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData4, true), gettype($extendedData4)), __LINE__);
        }
        if (is_null($extendedData4) || (is_array($extendedData4) && empty($extendedData4))) {
            unset($this->ExtendedData4);
        } else {
            $this->ExtendedData4 = $extendedData4;
        }
        return $this;
    }
    /**
     * Get ExtendedData5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData5()
    {
        return isset($this->ExtendedData5) ? $this->ExtendedData5 : null;
    }
    /**
     * Set ExtendedData5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData5
     * @return \patest\StructType\Ticketing_TicketOfEnrollment
     */
    public function setExtendedData5($extendedData5 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData5) && !is_string($extendedData5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData5, true), gettype($extendedData5)), __LINE__);
        }
        if (is_null($extendedData5) || (is_array($extendedData5) && empty($extendedData5))) {
            unset($this->ExtendedData5);
        } else {
            $this->ExtendedData5 = $extendedData5;
        }
        return $this;
    }
    /**
     * Get ExtendedData6 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData6()
    {
        return isset($this->ExtendedData6) ? $this->ExtendedData6 : null;
    }
    /**
     * Set ExtendedData6 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData6
     * @return \patest\StructType\Ticketing_TicketOfEnrollment
     */
    public function setExtendedData6($extendedData6 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData6) && !is_string($extendedData6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData6, true), gettype($extendedData6)), __LINE__);
        }
        if (is_null($extendedData6) || (is_array($extendedData6) && empty($extendedData6))) {
            unset($this->ExtendedData6);
        } else {
            $this->ExtendedData6 = $extendedData6;
        }
        return $this;
    }
    /**
     * Get ExtendedData7 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData7()
    {
        return isset($this->ExtendedData7) ? $this->ExtendedData7 : null;
    }
    /**
     * Set ExtendedData7 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData7
     * @return \patest\StructType\Ticketing_TicketOfEnrollment
     */
    public function setExtendedData7($extendedData7 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData7) && !is_string($extendedData7)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData7, true), gettype($extendedData7)), __LINE__);
        }
        if (is_null($extendedData7) || (is_array($extendedData7) && empty($extendedData7))) {
            unset($this->ExtendedData7);
        } else {
            $this->ExtendedData7 = $extendedData7;
        }
        return $this;
    }
    /**
     * Get ExtendedData8 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData8()
    {
        return isset($this->ExtendedData8) ? $this->ExtendedData8 : null;
    }
    /**
     * Set ExtendedData8 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData8
     * @return \patest\StructType\Ticketing_TicketOfEnrollment
     */
    public function setExtendedData8($extendedData8 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData8) && !is_string($extendedData8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData8, true), gettype($extendedData8)), __LINE__);
        }
        if (is_null($extendedData8) || (is_array($extendedData8) && empty($extendedData8))) {
            unset($this->ExtendedData8);
        } else {
            $this->ExtendedData8 = $extendedData8;
        }
        return $this;
    }
    /**
     * Get ExtendedData9 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedData9()
    {
        return isset($this->ExtendedData9) ? $this->ExtendedData9 : null;
    }
    /**
     * Set ExtendedData9 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedData9
     * @return \patest\StructType\Ticketing_TicketOfEnrollment
     */
    public function setExtendedData9($extendedData9 = null)
    {
        // validation for constraint: string
        if (!is_null($extendedData9) && !is_string($extendedData9)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedData9, true), gettype($extendedData9)), __LINE__);
        }
        if (is_null($extendedData9) || (is_array($extendedData9) && empty($extendedData9))) {
            unset($this->ExtendedData9);
        } else {
            $this->ExtendedData9 = $extendedData9;
        }
        return $this;
    }
    /**
     * Get IdInTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdInTransaction()
    {
        return isset($this->IdInTransaction) ? $this->IdInTransaction : null;
    }
    /**
     * Set IdInTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idInTransaction
     * @return \patest\StructType\Ticketing_TicketOfEnrollment
     */
    public function setIdInTransaction($idInTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($idInTransaction) && !(is_int($idInTransaction) || ctype_digit($idInTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idInTransaction, true), gettype($idInTransaction)), __LINE__);
        }
        if (is_null($idInTransaction) || (is_array($idInTransaction) && empty($idInTransaction))) {
            unset($this->IdInTransaction);
        } else {
            $this->IdInTransaction = $idInTransaction;
        }
        return $this;
    }
    /**
     * Get IsReserved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReserved()
    {
        return isset($this->IsReserved) ? $this->IsReserved : null;
    }
    /**
     * Set IsReserved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReserved
     * @return \patest\StructType\Ticketing_TicketOfEnrollment
     */
    public function setIsReserved($isReserved = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReserved) && !is_bool($isReserved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReserved, true), gettype($isReserved)), __LINE__);
        }
        if (is_null($isReserved) || (is_array($isReserved) && empty($isReserved))) {
            unset($this->IsReserved);
        } else {
            $this->IsReserved = $isReserved;
        }
        return $this;
    }
    /**
     * Get PaymentStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentStatus()
    {
        return isset($this->PaymentStatus) ? $this->PaymentStatus : null;
    }
    /**
     * Set PaymentStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentPaidStatusType::valueIsValid()
     * @uses \patest\EnumType\PaymentPaidStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentStatus
     * @return \patest\StructType\Ticketing_TicketOfEnrollment
     */
    public function setPaymentStatus($paymentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentPaidStatusType::valueIsValid($paymentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentPaidStatusType', is_array($paymentStatus) ? implode(', ', $paymentStatus) : var_export($paymentStatus, true), implode(', ', \patest\EnumType\PaymentPaidStatusType::getValidValues())), __LINE__);
        }
        if (is_null($paymentStatus) || (is_array($paymentStatus) && empty($paymentStatus))) {
            unset($this->PaymentStatus);
        } else {
            $this->PaymentStatus = $paymentStatus;
        }
        return $this;
    }
    /**
     * Get ShouldPayOnEnroll value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShouldPayOnEnroll()
    {
        return isset($this->ShouldPayOnEnroll) ? $this->ShouldPayOnEnroll : null;
    }
    /**
     * Set ShouldPayOnEnroll value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $shouldPayOnEnroll
     * @return \patest\StructType\Ticketing_TicketOfEnrollment
     */
    public function setShouldPayOnEnroll($shouldPayOnEnroll = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldPayOnEnroll) && !is_bool($shouldPayOnEnroll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldPayOnEnroll, true), gettype($shouldPayOnEnroll)), __LINE__);
        }
        if (is_null($shouldPayOnEnroll) || (is_array($shouldPayOnEnroll) && empty($shouldPayOnEnroll))) {
            unset($this->ShouldPayOnEnroll);
        } else {
            $this->ShouldPayOnEnroll = $shouldPayOnEnroll;
        }
        return $this;
    }
    /**
     * Get SubstitutedForItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_ExchangeAndUpdateItemRelation|null
     */
    public function getSubstitutedForItemId()
    {
        return isset($this->SubstitutedForItemId) ? $this->SubstitutedForItemId : null;
    }
    /**
     * Set SubstitutedForItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_ExchangeAndUpdateItemRelation $substitutedForItemId
     * @return \patest\StructType\Ticketing_TicketOfEnrollment
     */
    public function setSubstitutedForItemId(\patest\StructType\Sales_ExchangeAndUpdateItemRelation $substitutedForItemId = null)
    {
        if (is_null($substitutedForItemId) || (is_array($substitutedForItemId) && empty($substitutedForItemId))) {
            unset($this->SubstitutedForItemId);
        } else {
            $this->SubstitutedForItemId = $substitutedForItemId;
        }
        return $this;
    }
    /**
     * Get TagIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TagIds|null
     */
    public function getTagIds()
    {
        return isset($this->TagIds) ? $this->TagIds : null;
    }
    /**
     * Set TagIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TagIds $tagIds
     * @return \patest\StructType\Ticketing_TicketOfEnrollment
     */
    public function setTagIds(\patest\StructType\TagIds $tagIds = null)
    {
        if (is_null($tagIds) || (is_array($tagIds) && empty($tagIds))) {
            unset($this->TagIds);
        } else {
            $this->TagIds = $tagIds;
        }
        return $this;
    }
    /**
     * Get TotalPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalPrice()
    {
        return isset($this->TotalPrice) ? $this->TotalPrice : null;
    }
    /**
     * Set TotalPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalPrice
     * @return \patest\StructType\Ticketing_TicketOfEnrollment
     */
    public function setTotalPrice(\patest\StructType\Money $totalPrice = null)
    {
        if (is_null($totalPrice) || (is_array($totalPrice) && empty($totalPrice))) {
            unset($this->TotalPrice);
        } else {
            $this->TotalPrice = $totalPrice;
        }
        return $this;
    }
}
