<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.TicketItem StructType
 * @subpackage Structs
 */
class Ticketing_TicketItem extends Ticketing_Ticket
{
    /**
     * The AreaLocalId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AreaLocalId;
    /**
     * The CompensationOfTicketId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CompensationOfTicketId;
    /**
     * The EventLocalId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EventLocalId;
    /**
     * The HallLocalId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HallLocalId;
    /**
     * The PriceLevelLocalId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PriceLevelLocalId;
    /**
     * The ShowLocalId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ShowLocalId;
    /**
     * The ShowTypeLocalId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ShowTypeLocalId;
    /**
     * The StandId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $StandId;
    /**
     * Constructor method for Ticketing.TicketItem
     * @uses Ticketing_TicketItem::setAreaLocalId()
     * @uses Ticketing_TicketItem::setCompensationOfTicketId()
     * @uses Ticketing_TicketItem::setEventLocalId()
     * @uses Ticketing_TicketItem::setHallLocalId()
     * @uses Ticketing_TicketItem::setPriceLevelLocalId()
     * @uses Ticketing_TicketItem::setShowLocalId()
     * @uses Ticketing_TicketItem::setShowTypeLocalId()
     * @uses Ticketing_TicketItem::setStandId()
     * @param int $areaLocalId
     * @param string $compensationOfTicketId
     * @param int $eventLocalId
     * @param int $hallLocalId
     * @param int $priceLevelLocalId
     * @param int $showLocalId
     * @param int $showTypeLocalId
     * @param string $standId
     */
    public function __construct($areaLocalId = null, $compensationOfTicketId = null, $eventLocalId = null, $hallLocalId = null, $priceLevelLocalId = null, $showLocalId = null, $showTypeLocalId = null, $standId = null)
    {
        $this
            ->setAreaLocalId($areaLocalId)
            ->setCompensationOfTicketId($compensationOfTicketId)
            ->setEventLocalId($eventLocalId)
            ->setHallLocalId($hallLocalId)
            ->setPriceLevelLocalId($priceLevelLocalId)
            ->setShowLocalId($showLocalId)
            ->setShowTypeLocalId($showTypeLocalId)
            ->setStandId($standId);
    }
    /**
     * Get AreaLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAreaLocalId()
    {
        return isset($this->AreaLocalId) ? $this->AreaLocalId : null;
    }
    /**
     * Set AreaLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $areaLocalId
     * @return \patest\StructType\Ticketing_TicketItem
     */
    public function setAreaLocalId($areaLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($areaLocalId) && !(is_int($areaLocalId) || ctype_digit($areaLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($areaLocalId, true), gettype($areaLocalId)), __LINE__);
        }
        if (is_null($areaLocalId) || (is_array($areaLocalId) && empty($areaLocalId))) {
            unset($this->AreaLocalId);
        } else {
            $this->AreaLocalId = $areaLocalId;
        }
        return $this;
    }
    /**
     * Get CompensationOfTicketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompensationOfTicketId()
    {
        return isset($this->CompensationOfTicketId) ? $this->CompensationOfTicketId : null;
    }
    /**
     * Set CompensationOfTicketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $compensationOfTicketId
     * @return \patest\StructType\Ticketing_TicketItem
     */
    public function setCompensationOfTicketId($compensationOfTicketId = null)
    {
        // validation for constraint: string
        if (!is_null($compensationOfTicketId) && !is_string($compensationOfTicketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($compensationOfTicketId, true), gettype($compensationOfTicketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($compensationOfTicketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $compensationOfTicketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($compensationOfTicketId, true)), __LINE__);
        }
        if (is_null($compensationOfTicketId) || (is_array($compensationOfTicketId) && empty($compensationOfTicketId))) {
            unset($this->CompensationOfTicketId);
        } else {
            $this->CompensationOfTicketId = $compensationOfTicketId;
        }
        return $this;
    }
    /**
     * Get EventLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEventLocalId()
    {
        return isset($this->EventLocalId) ? $this->EventLocalId : null;
    }
    /**
     * Set EventLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eventLocalId
     * @return \patest\StructType\Ticketing_TicketItem
     */
    public function setEventLocalId($eventLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($eventLocalId) && !(is_int($eventLocalId) || ctype_digit($eventLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eventLocalId, true), gettype($eventLocalId)), __LINE__);
        }
        if (is_null($eventLocalId) || (is_array($eventLocalId) && empty($eventLocalId))) {
            unset($this->EventLocalId);
        } else {
            $this->EventLocalId = $eventLocalId;
        }
        return $this;
    }
    /**
     * Get HallLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHallLocalId()
    {
        return isset($this->HallLocalId) ? $this->HallLocalId : null;
    }
    /**
     * Set HallLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $hallLocalId
     * @return \patest\StructType\Ticketing_TicketItem
     */
    public function setHallLocalId($hallLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($hallLocalId) && !(is_int($hallLocalId) || ctype_digit($hallLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hallLocalId, true), gettype($hallLocalId)), __LINE__);
        }
        if (is_null($hallLocalId) || (is_array($hallLocalId) && empty($hallLocalId))) {
            unset($this->HallLocalId);
        } else {
            $this->HallLocalId = $hallLocalId;
        }
        return $this;
    }
    /**
     * Get PriceLevelLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriceLevelLocalId()
    {
        return isset($this->PriceLevelLocalId) ? $this->PriceLevelLocalId : null;
    }
    /**
     * Set PriceLevelLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priceLevelLocalId
     * @return \patest\StructType\Ticketing_TicketItem
     */
    public function setPriceLevelLocalId($priceLevelLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($priceLevelLocalId) && !(is_int($priceLevelLocalId) || ctype_digit($priceLevelLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priceLevelLocalId, true), gettype($priceLevelLocalId)), __LINE__);
        }
        if (is_null($priceLevelLocalId) || (is_array($priceLevelLocalId) && empty($priceLevelLocalId))) {
            unset($this->PriceLevelLocalId);
        } else {
            $this->PriceLevelLocalId = $priceLevelLocalId;
        }
        return $this;
    }
    /**
     * Get ShowLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getShowLocalId()
    {
        return isset($this->ShowLocalId) ? $this->ShowLocalId : null;
    }
    /**
     * Set ShowLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $showLocalId
     * @return \patest\StructType\Ticketing_TicketItem
     */
    public function setShowLocalId($showLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($showLocalId) && !(is_int($showLocalId) || ctype_digit($showLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($showLocalId, true), gettype($showLocalId)), __LINE__);
        }
        if (is_null($showLocalId) || (is_array($showLocalId) && empty($showLocalId))) {
            unset($this->ShowLocalId);
        } else {
            $this->ShowLocalId = $showLocalId;
        }
        return $this;
    }
    /**
     * Get ShowTypeLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getShowTypeLocalId()
    {
        return isset($this->ShowTypeLocalId) ? $this->ShowTypeLocalId : null;
    }
    /**
     * Set ShowTypeLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $showTypeLocalId
     * @return \patest\StructType\Ticketing_TicketItem
     */
    public function setShowTypeLocalId($showTypeLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($showTypeLocalId) && !(is_int($showTypeLocalId) || ctype_digit($showTypeLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($showTypeLocalId, true), gettype($showTypeLocalId)), __LINE__);
        }
        if (is_null($showTypeLocalId) || (is_array($showTypeLocalId) && empty($showTypeLocalId))) {
            unset($this->ShowTypeLocalId);
        } else {
            $this->ShowTypeLocalId = $showTypeLocalId;
        }
        return $this;
    }
    /**
     * Get StandId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStandId()
    {
        return isset($this->StandId) ? $this->StandId : null;
    }
    /**
     * Set StandId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $standId
     * @return \patest\StructType\Ticketing_TicketItem
     */
    public function setStandId($standId = null)
    {
        // validation for constraint: string
        if (!is_null($standId) && !is_string($standId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($standId, true), gettype($standId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($standId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $standId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($standId, true)), __LINE__);
        }
        if (is_null($standId) || (is_array($standId) && empty($standId))) {
            unset($this->StandId);
        } else {
            $this->StandId = $standId;
        }
        return $this;
    }
}
