<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.Ticket StructType
 * @subpackage Structs
 */
class Ticketing_Ticket extends Ticketing_TicketBase
{
    /**
     * The AccessCodeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessCodeId;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The PricingDetails
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PricingDetails;
    /**
     * The PricingVariationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PricingVariationId;
    /**
     * Constructor method for Ticketing.Ticket
     * @uses Ticketing_Ticket::setAccessCodeId()
     * @uses Ticketing_Ticket::setCreationDate()
     * @uses Ticketing_Ticket::setPricingDetails()
     * @uses Ticketing_Ticket::setPricingVariationId()
     * @param string $accessCodeId
     * @param string $creationDate
     * @param string $pricingDetails
     * @param int $pricingVariationId
     */
    public function __construct($accessCodeId = null, $creationDate = null, $pricingDetails = null, $pricingVariationId = null)
    {
        $this
            ->setAccessCodeId($accessCodeId)
            ->setCreationDate($creationDate)
            ->setPricingDetails($pricingDetails)
            ->setPricingVariationId($pricingVariationId);
    }
    /**
     * Get AccessCodeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessCodeId()
    {
        return isset($this->AccessCodeId) ? $this->AccessCodeId : null;
    }
    /**
     * Set AccessCodeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessCodeId
     * @return \patest\StructType\Ticketing_Ticket
     */
    public function setAccessCodeId($accessCodeId = null)
    {
        // validation for constraint: string
        if (!is_null($accessCodeId) && !is_string($accessCodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessCodeId, true), gettype($accessCodeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessCodeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessCodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessCodeId, true)), __LINE__);
        }
        if (is_null($accessCodeId) || (is_array($accessCodeId) && empty($accessCodeId))) {
            unset($this->AccessCodeId);
        } else {
            $this->AccessCodeId = $accessCodeId;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\Ticketing_Ticket
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get PricingDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPricingDetails()
    {
        return isset($this->PricingDetails) ? $this->PricingDetails : null;
    }
    /**
     * Set PricingDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pricingDetails
     * @return \patest\StructType\Ticketing_Ticket
     */
    public function setPricingDetails($pricingDetails = null)
    {
        // validation for constraint: string
        if (!is_null($pricingDetails) && !is_string($pricingDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pricingDetails, true), gettype($pricingDetails)), __LINE__);
        }
        if (is_null($pricingDetails) || (is_array($pricingDetails) && empty($pricingDetails))) {
            unset($this->PricingDetails);
        } else {
            $this->PricingDetails = $pricingDetails;
        }
        return $this;
    }
    /**
     * Get PricingVariationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPricingVariationId()
    {
        return isset($this->PricingVariationId) ? $this->PricingVariationId : null;
    }
    /**
     * Set PricingVariationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pricingVariationId
     * @return \patest\StructType\Ticketing_Ticket
     */
    public function setPricingVariationId($pricingVariationId = null)
    {
        // validation for constraint: int
        if (!is_null($pricingVariationId) && !(is_int($pricingVariationId) || ctype_digit($pricingVariationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pricingVariationId, true), gettype($pricingVariationId)), __LINE__);
        }
        if (is_null($pricingVariationId) || (is_array($pricingVariationId) && empty($pricingVariationId))) {
            unset($this->PricingVariationId);
        } else {
            $this->PricingVariationId = $pricingVariationId;
        }
        return $this;
    }
}
