<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SubscriptionAutoRenewFulfillmentBatch StructType
 * @subpackage Structs
 */
class Ticketing_SubscriptionAutoRenewFulfillmentBatch extends PersistableEntity
{
    /**
     * The EnrollmentsCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EnrollmentsCount;
    /**
     * The FailedOtherCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FailedOtherCount;
    /**
     * The FailedPaymentCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FailedPaymentCount;
    /**
     * The FailedSeatingCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FailedSeatingCount;
    /**
     * The FulfilledCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FulfilledCount;
    /**
     * The LastFulfillmentDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastFulfillmentDate;
    /**
     * The NewSeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewSeriesId;
    /**
     * The PendingCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PendingCount;
    /**
     * The ProcessedByUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProcessedByUserId;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The WorkItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $WorkItemId;
    /**
     * Constructor method for Ticketing.SubscriptionAutoRenewFulfillmentBatch
     * @uses Ticketing_SubscriptionAutoRenewFulfillmentBatch::setEnrollmentsCount()
     * @uses Ticketing_SubscriptionAutoRenewFulfillmentBatch::setFailedOtherCount()
     * @uses Ticketing_SubscriptionAutoRenewFulfillmentBatch::setFailedPaymentCount()
     * @uses Ticketing_SubscriptionAutoRenewFulfillmentBatch::setFailedSeatingCount()
     * @uses Ticketing_SubscriptionAutoRenewFulfillmentBatch::setFulfilledCount()
     * @uses Ticketing_SubscriptionAutoRenewFulfillmentBatch::setLastFulfillmentDate()
     * @uses Ticketing_SubscriptionAutoRenewFulfillmentBatch::setNewSeriesId()
     * @uses Ticketing_SubscriptionAutoRenewFulfillmentBatch::setPendingCount()
     * @uses Ticketing_SubscriptionAutoRenewFulfillmentBatch::setProcessedByUserId()
     * @uses Ticketing_SubscriptionAutoRenewFulfillmentBatch::setSeriesId()
     * @uses Ticketing_SubscriptionAutoRenewFulfillmentBatch::setState()
     * @uses Ticketing_SubscriptionAutoRenewFulfillmentBatch::setWorkItemId()
     * @param int $enrollmentsCount
     * @param int $failedOtherCount
     * @param int $failedPaymentCount
     * @param int $failedSeatingCount
     * @param int $fulfilledCount
     * @param string $lastFulfillmentDate
     * @param string $newSeriesId
     * @param int $pendingCount
     * @param string $processedByUserId
     * @param string $seriesId
     * @param string $state
     * @param string $workItemId
     */
    public function __construct($enrollmentsCount = null, $failedOtherCount = null, $failedPaymentCount = null, $failedSeatingCount = null, $fulfilledCount = null, $lastFulfillmentDate = null, $newSeriesId = null, $pendingCount = null, $processedByUserId = null, $seriesId = null, $state = null, $workItemId = null)
    {
        $this
            ->setEnrollmentsCount($enrollmentsCount)
            ->setFailedOtherCount($failedOtherCount)
            ->setFailedPaymentCount($failedPaymentCount)
            ->setFailedSeatingCount($failedSeatingCount)
            ->setFulfilledCount($fulfilledCount)
            ->setLastFulfillmentDate($lastFulfillmentDate)
            ->setNewSeriesId($newSeriesId)
            ->setPendingCount($pendingCount)
            ->setProcessedByUserId($processedByUserId)
            ->setSeriesId($seriesId)
            ->setState($state)
            ->setWorkItemId($workItemId);
    }
    /**
     * Get EnrollmentsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEnrollmentsCount()
    {
        return isset($this->EnrollmentsCount) ? $this->EnrollmentsCount : null;
    }
    /**
     * Set EnrollmentsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $enrollmentsCount
     * @return \patest\StructType\Ticketing_SubscriptionAutoRenewFulfillmentBatch
     */
    public function setEnrollmentsCount($enrollmentsCount = null)
    {
        // validation for constraint: int
        if (!is_null($enrollmentsCount) && !(is_int($enrollmentsCount) || ctype_digit($enrollmentsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($enrollmentsCount, true), gettype($enrollmentsCount)), __LINE__);
        }
        if (is_null($enrollmentsCount) || (is_array($enrollmentsCount) && empty($enrollmentsCount))) {
            unset($this->EnrollmentsCount);
        } else {
            $this->EnrollmentsCount = $enrollmentsCount;
        }
        return $this;
    }
    /**
     * Get FailedOtherCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFailedOtherCount()
    {
        return isset($this->FailedOtherCount) ? $this->FailedOtherCount : null;
    }
    /**
     * Set FailedOtherCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $failedOtherCount
     * @return \patest\StructType\Ticketing_SubscriptionAutoRenewFulfillmentBatch
     */
    public function setFailedOtherCount($failedOtherCount = null)
    {
        // validation for constraint: int
        if (!is_null($failedOtherCount) && !(is_int($failedOtherCount) || ctype_digit($failedOtherCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($failedOtherCount, true), gettype($failedOtherCount)), __LINE__);
        }
        if (is_null($failedOtherCount) || (is_array($failedOtherCount) && empty($failedOtherCount))) {
            unset($this->FailedOtherCount);
        } else {
            $this->FailedOtherCount = $failedOtherCount;
        }
        return $this;
    }
    /**
     * Get FailedPaymentCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFailedPaymentCount()
    {
        return isset($this->FailedPaymentCount) ? $this->FailedPaymentCount : null;
    }
    /**
     * Set FailedPaymentCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $failedPaymentCount
     * @return \patest\StructType\Ticketing_SubscriptionAutoRenewFulfillmentBatch
     */
    public function setFailedPaymentCount($failedPaymentCount = null)
    {
        // validation for constraint: int
        if (!is_null($failedPaymentCount) && !(is_int($failedPaymentCount) || ctype_digit($failedPaymentCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($failedPaymentCount, true), gettype($failedPaymentCount)), __LINE__);
        }
        if (is_null($failedPaymentCount) || (is_array($failedPaymentCount) && empty($failedPaymentCount))) {
            unset($this->FailedPaymentCount);
        } else {
            $this->FailedPaymentCount = $failedPaymentCount;
        }
        return $this;
    }
    /**
     * Get FailedSeatingCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFailedSeatingCount()
    {
        return isset($this->FailedSeatingCount) ? $this->FailedSeatingCount : null;
    }
    /**
     * Set FailedSeatingCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $failedSeatingCount
     * @return \patest\StructType\Ticketing_SubscriptionAutoRenewFulfillmentBatch
     */
    public function setFailedSeatingCount($failedSeatingCount = null)
    {
        // validation for constraint: int
        if (!is_null($failedSeatingCount) && !(is_int($failedSeatingCount) || ctype_digit($failedSeatingCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($failedSeatingCount, true), gettype($failedSeatingCount)), __LINE__);
        }
        if (is_null($failedSeatingCount) || (is_array($failedSeatingCount) && empty($failedSeatingCount))) {
            unset($this->FailedSeatingCount);
        } else {
            $this->FailedSeatingCount = $failedSeatingCount;
        }
        return $this;
    }
    /**
     * Get FulfilledCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFulfilledCount()
    {
        return isset($this->FulfilledCount) ? $this->FulfilledCount : null;
    }
    /**
     * Set FulfilledCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fulfilledCount
     * @return \patest\StructType\Ticketing_SubscriptionAutoRenewFulfillmentBatch
     */
    public function setFulfilledCount($fulfilledCount = null)
    {
        // validation for constraint: int
        if (!is_null($fulfilledCount) && !(is_int($fulfilledCount) || ctype_digit($fulfilledCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fulfilledCount, true), gettype($fulfilledCount)), __LINE__);
        }
        if (is_null($fulfilledCount) || (is_array($fulfilledCount) && empty($fulfilledCount))) {
            unset($this->FulfilledCount);
        } else {
            $this->FulfilledCount = $fulfilledCount;
        }
        return $this;
    }
    /**
     * Get LastFulfillmentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastFulfillmentDate()
    {
        return isset($this->LastFulfillmentDate) ? $this->LastFulfillmentDate : null;
    }
    /**
     * Set LastFulfillmentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastFulfillmentDate
     * @return \patest\StructType\Ticketing_SubscriptionAutoRenewFulfillmentBatch
     */
    public function setLastFulfillmentDate($lastFulfillmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastFulfillmentDate) && !is_string($lastFulfillmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastFulfillmentDate, true), gettype($lastFulfillmentDate)), __LINE__);
        }
        if (is_null($lastFulfillmentDate) || (is_array($lastFulfillmentDate) && empty($lastFulfillmentDate))) {
            unset($this->LastFulfillmentDate);
        } else {
            $this->LastFulfillmentDate = $lastFulfillmentDate;
        }
        return $this;
    }
    /**
     * Get NewSeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewSeriesId()
    {
        return isset($this->NewSeriesId) ? $this->NewSeriesId : null;
    }
    /**
     * Set NewSeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newSeriesId
     * @return \patest\StructType\Ticketing_SubscriptionAutoRenewFulfillmentBatch
     */
    public function setNewSeriesId($newSeriesId = null)
    {
        // validation for constraint: string
        if (!is_null($newSeriesId) && !is_string($newSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newSeriesId, true), gettype($newSeriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newSeriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newSeriesId, true)), __LINE__);
        }
        if (is_null($newSeriesId) || (is_array($newSeriesId) && empty($newSeriesId))) {
            unset($this->NewSeriesId);
        } else {
            $this->NewSeriesId = $newSeriesId;
        }
        return $this;
    }
    /**
     * Get PendingCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPendingCount()
    {
        return isset($this->PendingCount) ? $this->PendingCount : null;
    }
    /**
     * Set PendingCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pendingCount
     * @return \patest\StructType\Ticketing_SubscriptionAutoRenewFulfillmentBatch
     */
    public function setPendingCount($pendingCount = null)
    {
        // validation for constraint: int
        if (!is_null($pendingCount) && !(is_int($pendingCount) || ctype_digit($pendingCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pendingCount, true), gettype($pendingCount)), __LINE__);
        }
        if (is_null($pendingCount) || (is_array($pendingCount) && empty($pendingCount))) {
            unset($this->PendingCount);
        } else {
            $this->PendingCount = $pendingCount;
        }
        return $this;
    }
    /**
     * Get ProcessedByUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessedByUserId()
    {
        return isset($this->ProcessedByUserId) ? $this->ProcessedByUserId : null;
    }
    /**
     * Set ProcessedByUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processedByUserId
     * @return \patest\StructType\Ticketing_SubscriptionAutoRenewFulfillmentBatch
     */
    public function setProcessedByUserId($processedByUserId = null)
    {
        // validation for constraint: string
        if (!is_null($processedByUserId) && !is_string($processedByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processedByUserId, true), gettype($processedByUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($processedByUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $processedByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($processedByUserId, true)), __LINE__);
        }
        if (is_null($processedByUserId) || (is_array($processedByUserId) && empty($processedByUserId))) {
            unset($this->ProcessedByUserId);
        } else {
            $this->ProcessedByUserId = $processedByUserId;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\Ticketing_SubscriptionAutoRenewFulfillmentBatch
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\FulfillmentState::valueIsValid()
     * @uses \patest\EnumType\FulfillmentState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \patest\StructType\Ticketing_SubscriptionAutoRenewFulfillmentBatch
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\FulfillmentState::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\FulfillmentState', is_array($state) ? implode(', ', $state) : var_export($state, true), implode(', ', \patest\EnumType\FulfillmentState::getValidValues())), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get WorkItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWorkItemId()
    {
        return isset($this->WorkItemId) ? $this->WorkItemId : null;
    }
    /**
     * Set WorkItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $workItemId
     * @return \patest\StructType\Ticketing_SubscriptionAutoRenewFulfillmentBatch
     */
    public function setWorkItemId($workItemId = null)
    {
        // validation for constraint: string
        if (!is_null($workItemId) && !is_string($workItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workItemId, true), gettype($workItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($workItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $workItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($workItemId, true)), __LINE__);
        }
        if (is_null($workItemId) || (is_array($workItemId) && empty($workItemId))) {
            unset($this->WorkItemId);
        } else {
            $this->WorkItemId = $workItemId;
        }
        return $this;
    }
}
