<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SeriesWithSalesMonitoringInfo StructType
 * @subpackage Structs
 */
class Ticketing_SeriesWithSalesMonitoringInfo extends Ticketing_Series
{
    /**
     * The AppServerNodeName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AppServerNodeName;
    /**
     * The CapacityCounters
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_SeatingPlanCapacityCounters
     */
    public $CapacityCounters;
    /**
     * The HallVersionName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $HallVersionName;
    /**
     * The ManagerLoadedAt
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ManagerLoadedAt;
    /**
     * The ManagerStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ManagerStatus;
    /**
     * The PrevSeasonSubscriberCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrevSeasonSubscriberCount;
    /**
     * The ScannedTicketCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ScannedTicketCount;
    /**
     * The SessionCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SessionCount;
    /**
     * The SubsriberCountWhichAreRenew
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SubsriberCountWhichAreRenew;
    /**
     * Constructor method for Ticketing.SeriesWithSalesMonitoringInfo
     * @uses Ticketing_SeriesWithSalesMonitoringInfo::setAppServerNodeName()
     * @uses Ticketing_SeriesWithSalesMonitoringInfo::setCapacityCounters()
     * @uses Ticketing_SeriesWithSalesMonitoringInfo::setHallVersionName()
     * @uses Ticketing_SeriesWithSalesMonitoringInfo::setManagerLoadedAt()
     * @uses Ticketing_SeriesWithSalesMonitoringInfo::setManagerStatus()
     * @uses Ticketing_SeriesWithSalesMonitoringInfo::setPrevSeasonSubscriberCount()
     * @uses Ticketing_SeriesWithSalesMonitoringInfo::setScannedTicketCount()
     * @uses Ticketing_SeriesWithSalesMonitoringInfo::setSessionCount()
     * @uses Ticketing_SeriesWithSalesMonitoringInfo::setSubsriberCountWhichAreRenew()
     * @param string $appServerNodeName
     * @param \patest\StructType\Ticketing_SeatingPlanCapacityCounters $capacityCounters
     * @param \patest\StructType\GlobalString $hallVersionName
     * @param string $managerLoadedAt
     * @param string $managerStatus
     * @param int $prevSeasonSubscriberCount
     * @param int $scannedTicketCount
     * @param int $sessionCount
     * @param int $subsriberCountWhichAreRenew
     */
    public function __construct($appServerNodeName = null, \patest\StructType\Ticketing_SeatingPlanCapacityCounters $capacityCounters = null, \patest\StructType\GlobalString $hallVersionName = null, $managerLoadedAt = null, $managerStatus = null, $prevSeasonSubscriberCount = null, $scannedTicketCount = null, $sessionCount = null, $subsriberCountWhichAreRenew = null)
    {
        $this
            ->setAppServerNodeName($appServerNodeName)
            ->setCapacityCounters($capacityCounters)
            ->setHallVersionName($hallVersionName)
            ->setManagerLoadedAt($managerLoadedAt)
            ->setManagerStatus($managerStatus)
            ->setPrevSeasonSubscriberCount($prevSeasonSubscriberCount)
            ->setScannedTicketCount($scannedTicketCount)
            ->setSessionCount($sessionCount)
            ->setSubsriberCountWhichAreRenew($subsriberCountWhichAreRenew);
    }
    /**
     * Get AppServerNodeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppServerNodeName()
    {
        return isset($this->AppServerNodeName) ? $this->AppServerNodeName : null;
    }
    /**
     * Set AppServerNodeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appServerNodeName
     * @return \patest\StructType\Ticketing_SeriesWithSalesMonitoringInfo
     */
    public function setAppServerNodeName($appServerNodeName = null)
    {
        // validation for constraint: string
        if (!is_null($appServerNodeName) && !is_string($appServerNodeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appServerNodeName, true), gettype($appServerNodeName)), __LINE__);
        }
        if (is_null($appServerNodeName) || (is_array($appServerNodeName) && empty($appServerNodeName))) {
            unset($this->AppServerNodeName);
        } else {
            $this->AppServerNodeName = $appServerNodeName;
        }
        return $this;
    }
    /**
     * Get CapacityCounters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_SeatingPlanCapacityCounters|null
     */
    public function getCapacityCounters()
    {
        return isset($this->CapacityCounters) ? $this->CapacityCounters : null;
    }
    /**
     * Set CapacityCounters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_SeatingPlanCapacityCounters $capacityCounters
     * @return \patest\StructType\Ticketing_SeriesWithSalesMonitoringInfo
     */
    public function setCapacityCounters(\patest\StructType\Ticketing_SeatingPlanCapacityCounters $capacityCounters = null)
    {
        if (is_null($capacityCounters) || (is_array($capacityCounters) && empty($capacityCounters))) {
            unset($this->CapacityCounters);
        } else {
            $this->CapacityCounters = $capacityCounters;
        }
        return $this;
    }
    /**
     * Get HallVersionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getHallVersionName()
    {
        return isset($this->HallVersionName) ? $this->HallVersionName : null;
    }
    /**
     * Set HallVersionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $hallVersionName
     * @return \patest\StructType\Ticketing_SeriesWithSalesMonitoringInfo
     */
    public function setHallVersionName(\patest\StructType\GlobalString $hallVersionName = null)
    {
        if (is_null($hallVersionName) || (is_array($hallVersionName) && empty($hallVersionName))) {
            unset($this->HallVersionName);
        } else {
            $this->HallVersionName = $hallVersionName;
        }
        return $this;
    }
    /**
     * Get ManagerLoadedAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getManagerLoadedAt()
    {
        return isset($this->ManagerLoadedAt) ? $this->ManagerLoadedAt : null;
    }
    /**
     * Set ManagerLoadedAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $managerLoadedAt
     * @return \patest\StructType\Ticketing_SeriesWithSalesMonitoringInfo
     */
    public function setManagerLoadedAt($managerLoadedAt = null)
    {
        // validation for constraint: string
        if (!is_null($managerLoadedAt) && !is_string($managerLoadedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($managerLoadedAt, true), gettype($managerLoadedAt)), __LINE__);
        }
        if (is_null($managerLoadedAt) || (is_array($managerLoadedAt) && empty($managerLoadedAt))) {
            unset($this->ManagerLoadedAt);
        } else {
            $this->ManagerLoadedAt = $managerLoadedAt;
        }
        return $this;
    }
    /**
     * Get ManagerStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getManagerStatus()
    {
        return isset($this->ManagerStatus) ? $this->ManagerStatus : null;
    }
    /**
     * Set ManagerStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeatingPlanManagerStatus::valueIsValid()
     * @uses \patest\EnumType\SeatingPlanManagerStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $managerStatus
     * @return \patest\StructType\Ticketing_SeriesWithSalesMonitoringInfo
     */
    public function setManagerStatus($managerStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeatingPlanManagerStatus::valueIsValid($managerStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeatingPlanManagerStatus', is_array($managerStatus) ? implode(', ', $managerStatus) : var_export($managerStatus, true), implode(', ', \patest\EnumType\SeatingPlanManagerStatus::getValidValues())), __LINE__);
        }
        if (is_null($managerStatus) || (is_array($managerStatus) && empty($managerStatus))) {
            unset($this->ManagerStatus);
        } else {
            $this->ManagerStatus = $managerStatus;
        }
        return $this;
    }
    /**
     * Get PrevSeasonSubscriberCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrevSeasonSubscriberCount()
    {
        return isset($this->PrevSeasonSubscriberCount) ? $this->PrevSeasonSubscriberCount : null;
    }
    /**
     * Set PrevSeasonSubscriberCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $prevSeasonSubscriberCount
     * @return \patest\StructType\Ticketing_SeriesWithSalesMonitoringInfo
     */
    public function setPrevSeasonSubscriberCount($prevSeasonSubscriberCount = null)
    {
        // validation for constraint: int
        if (!is_null($prevSeasonSubscriberCount) && !(is_int($prevSeasonSubscriberCount) || ctype_digit($prevSeasonSubscriberCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prevSeasonSubscriberCount, true), gettype($prevSeasonSubscriberCount)), __LINE__);
        }
        if (is_null($prevSeasonSubscriberCount) || (is_array($prevSeasonSubscriberCount) && empty($prevSeasonSubscriberCount))) {
            unset($this->PrevSeasonSubscriberCount);
        } else {
            $this->PrevSeasonSubscriberCount = $prevSeasonSubscriberCount;
        }
        return $this;
    }
    /**
     * Get ScannedTicketCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getScannedTicketCount()
    {
        return isset($this->ScannedTicketCount) ? $this->ScannedTicketCount : null;
    }
    /**
     * Set ScannedTicketCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $scannedTicketCount
     * @return \patest\StructType\Ticketing_SeriesWithSalesMonitoringInfo
     */
    public function setScannedTicketCount($scannedTicketCount = null)
    {
        // validation for constraint: int
        if (!is_null($scannedTicketCount) && !(is_int($scannedTicketCount) || ctype_digit($scannedTicketCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($scannedTicketCount, true), gettype($scannedTicketCount)), __LINE__);
        }
        if (is_null($scannedTicketCount) || (is_array($scannedTicketCount) && empty($scannedTicketCount))) {
            unset($this->ScannedTicketCount);
        } else {
            $this->ScannedTicketCount = $scannedTicketCount;
        }
        return $this;
    }
    /**
     * Get SessionCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSessionCount()
    {
        return isset($this->SessionCount) ? $this->SessionCount : null;
    }
    /**
     * Set SessionCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sessionCount
     * @return \patest\StructType\Ticketing_SeriesWithSalesMonitoringInfo
     */
    public function setSessionCount($sessionCount = null)
    {
        // validation for constraint: int
        if (!is_null($sessionCount) && !(is_int($sessionCount) || ctype_digit($sessionCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sessionCount, true), gettype($sessionCount)), __LINE__);
        }
        if (is_null($sessionCount) || (is_array($sessionCount) && empty($sessionCount))) {
            unset($this->SessionCount);
        } else {
            $this->SessionCount = $sessionCount;
        }
        return $this;
    }
    /**
     * Get SubsriberCountWhichAreRenew value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSubsriberCountWhichAreRenew()
    {
        return isset($this->SubsriberCountWhichAreRenew) ? $this->SubsriberCountWhichAreRenew : null;
    }
    /**
     * Set SubsriberCountWhichAreRenew value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $subsriberCountWhichAreRenew
     * @return \patest\StructType\Ticketing_SeriesWithSalesMonitoringInfo
     */
    public function setSubsriberCountWhichAreRenew($subsriberCountWhichAreRenew = null)
    {
        // validation for constraint: int
        if (!is_null($subsriberCountWhichAreRenew) && !(is_int($subsriberCountWhichAreRenew) || ctype_digit($subsriberCountWhichAreRenew))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($subsriberCountWhichAreRenew, true), gettype($subsriberCountWhichAreRenew)), __LINE__);
        }
        if (is_null($subsriberCountWhichAreRenew) || (is_array($subsriberCountWhichAreRenew) && empty($subsriberCountWhichAreRenew))) {
            unset($this->SubsriberCountWhichAreRenew);
        } else {
            $this->SubsriberCountWhichAreRenew = $subsriberCountWhichAreRenew;
        }
        return $this;
    }
}
