<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SeriesSeason StructType
 * @subpackage Structs
 */
class Ticketing_SeriesSeason extends Ticketing_Base
{
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The HoldSeatsForRenewStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HoldSeatsForRenewStatus;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The PreviousSeason
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PreviousSeason;
    /**
     * The SeasonEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeasonEndDate;
    /**
     * The SeasonStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeasonStartDate;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Ticketing.SeriesSeason
     * @uses Ticketing_SeriesSeason::setAclSchemeId()
     * @uses Ticketing_SeriesSeason::setHoldSeatsForRenewStatus()
     * @uses Ticketing_SeriesSeason::setIsActive()
     * @uses Ticketing_SeriesSeason::setName()
     * @uses Ticketing_SeriesSeason::setOrganizationUnitId()
     * @uses Ticketing_SeriesSeason::setPreviousSeason()
     * @uses Ticketing_SeriesSeason::setSeasonEndDate()
     * @uses Ticketing_SeriesSeason::setSeasonStartDate()
     * @uses Ticketing_SeriesSeason::setVisibleBySubordinates()
     * @param int $aclSchemeId
     * @param string $holdSeatsForRenewStatus
     * @param bool $isActive
     * @param \patest\StructType\GlobalString $name
     * @param string $organizationUnitId
     * @param string $previousSeason
     * @param string $seasonEndDate
     * @param string $seasonStartDate
     * @param bool $visibleBySubordinates
     */
    public function __construct($aclSchemeId = null, $holdSeatsForRenewStatus = null, $isActive = null, \patest\StructType\GlobalString $name = null, $organizationUnitId = null, $previousSeason = null, $seasonEndDate = null, $seasonStartDate = null, $visibleBySubordinates = null)
    {
        $this
            ->setAclSchemeId($aclSchemeId)
            ->setHoldSeatsForRenewStatus($holdSeatsForRenewStatus)
            ->setIsActive($isActive)
            ->setName($name)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPreviousSeason($previousSeason)
            ->setSeasonEndDate($seasonEndDate)
            ->setSeasonStartDate($seasonStartDate)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\Ticketing_SeriesSeason
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get HoldSeatsForRenewStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHoldSeatsForRenewStatus()
    {
        return isset($this->HoldSeatsForRenewStatus) ? $this->HoldSeatsForRenewStatus : null;
    }
    /**
     * Set HoldSeatsForRenewStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\HoldSeatsForRenewStatus::valueIsValid()
     * @uses \patest\EnumType\HoldSeatsForRenewStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $holdSeatsForRenewStatus
     * @return \patest\StructType\Ticketing_SeriesSeason
     */
    public function setHoldSeatsForRenewStatus($holdSeatsForRenewStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\HoldSeatsForRenewStatus::valueIsValid($holdSeatsForRenewStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\HoldSeatsForRenewStatus', is_array($holdSeatsForRenewStatus) ? implode(', ', $holdSeatsForRenewStatus) : var_export($holdSeatsForRenewStatus, true), implode(', ', \patest\EnumType\HoldSeatsForRenewStatus::getValidValues())), __LINE__);
        }
        if (is_null($holdSeatsForRenewStatus) || (is_array($holdSeatsForRenewStatus) && empty($holdSeatsForRenewStatus))) {
            unset($this->HoldSeatsForRenewStatus);
        } else {
            $this->HoldSeatsForRenewStatus = $holdSeatsForRenewStatus;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Ticketing_SeriesSeason
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Ticketing_SeriesSeason
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Ticketing_SeriesSeason
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get PreviousSeason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreviousSeason()
    {
        return isset($this->PreviousSeason) ? $this->PreviousSeason : null;
    }
    /**
     * Set PreviousSeason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $previousSeason
     * @return \patest\StructType\Ticketing_SeriesSeason
     */
    public function setPreviousSeason($previousSeason = null)
    {
        // validation for constraint: string
        if (!is_null($previousSeason) && !is_string($previousSeason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($previousSeason, true), gettype($previousSeason)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($previousSeason) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $previousSeason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($previousSeason, true)), __LINE__);
        }
        if (is_null($previousSeason) || (is_array($previousSeason) && empty($previousSeason))) {
            unset($this->PreviousSeason);
        } else {
            $this->PreviousSeason = $previousSeason;
        }
        return $this;
    }
    /**
     * Get SeasonEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonEndDate()
    {
        return isset($this->SeasonEndDate) ? $this->SeasonEndDate : null;
    }
    /**
     * Set SeasonEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonEndDate
     * @return \patest\StructType\Ticketing_SeriesSeason
     */
    public function setSeasonEndDate($seasonEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($seasonEndDate) && !is_string($seasonEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonEndDate, true), gettype($seasonEndDate)), __LINE__);
        }
        if (is_null($seasonEndDate) || (is_array($seasonEndDate) && empty($seasonEndDate))) {
            unset($this->SeasonEndDate);
        } else {
            $this->SeasonEndDate = $seasonEndDate;
        }
        return $this;
    }
    /**
     * Get SeasonStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonStartDate()
    {
        return isset($this->SeasonStartDate) ? $this->SeasonStartDate : null;
    }
    /**
     * Set SeasonStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonStartDate
     * @return \patest\StructType\Ticketing_SeriesSeason
     */
    public function setSeasonStartDate($seasonStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($seasonStartDate) && !is_string($seasonStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonStartDate, true), gettype($seasonStartDate)), __LINE__);
        }
        if (is_null($seasonStartDate) || (is_array($seasonStartDate) && empty($seasonStartDate))) {
            unset($this->SeasonStartDate);
        } else {
            $this->SeasonStartDate = $seasonStartDate;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Ticketing_SeriesSeason
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
